/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.graph;

import at.ssw.visualizer.cfg.graph.CfgScene;
import at.ssw.visualizer.cfg.graph.EdgeWidget;
import at.ssw.visualizer.cfg.graph.NodeWidget;
import at.ssw.visualizer.cfg.model.CfgEdge;
import at.ssw.visualizer.cfg.model.CfgNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.TwoStateHoverProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class EdgeSwitchWidget
extends Widget {
    private static final Color color_enabled = Color.gray;
    private static final Color color_hover = Color.lightGray;
    private float width = 1.0f;
    private float height = 1.0f;
    private CfgScene scene;
    private NodeWidget nodeWidget;
    private boolean output;
    private WidgetAction hoverAction;
    private static final String TT_HIDE_EDGES = "Hide Edges";
    private static final String TT_SHOW_EDGES = "Show Edges";
    private static SelectProvider selectProvider = EdgeSwitchWidget.createSelectProvider();

    public EdgeSwitchWidget(CfgScene scene, NodeWidget nodeWidget, boolean output) {
        super((Scene)scene);
        WidgetAction wa;
        this.scene = scene;
        this.output = output;
        this.nodeWidget = nodeWidget;
        this.getActions().addAction(ActionFactory.createSelectAction((SelectProvider)selectProvider));
        TsHover ts = new TsHover(this);
        this.hoverAction = wa = ActionFactory.createHoverAction((TwoStateHoverProvider)ts);
        this.getActions().addAction(wa);
        scene.getActions().addAction(wa);
        this.setToolTipText(TT_HIDE_EDGES);
        this.setForeground(color_enabled);
        this.setState(ObjectState.createNormal());
    }

    protected Rectangle calculateClientArea() {
        if (this.nodeWidget.getBounds() == null) {
            return new Rectangle(0, 0, 1, 1);
        }
        int hw = (int)(this.width / 2.0f);
        int hh = (int)(this.height / 2.0f);
        return new Rectangle(-hw, -hh, 2 * hw, 2 * hh);
    }

    public void updatePosition() {
        if (this.nodeWidget.getBounds() != null) {
            this.width = this.nodeWidget.getBounds().width * 9;
            this.width /= 10.0f;
            this.height = this.nodeWidget.getBounds().height / 4;
            int offset = (int)(2.0f * (this.height / 3.0f));
            Rectangle bounds = this.nodeWidget.getBounds();
            Point location = this.nodeWidget.getLocation();
            Point newLoc = new Point();
            newLoc.x = location.x;
            newLoc.y = this.output ? location.y + bounds.height / 2 + offset : location.y - bounds.height / 2 - offset;
            this.setPreferredLocation(newLoc);
        }
    }

    private Collection<CfgEdge> getEdges() {
        CfgNode node = this.nodeWidget.getNodeModel();
        Collection edges = this.output ? this.scene.findNodeEdges(node, true, false) : this.scene.findNodeEdges(node, false, true);
        return edges;
    }

    public void changeEdgeVisibility(boolean visible) {
        Collection<CfgEdge> edges = this.getEdges();
        for (CfgEdge e : edges) {
            EdgeWidget ew = (EdgeWidget)this.scene.findWidget(e);
            if (visible == ew.isEdgeVisible()) continue;
            ew.setEdgeVisible(visible);
            if (this.output) {
                this.scene.getInputSwitch(e.getTargetNode()).updateStatus();
                continue;
            }
            this.scene.getOutputSwitch(e.getSourceNode()).updateStatus();
        }
        if (visible) {
            this.setToolTipText(TT_HIDE_EDGES);
        } else {
            this.setToolTipText(TT_SHOW_EDGES);
        }
        this.setForeground(color_enabled);
        this.bringToBack();
        ObjectState os = this.getState();
        this.setState(os.deriveSelected(!visible));
    }

    private void updateStatus() {
        ObjectState os;
        Collection<CfgEdge> edges = this.getEdges();
        boolean hiddenFound = false;
        for (CfgEdge e : edges) {
            EdgeWidget ew = (EdgeWidget)this.scene.findWidget(e);
            if (ew.isVisible()) continue;
            hiddenFound = true;
            break;
        }
        if ((os = this.getState()).isSelected() && !hiddenFound) {
            this.setState(os.deriveSelected(false));
            this.setToolTipText(TT_HIDE_EDGES);
        } else if (!os.isSelected() && hiddenFound) {
            this.setState(os.deriveSelected(true));
            this.setToolTipText(TT_SHOW_EDGES);
        }
        this.revalidate();
    }

    public void startPreview() {
        ObjectState os = this.getState();
        for (CfgEdge e : this.getEdges()) {
            EdgeWidget ew = (EdgeWidget)this.scene.findWidget(e);
            if (os.isSelected() && ew.isVisible()) continue;
            ObjectState edgeState = ew.getState();
            ew.setState(edgeState.deriveHighlighted(true));
        }
    }

    public void endPreview() {
        for (CfgEdge e : this.getEdges()) {
            EdgeWidget ew = (EdgeWidget)this.scene.findWidget(e);
            ObjectState os = ew.getState();
            ew.setState(os.deriveHighlighted(false));
        }
    }

    public void switchEdges() {
        this.endPreview();
        ObjectState os = this.getState();
        Collection<CfgEdge> edges = this.getEdges();
        ArrayList<CfgEdge> updates = new ArrayList<CfgEdge>();
        boolean visible = os.isSelected();
        this.setState(os.deriveSelected(!visible));
        for (CfgEdge e : edges) {
            EdgeWidget ew = (EdgeWidget)this.scene.findWidget(e);
            if (ew.isEdgeVisible() == visible) continue;
            updates.add(e);
            ew.setEdgeVisible(visible);
            if (this.output) {
                this.scene.getInputSwitch(e.getTargetNode()).updateStatus();
                continue;
            }
            this.scene.getOutputSwitch(e.getSourceNode()).updateStatus();
        }
        if (visible) {
            this.setToolTipText(TT_HIDE_EDGES);
        } else {
            this.setToolTipText(TT_SHOW_EDGES);
        }
        this.scene.fireSelectionChanged();
        this.revalidate();
    }

    public void paintWidget() {
        ObjectState os = this.getState();
        if (!os.isHovered() && !os.isSelected()) {
            return;
        }
        float hw = this.width / 2.0f;
        Polygon pol = new Polygon();
        pol.addPoint(0, (int)(-this.height) / 2);
        pol.addPoint((int)hw, (int)this.height / 2);
        pol.addPoint((int)(-hw), (int)this.height / 2);
        Graphics2D gr = this.getGraphics();
        gr.setColor(this.getForeground());
        BasicStroke bs = new BasicStroke(2.0f, 1, 1);
        gr.setStroke(bs);
        AffineTransform previousTransform = gr.getTransform();
        if (this.output) {
            if (os.isSelected()) {
                gr.scale(1.0, -1.0);
            }
        } else if (os.isHovered() && !os.isSelected()) {
            gr.scale(1.0, -1.0);
        }
        gr.fillPolygon(pol);
        gr.setTransform(previousTransform);
    }

    protected void finalize() throws Throwable {
        this.getScene().getActions().removeAction(this.hoverAction);
        this.getActions().removeAction(this.hoverAction);
    }

    public String toString() {
        return "EDGESWITCH(" + this.nodeWidget.getNodeModel().toString() + ")";
    }

    private static SelectProvider createSelectProvider() {
        return new SelectProvider(){

            public boolean isAimingAllowed(Widget arg0, Point arg1, boolean arg2) {
                return false;
            }

            public boolean isSelectionAllowed(Widget arg0, Point arg1, boolean arg2) {
                return true;
            }

            public void select(Widget w, Point arg1, boolean arg2) {
                if (w instanceof EdgeSwitchWidget) {
                    EdgeSwitchWidget tw = (EdgeSwitchWidget)w;
                    tw.switchEdges();
                }
            }
        };
    }

    private class TsHover
    implements TwoStateHoverProvider {
        EdgeSwitchWidget tw;

        TsHover(EdgeSwitchWidget tw) {
            this.tw = tw;
        }

        public void unsetHovering(Widget w) {
            w.setForeground(color_enabled);
            ObjectState state = w.getState();
            w.setState(state.deriveWidgetHovered(false));
            w.bringToBack();
            EdgeSwitchWidget.this.endPreview();
        }

        public void setHovering(Widget w) {
            ObjectState state = w.getState();
            w.setState(state.deriveWidgetHovered(true));
            w.setForeground(color_hover);
            w.bringToFront();
            EdgeSwitchWidget.this.nodeWidget.bringToFront();
            EdgeSwitchWidget.this.startPreview();
        }
    }
}

