/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.preferences;

import at.ssw.visualizer.cfg.preferences.CfgPreferences;
import at.ssw.visualizer.cfg.preferences.CfgPreferencesDefaults;
import at.ssw.visualizer.cfg.preferences.ColorChooserButton;
import at.ssw.visualizer.cfg.preferences.FlagsEditorPanel;
import at.ssw.visualizer.cfg.preferences.FlagsSetting;
import at.ssw.visualizer.cfg.preferences.FontChooserDialog;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CFGOptionsPanel
extends JPanel {
    List<ConfigurationElement> elements = new ArrayList<ConfigurationElement>();

    public CFGOptionsPanel() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel cfgPanel = new JPanel(new GridBagLayout());
        this.addColorChooser(cfgPanel, "Background color: ", new ColorChooser("backgroundColorPreference"){

            @Override
            public void apply() {
                CfgPreferences.getInstance().setBackgroundColor(this.getColor());
            }

            @Override
            public void update() {
                this.originalColor = CfgPreferences.getInstance().getBackgroundColor();
                this.setColor(this.originalColor);
            }

            @Override
            public void reset() {
                this.setColor(CfgPreferencesDefaults.DEFAULT_BACKGROUND_COLOR);
            }
        });
        this.addColorChooser(cfgPanel, "Back edge color: ", new ColorChooser("backEdgeColorPreference"){

            @Override
            public void apply() {
                CfgPreferences.getInstance().setBackedgeColor(this.getColor());
            }

            @Override
            public void update() {
                this.originalColor = CfgPreferences.getInstance().getBackedgeColor();
                this.setColor(this.originalColor);
            }

            @Override
            public void reset() {
                this.setColor(CfgPreferencesDefaults.DEFAULT_BACKEDGE_COLOR);
            }
        });
        this.addColorChooser(cfgPanel, "Edge color: ", new ColorChooser("edgeColorPreference"){

            @Override
            public void apply() {
                CfgPreferences.getInstance().setEdgeColor(this.getColor());
            }

            @Override
            public void update() {
                this.originalColor = CfgPreferences.getInstance().getEdgeColor();
                this.setColor(this.originalColor);
            }

            @Override
            public void reset() {
                this.setColor(CfgPreferencesDefaults.DEFAULT_EDGE_COLOR);
            }
        });
        this.addColorChooser(cfgPanel, "Exception edge color: ", new ColorChooser("exceptionEdgeColorPreference"){

            @Override
            public void apply() {
                CfgPreferences.getInstance().setExceptionEdgeColor(this.getColor());
            }

            @Override
            public void update() {
                this.originalColor = CfgPreferences.getInstance().getExceptionEdgeColor();
                this.setColor(this.originalColor);
            }

            @Override
            public void reset() {
                this.setColor(CfgPreferencesDefaults.DEFAULT_EXCEPTIONEDGE_COLOR);
            }
        });
        this.addColorChooser(cfgPanel, "Node color: ", new ColorChooser("nodeColorPreference"){

            @Override
            public void apply() {
                CfgPreferences.getInstance().setNodeColor(this.getColor());
            }

            @Override
            public void update() {
                this.originalColor = CfgPreferences.getInstance().getNodeColor();
                this.setColor(this.originalColor);
            }

            @Override
            public void reset() {
                this.setColor(CfgPreferencesDefaults.DEFAUT_NODE_COLOR);
            }
        });
        this.addColorChooser(cfgPanel, "Text color: ", new ColorChooser("textColorPreference"){

            @Override
            public void apply() {
                CfgPreferences.getInstance().setTextColor(this.getColor());
            }

            @Override
            public void update() {
                this.originalColor = CfgPreferences.getInstance().getTextColor();
            }

            @Override
            public void reset() {
                this.setColor(CfgPreferencesDefaults.DEFAULT_TEXT_COLOR);
            }
        });
        this.addColorChooser(cfgPanel, "Border color: ", new ColorChooser("borderColorPreference"){

            @Override
            public void apply() {
                CfgPreferences.getInstance().setBorderColor(this.getColor());
            }

            @Override
            public void update() {
                this.originalColor = CfgPreferences.getInstance().getBorderColor();
                this.setColor(this.originalColor);
            }

            @Override
            public void reset() {
                this.setColor(CfgPreferencesDefaults.DEFAULT_BORDER_COLOR);
            }
        });
        this.addColorChooser(cfgPanel, "Selected Nodes color: ", new ColorChooser("selectionColorFgPreference"){

            @Override
            public void apply() {
                CfgPreferences.getInstance().setSelectionColorForeground(this.getColor());
            }

            @Override
            public void update() {
                this.originalColor = CfgPreferences.getInstance().getSelectionColorForeground();
                this.setColor(this.originalColor);
            }

            @Override
            public void reset() {
                this.setColor(CfgPreferencesDefaults.DEFAULT_SELECTION_COLOR_FOREGROUND);
            }
        });
        this.addColorChooser(cfgPanel, "Selection Rect color: ", new ColorChooser("selectionColorBgPreference"){

            @Override
            public void apply() {
                CfgPreferences.getInstance().setSelectionColorBackground(this.getColor());
            }

            @Override
            public void update() {
                this.originalColor = CfgPreferences.getInstance().getSelectionColorBackground();
                this.setColor(this.originalColor);
            }

            @Override
            public void reset() {
                this.setColor(CfgPreferencesDefaults.DEFAULT_SELECTION_COLOR_BACKGROUND);
            }
        });
        this.addFontChooser(cfgPanel, "Text font: ", new FontChooser("textFontPreference"){

            @Override
            public void apply() {
                CfgPreferences.getInstance().setTextFont(this.getSelectedFont());
            }

            @Override
            public void update() {
                this.originalFont = CfgPreferences.getInstance().getTextFont();
                this.setSelectedFont(this.originalFont);
            }

            @Override
            public void reset() {
                this.setSelectedFont(CfgPreferencesDefaults.DEFAULT_TEXT_FONT);
            }
        });
        this.addFlagsEditor(cfgPanel, "Flags: ");
        this.add(cfgPanel);
        Box hBox = new Box(0);
        hBox.add(new JButton(new ResetAction()));
        hBox.add(Box.createHorizontalGlue());
        this.add(hBox);
        this.add(Box.createVerticalGlue());
    }

    public void update() {
        for (ConfigurationElement e : this.elements) {
            e.update();
        }
    }

    public void cancel() {
        for (ConfigurationElement e : this.elements) {
            e.update();
        }
    }

    public void applyChanges() {
        for (ConfigurationElement e : this.elements) {
            if (!e.isChanged()) continue;
            e.apply();
        }
    }

    public boolean isDataValid() {
        return true;
    }

    public boolean isChanged() {
        for (ConfigurationElement e : this.elements) {
            if (!e.isChanged()) continue;
            return true;
        }
        return false;
    }

    public void loadDefault() {
        for (ConfigurationElement e : this.elements) {
            e.reset();
        }
    }

    private void addColorChooser(JComponent c, String displayName, ColorChooser chooser) {
        GridBagLayout layout = (GridBagLayout)c.getLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        constraints.anchor = 13;
        JLabel label = new JLabel(displayName, 11);
        layout.setConstraints(label, constraints);
        c.add(label);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        layout.setConstraints(chooser, constraints);
        c.add(chooser);
        this.elements.add(chooser);
        label.setLabelFor(chooser);
    }

    private void addFontChooser(JComponent c, String displayName, FontChooser chooser) {
        GridBagLayout layout = (GridBagLayout)c.getLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        constraints.anchor = 13;
        JLabel label = new JLabel(displayName, 11);
        layout.setConstraints(label, constraints);
        c.add(label);
        constraints.insets = new Insets(3, 3, 3, 1);
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        layout.setConstraints(chooser.getPreview(), constraints);
        c.add(chooser.getPreview());
        constraints.insets = new Insets(3, 1, 3, 3);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.gridwidth = 0;
        layout.setConstraints(chooser.getButton(), constraints);
        c.add(chooser.getButton());
        this.elements.add(chooser);
        label.setLabelFor(chooser.getButton());
    }

    private void addFlagsEditor(JComponent c, String displayName) {
        GridBagLayout layout = (GridBagLayout)c.getLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        constraints.anchor = 12;
        FlagsEditor flagsEditor = new FlagsEditor();
        JLabel flagsLabel = new JLabel(displayName, 11);
        flagsLabel.setVerticalAlignment(1);
        layout.setConstraints(flagsLabel, constraints);
        c.add(flagsLabel);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.gridwidth = 0;
        layout.setConstraints(flagsEditor, constraints);
        c.add(flagsEditor);
        this.elements.add(flagsEditor);
        flagsLabel.setLabelFor(flagsEditor);
    }

    abstract class ColorChooser
    extends ColorChooserButton
    implements ConfigurationElement {
        Color originalColor;
        String propertyName;

        public ColorChooser(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public boolean isChanged() {
            return !this.originalColor.equals(this.getColor());
        }

        @Override
        public abstract void apply();

        @Override
        public abstract void update();
    }

    abstract class FontChooser
    implements ConfigurationElement,
    ActionListener {
        Font originalFont;
        Font selectedFont;
        String propertyName;
        JTextField preview;
        JButton button;

        public FontChooser(String propertyName) {
            this.propertyName = propertyName;
            this.preview = new JTextField("");
            this.preview.setEditable(false);
            this.button = new JButton("...");
            this.button.setMargin(new Insets(0, 0, 0, 0));
            this.button.addActionListener(this);
        }

        @Override
        public boolean isChanged() {
            return !this.originalFont.equals(this.selectedFont);
        }

        @Override
        public abstract void apply();

        @Override
        public abstract void update();

        @Override
        public abstract void reset();

        public JTextField getPreview() {
            return this.preview;
        }

        public JButton getButton() {
            return this.button;
        }

        public Font getSelectedFont() {
            return this.selectedFont;
        }

        public void setSelectedFont(Font f) {
            this.selectedFont = f;
            this.preview.setText(this.fontToString(f));
            this.preview.revalidate();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setSelectedFont(FontChooserDialog.show(this.selectedFont));
        }

        public String fontToString(Font font) {
            StringBuffer sb = new StringBuffer();
            sb.append(font.getName());
            sb.append(" ");
            sb.append(font.getSize());
            if (font.isBold()) {
                sb.append(" bold");
            }
            if (font.isItalic()) {
                sb.append(" italic");
            }
            return sb.toString();
        }
    }

    class ResetAction
    extends AbstractAction {
        public ResetAction() {
            super("Reset");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CFGOptionsPanel.this.loadDefault();
        }
    }

    static interface ConfigurationElement {
        public boolean isChanged();

        public void apply();

        public void update();

        public void reset();
    }

    class FlagsEditor
    extends FlagsEditorPanel
    implements ConfigurationElement {
        FlagsSetting originalFlags;

        public FlagsEditor() {
            super((String)null);
        }

        @Override
        public boolean isChanged() {
            return !this.originalFlags.getFlagString().equals(this.getFlagString());
        }

        @Override
        public void apply() {
            CfgPreferences.getInstance().setFlagsSetting(new FlagsSetting(this.getFlagString()));
            this.update();
        }

        @Override
        public void update() {
            this.originalFlags = CfgPreferences.getInstance().getFlagsSetting();
            this.setFlagString(this.originalFlags.getFlagString());
        }

        @Override
        public void reset() {
            FlagsSetting defaultFlags = new FlagsSetting("std(224,224,128);osr(224,224,0);ex(128,128,224);sr(128,224,128);llh(224,128,128);lle(224,192,192);plh(128,224,128);bb(160,0,0);ces(192,192,192)");
            this.setFlagString(defaultFlags.getFlagString());
            this.colorButton.setColor(this.getParent().getBackground());
        }
    }
}

