/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;

public class ColorChooserButton
extends JButton
implements ActionListener {
    public static final Dimension ICON_SIZE = new Dimension(24, 8);
    Color color;
    boolean colorChooserEnabled = true;

    public ColorChooserButton() {
        this(Color.black);
    }

    public ColorChooserButton(Color defaultColor) {
        this.setIcon(new ColorBoxIcon());
        this.addActionListener(this);
        this.color = defaultColor;
        Dimension size = new Dimension(ICON_SIZE);
        size.width += this.getInsets().left + this.getInsets().right;
        size.height += this.getInsets().top + this.getInsets().bottom;
        this.setPreferredSize(size);
    }

    public void setColor(Color newColor) {
        this.color = newColor;
        this.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isColorChooserEnabled() {
        return this.colorChooserEnabled;
    }

    public void setColorChooserEnabled(boolean enabled) {
        this.colorChooserEnabled = enabled;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.colorChooserEnabled) {
            return;
        }
        Color c = JColorChooser.showDialog(this, "Choose color", this.color);
        if (c != null) {
            this.setColor(c);
        }
    }

    class ColorBoxIcon
    implements Icon {
        ColorBoxIcon() {
        }

        @Override
        public int getIconWidth() {
            return ColorChooserButton.ICON_SIZE.width;
        }

        @Override
        public int getIconHeight() {
            return ColorChooserButton.ICON_SIZE.height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color oldColor = g.getColor();
            g.translate(x, y);
            g.setColor(ColorChooserButton.this.color);
            g.fillRect(0, 0, ColorChooserButton.ICON_SIZE.width, ColorChooserButton.ICON_SIZE.height);
            g.setColor(Color.black);
            g.drawRect(0, 0, ColorChooserButton.ICON_SIZE.width, ColorChooserButton.ICON_SIZE.height);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }
}

