/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.preferences;

import java.awt.Color;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;

public class FlagsSetting
implements Serializable {
    private Hashtable<String, Color> flag2color;
    private Hashtable<String, Integer> priority;
    private String flagString;

    public FlagsSetting(String flagString) {
        this.flagString = flagString;
        this.flag2color = new Hashtable();
        this.priority = new Hashtable();
        String[] flags = flagString.split(";");
        int z = 0;
        for (String s : flags) {
            String flag = s.split("\\(")[0];
            Color c = FlagsSetting.toColor(s);
            this.flag2color.put(flag, c);
            this.priority.put(flag, z);
            ++z;
        }
    }

    public Color getColor(List<String> strings) {
        int minPriority = Integer.MAX_VALUE;
        Color result = null;
        for (String s : strings) {
            int curPriority;
            Color curColor = this.flag2color.get(s);
            if (curColor == null || (curPriority = this.priority.get(s).intValue()) >= minPriority) continue;
            minPriority = curPriority;
            result = curColor;
        }
        return result;
    }

    public static Color toColor(String s) {
        String[] sArr = s.split("\\(");
        String Color2 = sArr[1].substring(0, sArr[1].length() - 1);
        String[] ColorArr = Color2.split(",");
        int r = Integer.parseInt(ColorArr[0]);
        int g = Integer.parseInt(ColorArr[1]);
        int b = Integer.parseInt(ColorArr[2]);
        return new Color(r, g, b);
    }

    public String getFlagString() {
        return this.flagString;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + (this.flagString != null ? this.flagString.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "FlagSetting[" + this.flagString + "]";
    }
}

