/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.nc.model;

import at.ssw.visualizer.nc.model.NCTokenContext;
import at.ssw.visualizer.texteditor.model.Scanner;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.editor.TokenID;

public class NCScanner
extends Scanner {
    private Set<String> registerNames = new HashSet<String>();

    public NCScanner() {
        super("\n\r\t ,;:()$[]", NCTokenContext.contextPath);
        this.registerNames.add("eax");
        this.registerNames.add("ebx");
        this.registerNames.add("ecx");
        this.registerNames.add("edx");
        this.registerNames.add("esi");
        this.registerNames.add("edi");
        this.registerNames.add("esp");
        this.registerNames.add("ebp");
        this.registerNames.add("rax");
        this.registerNames.add("rbx");
        this.registerNames.add("rcx");
        this.registerNames.add("rdx");
        this.registerNames.add("rsi");
        this.registerNames.add("rdi");
        this.registerNames.add("rsp");
        this.registerNames.add("rbp");
        this.registerNames.add("r8");
        this.registerNames.add("r9");
        this.registerNames.add("r10");
        this.registerNames.add("r11");
        this.registerNames.add("r12");
        this.registerNames.add("r13");
        this.registerNames.add("r14");
        this.registerNames.add("r15");
        this.registerNames.add("r8d");
        this.registerNames.add("r9d");
        this.registerNames.add("r10d");
        this.registerNames.add("r11d");
        this.registerNames.add("r12d");
        this.registerNames.add("r13d");
        this.registerNames.add("r14d");
        this.registerNames.add("r15d");
        this.registerNames.add("xmm0");
        this.registerNames.add("xmm1");
        this.registerNames.add("xmm2");
        this.registerNames.add("xmm3");
        this.registerNames.add("xmm4");
        this.registerNames.add("xmm5");
        this.registerNames.add("xmm6");
        this.registerNames.add("xmm7");
        this.registerNames.add("xmm8");
        this.registerNames.add("xmm9");
        this.registerNames.add("xmm10");
        this.registerNames.add("xmm11");
        this.registerNames.add("xmm12");
        this.registerNames.add("xmm13");
        this.registerNames.add("xmm14");
        this.registerNames.add("xmm15");
    }

    private boolean isBlock() {
        return this.expectChar('B') && this.expectChar(DIGIT) && this.expectChars(DIGIT) && this.expectEnd() || this.expectChar('L') && this.expectChar(DIGIT) && this.expectChars(DIGIT) && this.expectEnd();
    }

    private boolean isAddress() {
        return this.expectChar('0') && this.expectChar('x') && this.expectChar(HEX) && this.expectChars(HEX) && this.expectEnd();
    }

    private boolean isRegister() {
        return this.expectChar('%') && this.expectChar(LETTER) && this.expectChars(LETTER_DIGIT) && this.expectEnd() || this.isKeyword(this.registerNames);
    }

    private boolean isInstruction() {
        boolean result;
        boolean bl = result = (this.beforeChar(':') || this.beforeChars(DIGIT)) && this.expectChar(LC_LETTER) && this.expectChars(LC_LETTER_DIGIT);
        while (result && this.ch == ' ' && this.offset + 1 < this.stopOffset && LC_LETTER.get(this.buffer[this.offset + 1])) {
            this.readNext();
            result = this.expectChars(LC_LETTER_DIGIT);
        }
        return result && this.expectEnd();
    }

    private boolean isComment() {
        boolean startFound = false;
        for (int curOffset = this.offset; curOffset >= 0 && this.buffer[curOffset] != '\n'; --curOffset) {
            if (this.buffer[curOffset] != ';') continue;
            startFound = true;
            this.tokenOffset = curOffset;
        }
        if (!startFound) {
            return false;
        }
        while (this.ch != '\n' && this.ch != '\u0000') {
            this.readNext();
        }
        return true;
    }

    protected TokenID parseToken() {
        this.findTokenBegin();
        if (this.ch == '\u0000') {
            return NCTokenContext.EOF_TOKEN;
        }
        if (this.isComment()) {
            return NCTokenContext.COMMENT_TOKEN;
        }
        if (this.isWhitespace()) {
            return NCTokenContext.WHITESPACE_TOKEN;
        }
        if (this.isBlock()) {
            return NCTokenContext.BLOCK_TOKEN;
        }
        if (this.isAddress()) {
            return NCTokenContext.ADDRESS_TOKEN;
        }
        if (this.isRegister()) {
            return NCTokenContext.REGISTER_TOKEN;
        }
        if (this.isInstruction()) {
            return NCTokenContext.INSTRUCTION_TOKEN;
        }
        this.readToWhitespace();
        return NCTokenContext.OTHER_TOKEN;
    }
}

