/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.max.hcfdis;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HexCodeFile {
    public static final String NEW_LINE = "\n";
    public static final String SECTION_DELIM = " <||@";
    public static final Pattern SECTION = Pattern.compile("(\\S+)\\s+(.*)", 32);
    public static final Pattern COMMENT;
    public static final Pattern OPERAND_COMMENT;
    public static final Pattern JUMP_TABLE;
    public static final Pattern LOOKUP_TABLE;
    public static final Pattern HEX_CODE;
    public static final Pattern PLATFORM;
    public static final String EMBEDDED_HCF_OPEN = "<<<HexCodeFile";
    public static final String EMBEDDED_HCF_CLOSE = "HexCodeFile>>>";
    public final Map<Integer, List<String>> comments = new TreeMap<Integer, List<String>>();
    public final Map<Integer, List<String>> operandComments = new TreeMap<Integer, List<String>>();
    public final byte[] code;
    public final ArrayList<JumpTable> jumpTables = new ArrayList();
    public final ArrayList<LookupTable> lookupTables = new ArrayList();
    public final String isa;
    public final int wordWidth;
    public final long startAddress;

    public HexCodeFile(byte[] code, long startAddress, String isa, int wordWidth) {
        this.code = code;
        this.startAddress = startAddress;
        this.isa = isa;
        this.wordWidth = wordWidth;
    }

    public static HexCodeFile parse(String input, int sourceOffset, String source, String sourceName) {
        return new Parser((String)input, (int)sourceOffset, (String)source, (String)sourceName).hcf;
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeTo(baos);
        return baos.toString();
    }

    public void writeTo(OutputStream out) {
        int pos;
        PrintStream ps = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out);
        ps.printf("Platform %s %d %s%n", this.isa, this.wordWidth, SECTION_DELIM);
        ps.printf("HexCode %x %s %s%n", this.startAddress, HexCodeFile.hexCodeString(this.code), SECTION_DELIM);
        for (JumpTable jumpTable : this.jumpTables) {
            ps.printf("JumpTable %d %d %d %d %s%n", new Object[]{jumpTable.position, jumpTable.entryFormat, jumpTable.low, jumpTable.high, SECTION_DELIM});
        }
        for (LookupTable lookupTable : this.lookupTables) {
            ps.printf("LookupTable %d %d %d %d %s%n", lookupTable.position, lookupTable.npairs, lookupTable.keySize, lookupTable.keySize, SECTION_DELIM);
        }
        for (Map.Entry entry : this.comments.entrySet()) {
            pos = (Integer)entry.getKey();
            for (String comment : (List)entry.getValue()) {
                ps.printf("Comment %d %s %s%n", pos, comment, SECTION_DELIM);
            }
        }
        for (Map.Entry entry : this.operandComments.entrySet()) {
            pos = (Integer)entry.getKey();
            for (String comment : (List)entry.getValue()) {
                ps.printf("OperandComment %d %s %s%n", pos, comment, SECTION_DELIM);
            }
        }
        ps.flush();
    }

    public static String hexCodeString(byte[] code) {
        StringBuilder sb = new StringBuilder(code.length * 2);
        for (byte b : code) {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public void addComment(int pos, String comment) {
        List list = this.comments.computeIfAbsent(pos, k -> new ArrayList());
        list.add(HexCodeFile.encodeString(comment));
    }

    public void addOperandComment(int pos, String comment) {
        List list = this.operandComments.computeIfAbsent(pos, k -> new ArrayList());
        list.add(HexCodeFile.encodeString(comment));
    }

    public static String encodeString(String string) {
        int index;
        Object s = string;
        while ((index = ((String)s).indexOf(SECTION_DELIM)) != -1) {
            s = ((String)s).substring(0, index) + " < |@" + ((String)s).substring(index + SECTION_DELIM.length());
        }
        return s;
    }

    static {
        OPERAND_COMMENT = COMMENT = Pattern.compile("(\\d+)\\s+(.*)", 32);
        JUMP_TABLE = Pattern.compile("(\\d+)\\s+(\\S+)\\s+(-{0,1}\\d+)\\s+(-{0,1}\\d+)\\s*");
        LOOKUP_TABLE = Pattern.compile("(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s*");
        HEX_CODE = Pattern.compile("(\\p{XDigit}+)(?:\\s+(\\p{XDigit}*))?");
        PLATFORM = Pattern.compile("(\\S+)\\s+(\\S+)", 32);
    }

    static class Parser {
        final String input;
        final String inputSource;
        String isa;
        int wordWidth;
        byte[] code;
        long startAddress;
        HexCodeFile hcf;

        Parser(String input, int sourceOffset, String source, String sourceName) {
            this.input = input;
            this.inputSource = sourceName;
            this.parseSections(sourceOffset, source);
        }

        void makeHCF() {
            if (this.hcf == null && this.isa != null && this.wordWidth != 0 && this.code != null) {
                this.hcf = new HexCodeFile(this.code, this.startAddress, this.isa, this.wordWidth);
            }
        }

        void checkHCF(String section, int offset) {
            this.check(this.hcf != null, offset, section + " section must be after Platform and HexCode section");
        }

        void check(boolean condition, int offset, String message) {
            if (!condition) {
                throw this.error(offset, message);
            }
        }

        Error error(int offset, String message) {
            throw new Error(this.errorMessage(offset, message));
        }

        String errorMessage(int offset, String message) {
            assert (offset < this.input.length());
            InputPos inputPos = this.filePos(offset);
            int lineEnd = this.input.indexOf(HexCodeFile.NEW_LINE, offset);
            int lineStart = offset - inputPos.col;
            String line = lineEnd == -1 ? this.input.substring(lineStart) : this.input.substring(lineStart, lineEnd);
            return String.format("%s:%d: %s%n%s%n%" + (inputPos.col + 1) + "s", this.inputSource, inputPos.line, message, line, "^");
        }

        InputPos filePos(int index) {
            assert (this.input != null);
            int lineStart = this.input.lastIndexOf(HexCodeFile.NEW_LINE, index) + 1;
            int pos = this.input.indexOf(HexCodeFile.NEW_LINE);
            int line = 1;
            while (pos > 0 && pos < index) {
                ++line;
                pos = this.input.indexOf(HexCodeFile.NEW_LINE, pos + 1);
            }
            return new InputPos(line, index - lineStart);
        }

        void parseSections(int offset, String source) {
            assert (this.input.startsWith(source, offset));
            int index = 0;
            int endIndex = source.indexOf(HexCodeFile.SECTION_DELIM);
            while (endIndex != -1) {
                while (source.charAt(index) <= ' ') {
                    ++index;
                }
                String section = source.substring(index, endIndex).trim();
                this.parseSection(offset + index, section);
                index = endIndex + HexCodeFile.SECTION_DELIM.length();
                endIndex = source.indexOf(HexCodeFile.SECTION_DELIM, index);
            }
        }

        int parseInt(int offset, String value) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw this.error(offset, "Not a valid integer: " + value);
            }
        }

        void parseSection(int offset, String section) {
            if (section.isEmpty()) {
                return;
            }
            assert (this.input.startsWith(section, offset));
            Matcher m = SECTION.matcher(section);
            this.check(m.matches(), offset, "Section does not match pattern " + SECTION);
            String header = m.group(1);
            String body = m.group(2);
            int headerOffset = offset + m.start(1);
            int bodyOffset = offset + m.start(2);
            switch (header) {
                case "Platform": {
                    this.check(this.isa == null, bodyOffset, "Duplicate Platform section found");
                    m = PLATFORM.matcher(body);
                    this.check(m.matches(), bodyOffset, "Platform does not match pattern " + PLATFORM);
                    this.isa = m.group(1);
                    this.wordWidth = this.parseInt(bodyOffset + m.start(2), m.group(2));
                    this.makeHCF();
                    break;
                }
                case "HexCode": {
                    this.check(this.code == null, bodyOffset, "Duplicate Code section found");
                    m = HEX_CODE.matcher(body);
                    this.check(m.matches(), bodyOffset, "Code does not match pattern " + HEX_CODE);
                    String hexAddress = m.group(1);
                    this.startAddress = new BigInteger(hexAddress, 16).longValue();
                    String hexCode = m.group(2);
                    if (hexCode == null) {
                        this.code = new byte[0];
                    } else {
                        this.check(hexCode.length() % 2 == 0, bodyOffset, "Hex code length must be even");
                        this.code = new byte[hexCode.length() / 2];
                        for (int i = 0; i < this.code.length; ++i) {
                            String hexByte = hexCode.substring(i * 2, (i + 1) * 2);
                            this.code[i] = (byte)Integer.parseInt(hexByte, 16);
                        }
                    }
                    this.makeHCF();
                    break;
                }
                case "Comment": {
                    this.checkHCF("Comment", headerOffset);
                    m = COMMENT.matcher(body);
                    this.check(m.matches(), bodyOffset, "Comment does not match pattern " + COMMENT);
                    int pos = this.parseInt(bodyOffset + m.start(1), m.group(1));
                    String comment = m.group(2);
                    this.hcf.addComment(pos, comment);
                    break;
                }
                case "OperandComment": {
                    this.checkHCF("OperandComment", headerOffset);
                    m = OPERAND_COMMENT.matcher(body);
                    this.check(m.matches(), bodyOffset, "OperandComment does not match pattern " + OPERAND_COMMENT);
                    int pos = this.parseInt(bodyOffset + m.start(1), m.group(1));
                    String comment = m.group(2);
                    this.hcf.addOperandComment(pos, comment);
                    break;
                }
                case "JumpTable": {
                    this.checkHCF("JumpTable", headerOffset);
                    m = JUMP_TABLE.matcher(body);
                    this.check(m.matches(), bodyOffset, "JumpTable does not match pattern " + JUMP_TABLE);
                    int pos = this.parseInt(bodyOffset + m.start(1), m.group(1));
                    JumpTable.EntryFormat entryFormat = this.parseJumpTableEntryFormat(m, bodyOffset);
                    int low = this.parseInt(bodyOffset + m.start(3), m.group(3));
                    int high = this.parseInt(bodyOffset + m.start(4), m.group(4));
                    this.hcf.jumpTables.add(new JumpTable(pos, low, high, entryFormat));
                    break;
                }
                case "LookupTable": {
                    this.checkHCF("LookupTable", headerOffset);
                    m = LOOKUP_TABLE.matcher(body);
                    this.check(m.matches(), bodyOffset, "LookupTable does not match pattern " + LOOKUP_TABLE);
                    int pos = this.parseInt(bodyOffset + m.start(1), m.group(1));
                    int npairs = this.parseInt(bodyOffset + m.start(2), m.group(2));
                    int keySize = this.parseInt(bodyOffset + m.start(3), m.group(3));
                    int offsetSize = this.parseInt(bodyOffset + m.start(4), m.group(4));
                    this.hcf.lookupTables.add(new LookupTable(pos, npairs, keySize, offsetSize));
                    break;
                }
                default: {
                    throw this.error(offset, "Unknown section header: " + header);
                }
            }
        }

        private JumpTable.EntryFormat parseJumpTableEntryFormat(Matcher m, int bodyOffset) throws Error {
            JumpTable.EntryFormat entryFormat;
            String entryFormatName = m.group(2);
            if ("4".equals(entryFormatName)) {
                entryFormat = JumpTable.EntryFormat.OFFSET;
            } else if ("8".equals(entryFormatName)) {
                entryFormat = JumpTable.EntryFormat.KEY2_OFFSET;
            } else {
                try {
                    entryFormat = JumpTable.EntryFormat.valueOf(entryFormatName);
                }
                catch (IllegalArgumentException e) {
                    throw this.error(bodyOffset + m.start(2), "Not a valid " + JumpTable.EntryFormat.class.getSimpleName() + " value: " + entryFormatName);
                }
            }
            return entryFormat;
        }

        static class InputPos {
            final int line;
            final int col;

            InputPos(int line, int col) {
                this.line = line;
                this.col = col;
            }
        }
    }

    public static final class JumpTable
    extends CodeAnnotation {
        private static final long serialVersionUID = -6520017513070589383L;
        public final int low;
        public final int high;
        public final EntryFormat entryFormat;

        public JumpTable(int position, int low, int high, EntryFormat entryFormat) {
            super(position);
            if (high <= low) {
                throw new IllegalArgumentException(String.format("low (%d) is not less than high(%d)", low, high));
            }
            this.low = low;
            this.high = high;
            this.entryFormat = entryFormat;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + this.position + ": [" + this.low + " .. " + this.high + "]";
        }

        public static enum EntryFormat {
            OFFSET(4),
            KEY2_OFFSET(8);

            public final int size;

            private EntryFormat(int size) {
                this.size = size;
            }
        }
    }

    public static final class LookupTable
    extends CodeAnnotation {
        private static final long serialVersionUID = 6797908737446993328L;
        public final int npairs;
        public final int keySize;
        public final int offsetSize;

        public LookupTable(int position, int npairs, int keySize, int offsetSize) {
            super(position);
            this.npairs = npairs;
            this.keySize = keySize;
            this.offsetSize = offsetSize;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + this.position + ": [npairs=" + this.npairs + ", keySize=" + this.keySize + ", offsetSize=" + this.offsetSize + "]";
        }
    }

    public static abstract class CodeAnnotation
    implements Serializable {
        private static final long serialVersionUID = 928798596620568715L;
        public final int position;

        public CodeAnnotation(int position) {
            this.position = position;
        }

        public int getPosition() {
            return this.position;
        }
    }
}

