/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.core.selection;

import at.ssw.visualizer.core.selection.Selection;
import javax.swing.event.ChangeListener;

public class SelectionManager {
    private static final SelectionManager SINGLETON = new SelectionManager();
    private final Selection emptySelection;
    private Selection curSelection;

    public static SelectionManager getDefault() {
        return SINGLETON;
    }

    private SelectionManager() {
        this.curSelection = this.emptySelection = new Selection();
    }

    public Selection getCurSelection() {
        return this.curSelection;
    }

    public void setSelection(Selection sel) {
        if (this.curSelection != sel) {
            this.curSelection = sel;
            this.fireChangeEvent();
        }
    }

    public void removeSelection(Selection sel) {
        if (this.curSelection == sel) {
            this.curSelection = this.emptySelection;
            this.fireChangeEvent();
        }
    }

    protected void fireChangeEvent() {
        this.emptySelection.fireChangeEvent();
    }

    public void addChangeListener(ChangeListener listener) {
        this.emptySelection.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.emptySelection.removeChangeListener(listener);
    }
}

