/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.ir.view;

import at.ssw.visualizer.ir.IREditorKit;
import at.ssw.visualizer.ir.model.IRTextBuilder;
import at.ssw.visualizer.model.cfg.BasicBlock;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import at.ssw.visualizer.texteditor.EditorKit;
import at.ssw.visualizer.texteditor.view.AbstractTextViewTopComponent;
import java.io.Serializable;
import org.openide.windows.WindowManager;

final class LIRViewTopComponent
extends AbstractTextViewTopComponent {
    private static final String PREFERRED_ID = "LIRViewTopComponent";
    private static LIRViewTopComponent instance;

    private LIRViewTopComponent() {
        super((EditorKit)new IREditorKit());
        this.setName("LIR");
        this.setToolTipText("Low-level Intermediate Representation");
    }

    protected String getContent(ControlFlowGraph cfg, BasicBlock[] blocks) {
        IRTextBuilder builder = new IRTextBuilder();
        return builder.buildLir(cfg, blocks);
    }

    public static synchronized LIRViewTopComponent getDefault() {
        if (instance == null) {
            instance = new LIRViewTopComponent();
        }
        return instance;
    }

    public static synchronized LIRViewTopComponent findInstance() {
        return (LIRViewTopComponent)WindowManager.getDefault().findTopComponent(PREFERRED_ID);
    }

    public int getPersistenceType() {
        return 0;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return LIRViewTopComponent.getDefault();
        }
    }
}

