/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.dataflow.layout;

import at.ssw.dataflow.layout.ExternalGraphLayouter;
import at.ssw.dataflow.layout.RoutingHelper;
import at.ssw.dataflow.layout.doublePoint;
import at.ssw.dataflow.options.BooleanStringValidator;
import at.ssw.dataflow.options.DoubleStringValidator;
import at.ssw.dataflow.options.IntStringValidator;
import at.ssw.dataflow.options.Validator;
import at.ssw.positionmanager.Cluster;
import at.ssw.positionmanager.LayoutGraph;
import at.ssw.positionmanager.Link;
import at.ssw.positionmanager.Vertex;
import at.ssw.visualizer.graphhelper.DiGraph;
import at.ssw.visualizer.graphhelper.Edge;
import at.ssw.visualizer.graphhelper.Node;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;

public class CompoundForceLayouter
implements ExternalGraphLayouter {
    private double SPRINGLEN = 50.0;
    private double STIFFNESS = 15.0;
    private double REPULSION = 100.0;
    private double SPRINGLENEXP = 50.0;
    private double STIFFNESSEXP = 15.0;
    private double REPULSIONEXP = 300.0;
    private double OVERCLUSTERSPRINGLEN = 70.0;
    private double OVERCLUSTERSTIFFNESS = 15.0;
    private double OVERCLUSTERREPULSION = 200.0;
    private double CLUSTERSPRINGLEN = 50.0;
    private double CLUSTERSTIFFNESS = 15.0;
    private double CLUSTERREPULSION = 100.0;
    private double INTERCLUSTERSPRINGLEN = 300.0;
    private double INTERCLUSTERSTIFFNESS = 30.0;
    private double INTERCLUSTERREPULSION = 800.0;
    private double MAXIMUMMOVEMENT = 500.0;
    private int PADDING = 30;
    private int ITERATIONS = 100;
    private long SEED = 133L;
    private boolean USELOGSPRINGS = false;
    private boolean USECURRENTNODEPOSITIONS = false;
    private Hashtable<String, Point2D> posList;
    private static String[] options = new String[]{"Componentpadding", "Springlength", "Over Cl. Sp.Length", "Virtual Springlength", "Stiffness", "Over Cl. Stiffness", "Virtual Stiffness", "Iterations", "Repulsion", "Over Cl. Repulsion", "Virtual Repulsion", "Seed", "Log. Springs"};
    private static String[] descriptions = new String[]{"Minimum space between connected components", "Length of the spring between nodes in the same cluster", "Length of the spring between nodes in different clusters", "Length of the spring between virtual nodes", "Stiffness of the spring between the nodes in the same cluster", "Stiffness of the spring between the nodes in different clusters", "Stiffness of the spring between the virtual nodes", "Relaxation iterations the algorithm performs", "Repulsion between nodes in the same cluster", "Repulsion between nodes in different clusters", "Repulsion between vitual nodes", "Seed for the random prepositioning", "Logarithmic spring simulation is used?"};
    private static Class[] optionclass = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class};
    private static Validator[] validators = new Validator[]{new IntStringValidator(0, 1000), new DoubleStringValidator(0.0, 1000.0), new DoubleStringValidator(0.0, 1000.0), new DoubleStringValidator(0.0, 1000.0), new DoubleStringValidator(0.0, 1000.0), new DoubleStringValidator(0.0, 1000.0), new DoubleStringValidator(0.0, 1000.0), new IntStringValidator(0, 5000), new DoubleStringValidator(0.0, 10000.0), new DoubleStringValidator(0.0, 10000.0), new DoubleStringValidator(0.0, 10000.0), new IntStringValidator(0, Integer.MAX_VALUE), new BooleanStringValidator()};

    public void doLayout(LayoutGraph graph) {
        Hashtable<String, Vertex> idtoverticles = new Hashtable<String, Vertex>();
        Hashtable<Vertex, String> verticlestoid = new Hashtable<Vertex, String>();
        DiGraph dg = new DiGraph();
        Iterator iter = graph.getVertices().iterator();
        int i = 0;
        while (iter.hasNext()) {
            String id = String.valueOf(i);
            dg.addNode(new Node(id));
            Vertex v = (Vertex)iter.next();
            idtoverticles.put(id, v);
            verticlestoid.put(v, id);
            ++i;
        }
        for (Link l : graph.getLinks()) {
            String from = (String)verticlestoid.get(l.getFrom().getVertex());
            String to = (String)verticlestoid.get(l.getTo().getVertex());
            dg.addEdge(new Edge(dg.getNode(from), dg.getNode(to)));
        }
        iter = graph.getVertices().iterator();
        Hashtable<Cluster, Node> virtualNodes = new Hashtable<Cluster, Node>();
        Node defaultNode = new Node(String.valueOf(i++));
        dg.addNode(defaultNode);
        boolean defNodeUsed = false;
        while (iter.hasNext()) {
            Node vn;
            Vertex v = (Vertex)iter.next();
            Cluster c = v.getCluster();
            if (c == null) {
                vn = defaultNode;
                defNodeUsed = true;
            } else if (virtualNodes.containsKey(c)) {
                vn = (Node)virtualNodes.get(c);
            } else {
                String id = String.valueOf(i++);
                vn = new Node(id);
                virtualNodes.put(c, vn);
                dg.addNode(vn);
            }
            dg.addEdge(new Edge(vn, dg.getNode((String)verticlestoid.get(v))));
        }
        HashSet<String> vNodes = new HashSet<String>();
        for (Node n : virtualNodes.values()) {
            vNodes.add(n.ID);
        }
        if (!defNodeUsed) {
            dg.removeNode(defaultNode);
        } else {
            vNodes.add(defaultNode.ID);
        }
        for (Cluster c : virtualNodes.keySet()) {
            if (c.getSuccessors() == null) continue;
            for (Cluster c1 : c.getSuccessors()) {
                dg.addEdge(new Edge((Node)virtualNodes.get(c), (Node)virtualNodes.get(c1)));
            }
        }
        this.layout(graph, dg, idtoverticles, verticlestoid, vNodes);
    }

    private void layout(LayoutGraph lg, DiGraph digraph, Hashtable<String, Vertex> idtoverticles, Hashtable<Vertex, String> verticlestoid, HashSet<String> vNodes) {
        int lastmax = 0;
        int max = 0;
        for (DiGraph dg : digraph.getConnectedComponents()) {
            this.posList = new Hashtable();
            Random rand = new Random(this.SEED);
            for (Node w : dg.getNodes()) {
                if (this.USECURRENTNODEPOSITIONS) {
                    Vertex v = idtoverticles.get(w.ID);
                    double x = 0.0;
                    double y = 0.0;
                    if (v != null) {
                        x = v.getPosition().x;
                        y = v.getPosition().y;
                    }
                    this.posList.put(w.ID, new doublePoint(x, y));
                    continue;
                }
                this.posList.put(w.ID, new doublePoint(rand.nextDouble() * 300.0, rand.nextDouble() * 300.0));
            }
            for (int i = 0; i < this.ITERATIONS; ++i) {
                for (Node n : dg.getNodes()) {
                    this.relaxation(n, dg, vNodes, idtoverticles);
                }
            }
            double smallestX = Double.MAX_VALUE;
            double smallestY = Double.MAX_VALUE;
            for (Node w : dg.getNodes()) {
                Point2D p = this.posList.get(w.ID);
                if (smallestX > p.getX()) {
                    smallestX = p.getX();
                }
                if (!(smallestY > p.getY())) continue;
                smallestY = p.getY();
            }
            max = 0;
            for (Node w : dg.getNodes()) {
                Vertex v = idtoverticles.get(w.ID);
                if (v == null) continue;
                Point2D p = this.posList.get(w.ID);
                int x = (int)(p.getX() - smallestX) + lastmax + this.PADDING;
                int y = (int)(p.getY() - smallestY) + this.PADDING;
                if (x + v.getSize().width > max) {
                    max = x + v.getSize().width;
                }
                v.setPosition(new Point(x, y));
            }
            lastmax = max;
        }
    }

    private void relaxation(Node n, DiGraph dg, HashSet<String> vNodes, Hashtable<String, Vertex> idtoverticles) {
        double X = this.posList.get(n.ID).getX();
        double Y = this.posList.get(n.ID).getY();
        LinkedList<Node> adjacentVertices = new LinkedList<Node>();
        Vertex v = idtoverticles.get(n.ID);
        for (Node pre : n.pred) {
            if (n.ID.equals(pre.ID)) continue;
            adjacentVertices.add(pre);
        }
        for (Node succ : n.succ) {
            if (n.ID.equals(succ.ID)) continue;
            adjacentVertices.add(succ);
        }
        double SpringX = 0.0;
        double SpringY = 0.0;
        for (Node adjacent : adjacentVertices) {
            double springlen;
            double stiffness;
            if (vNodes.contains(n.ID) || vNodes.contains(adjacent.ID)) {
                if (vNodes.contains(n.ID) && vNodes.contains(adjacent.ID)) {
                    stiffness = this.INTERCLUSTERSTIFFNESS;
                    springlen = this.INTERCLUSTERSPRINGLEN;
                } else {
                    stiffness = this.CLUSTERSTIFFNESS;
                    springlen = this.CLUSTERSPRINGLEN;
                }
            } else {
                Vertex v1 = idtoverticles.get(adjacent.ID);
                if (v1 != null && v != null && v1.getCluster() != v.getCluster()) {
                    stiffness = this.OVERCLUSTERSTIFFNESS;
                    springlen = this.OVERCLUSTERSPRINGLEN;
                } else if (v1 != null && v != null && (v1.isExpanded() || v.isExpanded())) {
                    stiffness = this.STIFFNESSEXP;
                    springlen = this.SPRINGLENEXP;
                } else {
                    stiffness = this.STIFFNESS;
                    springlen = this.SPRINGLEN;
                }
            }
            double adjX = this.posList.get(adjacent.ID).getX();
            double adjY = this.posList.get(adjacent.ID).getY();
            double distance = Point2D.distance(adjX, adjY, X, Y);
            if (distance == 0.0) {
                distance = 0.01;
            }
            if (this.USELOGSPRINGS) {
                SpringX += stiffness * Math.log(distance / springlen) * ((X - adjX) / distance);
                SpringY += stiffness * Math.log(distance / springlen) * ((Y - adjY) / distance);
                continue;
            }
            SpringX += stiffness * ((distance - springlen) / (2.0 * springlen)) * ((X - adjX) / distance);
            SpringY += stiffness * ((distance - springlen) / (2.0 * springlen)) * ((Y - adjY) / distance);
        }
        double RepulsionX = 0.0;
        double RepulsionY = 0.0;
        for (Node w : dg.getNodes()) {
            Vertex v1;
            if (w == n) continue;
            double repulsion = vNodes.contains(n.ID) || vNodes.contains(w.ID) ? (vNodes.contains(n.ID) && vNodes.contains(w.ID) ? this.INTERCLUSTERREPULSION : this.CLUSTERREPULSION) : ((v1 = idtoverticles.get(w.ID)) != null && v != null && v1.getCluster() != v.getCluster() ? this.OVERCLUSTERREPULSION : (v1 != null && v != null && (v1.isExpanded() || v.isExpanded()) ? this.REPULSIONEXP : this.REPULSION));
            double nX = this.posList.get(w.ID).getX();
            double nY = this.posList.get(w.ID).getY();
            double distance = Point2D.distance(nX, nY, X, Y);
            if (distance == 0.0) {
                distance = 0.01;
            }
            RepulsionX -= repulsion / distance * ((X - nX) / distance);
            RepulsionY -= repulsion / distance * ((Y - nY) / distance);
        }
        double dx = -(SpringX + RepulsionX);
        double dy = -(SpringY + RepulsionY);
        if (dx > this.MAXIMUMMOVEMENT) {
            dx = this.MAXIMUMMOVEMENT;
        }
        if (dx * -1.0 > this.MAXIMUMMOVEMENT) {
            dx = -this.MAXIMUMMOVEMENT;
        }
        if (dy > this.MAXIMUMMOVEMENT) {
            dy = this.MAXIMUMMOVEMENT;
        }
        if (dy * -1.0 > this.MAXIMUMMOVEMENT) {
            dy = -this.MAXIMUMMOVEMENT;
        }
        Point2D p = this.posList.get(n.ID);
        p.setLocation(p.getX() + dx, p.getY() + dy);
    }

    public void doRouting(LayoutGraph graph) {
        RoutingHelper.doRouting(graph);
    }

    @Override
    public boolean isClusteringSupported() {
        return true;
    }

    @Override
    public boolean isAnimationSupported() {
        return true;
    }

    @Override
    public boolean isMovementSupported() {
        return true;
    }

    @Override
    public void setUseCurrentNodePositions(boolean b) {
        this.USECURRENTNODEPOSITIONS = b;
    }

    @Override
    public String[] getOptionKeys() {
        return options;
    }

    @Override
    public boolean setOption(String key, Object value) {
        if (key == null) {
            return false;
        }
        int i = this.getIndexForKey(key);
        if (i == -1) {
            return false;
        }
        if (validators[i].validate(value)) {
            switch (i) {
                case 0: {
                    this.PADDING = Integer.parseInt((String)value);
                    break;
                }
                case 1: {
                    this.SPRINGLEN = Double.parseDouble((String)value);
                    break;
                }
                case 2: {
                    this.OVERCLUSTERSPRINGLEN = Double.parseDouble((String)value);
                    break;
                }
                case 3: {
                    this.INTERCLUSTERSPRINGLEN = Double.parseDouble((String)value);
                    break;
                }
                case 4: {
                    this.STIFFNESS = Double.parseDouble((String)value);
                    break;
                }
                case 5: {
                    this.OVERCLUSTERSTIFFNESS = Double.parseDouble((String)value);
                    break;
                }
                case 6: {
                    this.INTERCLUSTERSTIFFNESS = Double.parseDouble((String)value);
                    break;
                }
                case 7: {
                    this.ITERATIONS = Integer.parseInt((String)value);
                    break;
                }
                case 8: {
                    this.REPULSION = Double.parseDouble((String)value);
                    break;
                }
                case 9: {
                    this.OVERCLUSTERREPULSION = Double.parseDouble((String)value);
                    break;
                }
                case 10: {
                    this.INTERCLUSTERREPULSION = Double.parseDouble((String)value);
                    break;
                }
                case 11: {
                    this.SEED = Integer.parseInt((String)value);
                    break;
                }
                case 12: {
                    this.USELOGSPRINGS = Boolean.parseBoolean((String)value);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public Object getOption(String key) {
        if (key == null) {
            return null;
        }
        int i = this.getIndexForKey(key);
        switch (i) {
            case 0: {
                return String.valueOf(this.PADDING);
            }
            case 1: {
                return String.valueOf(this.SPRINGLEN);
            }
            case 2: {
                return String.valueOf(this.OVERCLUSTERSPRINGLEN);
            }
            case 3: {
                return String.valueOf(this.INTERCLUSTERSPRINGLEN);
            }
            case 4: {
                return String.valueOf(this.STIFFNESS);
            }
            case 5: {
                return String.valueOf(this.OVERCLUSTERSTIFFNESS);
            }
            case 6: {
                return String.valueOf(this.INTERCLUSTERSTIFFNESS);
            }
            case 7: {
                return String.valueOf(this.ITERATIONS);
            }
            case 8: {
                return String.valueOf(this.REPULSION);
            }
            case 9: {
                return String.valueOf(this.OVERCLUSTERREPULSION);
            }
            case 10: {
                return String.valueOf(this.INTERCLUSTERREPULSION);
            }
            case 11: {
                return String.valueOf(this.SEED);
            }
            case 12: {
                return String.valueOf(this.USELOGSPRINGS);
            }
        }
        return null;
    }

    public int getIndexForKey(String key) {
        for (int i = 0; i < options.length; ++i) {
            String o = options[i];
            if (!o.equals(key)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getOptionDescription(String key) {
        if (key == null) {
            return null;
        }
        for (int i = 0; i < descriptions.length && i < options.length; ++i) {
            if (!key.equals(options[i])) continue;
            return descriptions[i];
        }
        return null;
    }

    @Override
    public Validator getOptionValidator(String key) {
        if (key == null) {
            return null;
        }
        for (int i = 0; i < validators.length && i < options.length; ++i) {
            if (!key.equals(options[i])) continue;
            return validators[i];
        }
        return null;
    }

    @Override
    public Class getOptionClass(String key) {
        if (key == null) {
            return null;
        }
        for (int i = 0; i < optionclass.length && i < options.length; ++i) {
            if (!key.equals(options[i])) continue;
            return optionclass[i];
        }
        return null;
    }
}

