/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.dataflow.layout;

import at.ssw.dataflow.layout.ExternalGraphLayouter;
import at.ssw.dataflow.layout.RoutingHelper;
import at.ssw.dataflow.options.IntStringValidator;
import at.ssw.dataflow.options.Validator;
import at.ssw.positionmanager.Cluster;
import at.ssw.positionmanager.LayoutGraph;
import at.ssw.positionmanager.Link;
import at.ssw.positionmanager.Vertex;
import at.ssw.visualizer.graphhelper.DiGraph;
import at.ssw.visualizer.graphhelper.Node;
import java.awt.Point;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.CompoundDirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Subgraph;

public class CompoundHierarchicalNodesLayouter
implements ExternalGraphLayouter {
    private static final int TOP_BORDER = 20;
    private static final int LEFT_BORDER = 20;
    private int PADDING = 50;
    private int SUBGRAPHINSET = 10;
    private static final String DEFAULTCLUSTER = "DEFAULT";
    private static final String TOPCLUSTER = "TOP";
    private static String[] options = new String[]{"Padding"};
    private static String[] descriptions = new String[]{"Minimum space between nodes"};
    private static Class[] optionclass = new Class[]{String.class};
    private static Validator paddingValidator = new IntStringValidator(0, 1000);

    public void doLayout(LayoutGraph graph) {
        Hashtable<String, Vertex> idtoverticles = new Hashtable<String, Vertex>();
        Hashtable<Vertex, String> verticlestoid = new Hashtable<Vertex, String>();
        DiGraph dg = new DiGraph();
        Iterator iter = graph.getVertices().iterator();
        int i = 0;
        while (iter.hasNext()) {
            String id = String.valueOf(i);
            dg.addNode(new Node(id));
            Vertex v = (Vertex)iter.next();
            idtoverticles.put(id, v);
            verticlestoid.put(v, id);
            ++i;
        }
        for (Link l : graph.getLinks()) {
            String from = verticlestoid.get(l.getFrom().getVertex());
            String to = verticlestoid.get(l.getTo().getVertex());
            dg.addEdge(new at.ssw.visualizer.graphhelper.Edge(dg.getNode(from), dg.getNode(to)));
        }
        this.layout(graph, dg, idtoverticles, verticlestoid);
    }

    private void layout(LayoutGraph lg, DiGraph digraph, Hashtable<String, Vertex> idtoverticles, Hashtable<Vertex, String> verticlestoid) {
        int lastmax = 0;
        int max = 0;
        for (DiGraph dg : digraph.getConnectedComponents()) {
            CompoundDirectedGraph cdg = new CompoundDirectedGraph();
            Subgraph top = new Subgraph(TOPCLUSTER);
            Subgraph defaultG = new Subgraph(DEFAULTCLUSTER, top);
            defaultG.innerPadding = new Insets(this.SUBGRAPHINSET, this.SUBGRAPHINSET, this.SUBGRAPHINSET, this.SUBGRAPHINSET);
            cdg.nodes.add(defaultG);
            cdg.nodes.add(top);
            Hashtable<Cluster, Subgraph> subgraphs = new Hashtable<Cluster, Subgraph>();
            Hashtable<String, org.eclipse.draw2d.graph.Node> nodelist = new Hashtable<String, org.eclipse.draw2d.graph.Node>();
            for (Node n : dg.getNodes()) {
                Subgraph sg;
                Vertex v = idtoverticles.get(n.ID);
                Cluster c = v.getCluster();
                if (c == null) {
                    sg = defaultG;
                } else if (subgraphs.containsKey(c)) {
                    sg = (Subgraph)subgraphs.get(c);
                } else {
                    sg = new Subgraph(c.toString(), top);
                    sg.innerPadding = new Insets(this.SUBGRAPHINSET, this.SUBGRAPHINSET, this.SUBGRAPHINSET, this.SUBGRAPHINSET);
                    subgraphs.put(c, sg);
                    cdg.nodes.add(sg);
                }
                org.eclipse.draw2d.graph.Node node = new org.eclipse.draw2d.graph.Node(v, sg);
                node.width = v.getSize().width;
                node.height = v.getSize().height;
                node.setPadding(new Insets(this.PADDING, this.PADDING, this.PADDING, this.PADDING));
                cdg.nodes.add(node);
                nodelist.put(n.ID, node);
            }
            for (at.ssw.visualizer.graphhelper.Edge e : dg.getEdges()) {
                org.eclipse.draw2d.graph.Node n1 = (org.eclipse.draw2d.graph.Node)nodelist.get(e.source.ID);
                org.eclipse.draw2d.graph.Node n2 = (org.eclipse.draw2d.graph.Node)nodelist.get(e.destination.ID);
                if (n1.getParent() != n2.getParent()) {
                    cdg.edges.add(new Edge(n1.getParent(), n2.getParent()));
                }
                cdg.edges.add(new Edge(n1, n2));
            }
            CompoundDirectedGraphLayout layout = new CompoundDirectedGraphLayout();
            layout.visit(cdg);
            lastmax += max;
            max = 0;
            for (int i = 0; i < cdg.nodes.size(); ++i) {
                org.eclipse.draw2d.graph.Node n = cdg.nodes.getNode(i);
                assert (n.data != null);
                if (!(n.data instanceof Vertex)) continue;
                Vertex v = (Vertex)n.data;
                Point p = new Point(lastmax + n.x + 20, n.y + 20);
                int width = v.getSize().width;
                if (n.x + width > max) {
                    max = n.x + width;
                }
                v.setPosition(p);
            }
        }
    }

    public void doRouting(LayoutGraph graph) {
        RoutingHelper.doRouting(graph);
    }

    @Override
    public boolean isClusteringSupported() {
        return true;
    }

    @Override
    public boolean isAnimationSupported() {
        return true;
    }

    @Override
    public boolean isMovementSupported() {
        return true;
    }

    @Override
    public void setUseCurrentNodePositions(boolean b) {
    }

    @Override
    public String[] getOptionKeys() {
        return options;
    }

    @Override
    public boolean setOption(String key, Object value) {
        if (key != null && key.equals(options[0]) && paddingValidator.validate(value)) {
            this.PADDING = Integer.parseInt((String)value);
            return true;
        }
        return false;
    }

    @Override
    public Validator getOptionValidator(String key) {
        if (key != null && key.equals(options[0])) {
            return paddingValidator;
        }
        return null;
    }

    @Override
    public String getOptionDescription(String key) {
        if (key == null) {
            return null;
        }
        for (int i = 0; i < descriptions.length && i < options.length; ++i) {
            if (!key.equals(options[i])) continue;
            return descriptions[i];
        }
        return null;
    }

    @Override
    public Object getOption(String key) {
        if (key != null && key.equals(options[0])) {
            return String.valueOf(this.PADDING);
        }
        return null;
    }

    @Override
    public Class getOptionClass(String key) {
        if (key == null) {
            return null;
        }
        for (int i = 0; i < optionclass.length && i < options.length; ++i) {
            if (!key.equals(options[i])) continue;
            return optionclass[i];
        }
        return null;
    }
}

