/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.graphanalyzer.positioning;

import at.ssw.positionmanager.Cluster;
import at.ssw.positionmanager.Link;
import at.ssw.positionmanager.Port;
import at.ssw.positionmanager.Vertex;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClusterNode
implements Vertex {
    private Cluster cluster;
    private Port inputSlot;
    private Port outputSlot;
    private Set<Vertex> subNodes = new HashSet<Vertex>();
    private Dimension size;
    private Point position;
    private Set<Link> subEdges = new HashSet<Link>();
    private boolean dirty;
    private boolean root;
    private String name;
    public static final int BORDER = 10;

    public ClusterNode(Cluster cluster, String name) {
        this.cluster = cluster;
        this.position = new Point(0, 0);
        this.name = name;
    }

    public void addSubNode(Vertex v) {
        this.subNodes.add(v);
    }

    public void addSubEdge(Link l) {
        this.subEdges.add(l);
    }

    public Set<Link> getSubEdges() {
        return Collections.unmodifiableSet(this.subEdges);
    }

    public void updateSize() {
        this.calculateSize();
        final ClusterNode widget = this;
        this.inputSlot = new Port(){

            public Point getRelativePosition() {
                return new Point(((ClusterNode)ClusterNode.this).size.width / 2, 0);
            }

            public Vertex getVertex() {
                return widget;
            }
        };
        this.outputSlot = new Port(){

            public Point getRelativePosition() {
                return new Point(((ClusterNode)ClusterNode.this).size.width / 2, ((ClusterNode)ClusterNode.this).size.height);
            }

            public Vertex getVertex() {
                return widget;
            }
        };
    }

    private void calculateSize() {
        if (this.subNodes.size() == 0) {
            this.size = new Dimension(0, 0);
        }
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (Vertex n : this.subNodes) {
            Point p = n.getPosition();
            minX = Math.min(minX, p.x);
            minY = Math.min(minY, p.y);
            maxX = Math.max(maxX, p.x + n.getSize().width);
            maxY = Math.max(maxY, p.y + n.getSize().height);
        }
        this.size = new Dimension(maxX - minX, maxY - minY);
        this.size.width += 20;
        this.size.height += 20;
    }

    public Port getInputSlot() {
        return this.inputSlot;
    }

    public Port getOutputSlot() {
        return this.outputSlot;
    }

    public Dimension getSize() {
        return this.size;
    }

    public Point getPosition() {
        return this.position;
    }

    public void setPosition(Point pos) {
        this.position = pos;
        for (Vertex n : this.subNodes) {
            Point cur = new Point(n.getPosition());
            cur.translate(pos.x, pos.y);
            n.setPosition(cur);
        }
        for (Link e : this.subEdges) {
            List arr = e.getControlPoints();
            ArrayList<Point> newArr = new ArrayList<Point>();
            for (Point p : arr) {
                Point p2 = new Point(p);
                p2.translate(pos.x, pos.y);
                newArr.add(p2);
            }
            e.setControlPoints(newArr);
        }
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster c) {
        this.cluster = c;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean b) {
        this.dirty = b;
    }

    public void setRoot(boolean b) {
        this.root = b;
    }

    public boolean isRoot() {
        return this.root;
    }

    public int compareTo(Vertex o) {
        return this.toString().compareTo(o.toString());
    }

    public String toString() {
        return this.name;
    }

    public Set<? extends Vertex> getSubNodes() {
        return this.subNodes;
    }

    public boolean isExpanded() {
        return false;
    }

    public boolean isFixed() {
        return false;
    }

    public boolean isMarked() {
        return false;
    }
}

