/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.graphanalyzer.positioning;

import at.ssw.graphanalyzer.positioning.ClusterEdge;
import at.ssw.graphanalyzer.positioning.ClusterIngoingConnection;
import at.ssw.graphanalyzer.positioning.ClusterInputSlotNode;
import at.ssw.graphanalyzer.positioning.ClusterNode;
import at.ssw.graphanalyzer.positioning.ClusterOutgoingConnection;
import at.ssw.graphanalyzer.positioning.ClusterOutputSlotNode;
import at.ssw.graphanalyzer.positioning.HierarchicalLayoutManager;
import at.ssw.graphanalyzer.positioning.InterClusterConnection;
import at.ssw.positionmanager.Cluster;
import at.ssw.positionmanager.LayoutGraph;
import at.ssw.positionmanager.LayoutManager;
import at.ssw.positionmanager.Link;
import at.ssw.positionmanager.Port;
import at.ssw.positionmanager.Vertex;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class HierarchicalClusterLayoutManager
implements LayoutManager {
    private HierarchicalLayoutManager.Combine combine;

    public HierarchicalClusterLayoutManager(HierarchicalLayoutManager.Combine combine) {
        this.combine = combine;
    }

    public void doLayout(LayoutGraph graph) {
        assert (graph.verify());
        HierarchicalLayoutManager subManager = new HierarchicalLayoutManager(this.combine);
        HierarchicalLayoutManager manager = new HierarchicalLayoutManager(this.combine, 150);
        Hashtable lists = new Hashtable();
        Hashtable listsConnection = new Hashtable();
        SortedSet vertices = graph.getVertices();
        Hashtable clusterInputSlotHash = new Hashtable();
        Hashtable clusterOutputSlotHash = new Hashtable();
        Hashtable<Cluster, ClusterNode> clusterNodes = new Hashtable<Cluster, ClusterNode>();
        Hashtable clusterInputSlotSet = new Hashtable();
        Hashtable clusterOutputSlotSet = new Hashtable();
        HashSet<Object> clusterEdges = new HashSet<Object>();
        HashSet<ClusterEdge> interClusterEdges = new HashSet<ClusterEdge>();
        Hashtable<Link, Object> linkClusterOutgoingConnection = new Hashtable<Link, Object>();
        Hashtable<Link, InterClusterConnection> linkInterClusterConnection = new Hashtable<Link, InterClusterConnection>();
        Hashtable<Link, ClusterIngoingConnection> linkClusterIngoingConnection = new Hashtable<Link, ClusterIngoingConnection>();
        Set cluster = graph.getClusters();
        int z = 0;
        for (Cluster c : cluster) {
            lists.put(c, new ArrayList());
            listsConnection.put(c, new ArrayList());
            clusterInputSlotHash.put(c, new Hashtable());
            clusterOutputSlotHash.put(c, new Hashtable());
            clusterOutputSlotSet.put(c, new TreeSet());
            clusterInputSlotSet.put(c, new TreeSet());
            clusterNodes.put(c, new ClusterNode(c, "" + z));
            ++z;
        }
        for (Cluster c : cluster) {
            ClusterNode start = (ClusterNode)clusterNodes.get(c);
            for (Cluster succ : c.getSuccessors()) {
                ClusterNode end = (ClusterNode)clusterNodes.get(succ);
                if (end == null) continue;
                ClusterEdge e = new ClusterEdge(start, end);
                clusterEdges.add(e);
                interClusterEdges.add(e);
            }
        }
        for (Vertex v : graph.getVertices()) {
            Cluster c = v.getCluster();
            ((ClusterNode)clusterNodes.get(c)).addSubNode(v);
        }
        for (Link l : graph.getLinks()) {
            Object conn;
            boolean needInterClusterConnection;
            Port fromPort = l.getFrom();
            Port toPort = l.getTo();
            Vertex fromVertex = fromPort.getVertex();
            Vertex toVertex = toPort.getVertex();
            Cluster fromCluster = fromVertex.getCluster();
            Cluster toCluster = toVertex.getCluster();
            Port samePort = null;
            if (this.combine == HierarchicalLayoutManager.Combine.SAME_INPUTS) {
                samePort = toPort;
            } else if (this.combine == HierarchicalLayoutManager.Combine.SAME_OUTPUTS) {
                samePort = fromPort;
            }
            assert (listsConnection.containsKey(fromCluster));
            assert (listsConnection.containsKey(toCluster));
            if (fromCluster == toCluster) {
                ((List)listsConnection.get(fromCluster)).add(l);
                ((ClusterNode)clusterNodes.get(fromCluster)).addSubEdge(l);
                continue;
            }
            ClusterInputSlotNode inputSlotNode = null;
            ClusterOutputSlotNode outputSlotNode = null;
            if (samePort != null) {
                outputSlotNode = (ClusterOutputSlotNode)((Hashtable)clusterOutputSlotHash.get(fromCluster)).get(samePort);
                inputSlotNode = (ClusterInputSlotNode)((Hashtable)clusterInputSlotHash.get(toCluster)).get(samePort);
            }
            boolean bl = needInterClusterConnection = outputSlotNode == null || inputSlotNode == null;
            if (outputSlotNode == null) {
                outputSlotNode = new ClusterOutputSlotNode((ClusterNode)clusterNodes.get(fromCluster), "Out " + fromCluster.toString() + " " + samePort.toString());
                ((Set)clusterOutputSlotSet.get(fromCluster)).add(outputSlotNode);
                conn = new ClusterOutgoingConnection(outputSlotNode, l);
                outputSlotNode.setOutgoingConnection((ClusterOutgoingConnection)conn);
                ((ClusterNode)clusterNodes.get(fromCluster)).addSubEdge((Link)conn);
                if (samePort != null) {
                    ((Hashtable)clusterOutputSlotHash.get(fromCluster)).put(samePort, outputSlotNode);
                }
                linkClusterOutgoingConnection.put(l, conn);
            } else {
                linkClusterOutgoingConnection.put(l, outputSlotNode.getOutgoingConnection());
            }
            if (inputSlotNode == null) {
                inputSlotNode = new ClusterInputSlotNode((ClusterNode)clusterNodes.get(toCluster), "In " + toCluster.toString() + " " + samePort.toString());
                ((Set)clusterInputSlotSet.get(toCluster)).add(inputSlotNode);
            }
            conn = new ClusterIngoingConnection(inputSlotNode, l);
            inputSlotNode.setIngoingConnection((ClusterIngoingConnection)conn);
            ((ClusterNode)clusterNodes.get(toCluster)).addSubEdge((Link)conn);
            if (samePort != null) {
                ((Hashtable)clusterInputSlotHash.get(toCluster)).put(samePort, inputSlotNode);
            }
            linkClusterIngoingConnection.put(l, (ClusterIngoingConnection)conn);
            InterClusterConnection interConn = new InterClusterConnection(outputSlotNode, inputSlotNode);
            linkInterClusterConnection.put(l, interConn);
            clusterEdges.add(interConn);
        }
        for (Cluster c : cluster) {
            ClusterNode n = (ClusterNode)clusterNodes.get(c);
            subManager.doLayout(new LayoutGraph(n.getSubEdges(), n.getSubNodes()), (Set)clusterInputSlotSet.get(c), (Set)clusterOutputSlotSet.get(c));
            n.updateSize();
        }
        Set roots = new LayoutGraph(interClusterEdges).findRootVertices();
        for (Vertex v : roots) {
            assert (v instanceof ClusterNode);
            ((ClusterNode)v).setRoot(true);
        }
        manager.doLayout(new LayoutGraph(clusterEdges), new HashSet(), new HashSet(), interClusterEdges);
        for (Link l : graph.getLinks()) {
            if (!linkInterClusterConnection.containsKey(l)) continue;
            ClusterOutgoingConnection conn1 = (ClusterOutgoingConnection)linkClusterOutgoingConnection.get(l);
            InterClusterConnection conn2 = (InterClusterConnection)linkInterClusterConnection.get(l);
            ClusterIngoingConnection conn3 = (ClusterIngoingConnection)linkClusterIngoingConnection.get(l);
            assert (conn1 != null);
            assert (conn2 != null);
            assert (conn3 != null);
            ArrayList<Point> points = new ArrayList<Point>();
            points.addAll(conn1.getControlPoints());
            points.addAll(conn2.getControlPoints());
            points.addAll(conn3.getControlPoints());
            l.setControlPoints(points);
        }
    }

    public void doRouting(LayoutGraph graph) {
    }
}

