/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.block.view;

import at.ssw.visualizer.model.cfg.BasicBlock;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class BlockTableModel
extends AbstractTableModel {
    public static final int BLOCK_TABLE_NAME_COL_IDX = 0;
    public static final int BLOCK_TABLE_BCI_COL_IDX = 1;
    public static final int BLOCK_TABLE_FLAGS_COL_IDX = 2;
    public static final int BLOCK_TABLE_LOOP_DEPTH_COL_IDX = 3;
    public static final int BLOCK_TABLE_LOOP_INDEX_COL_IDX = 4;
    public static final int BLOCK_TABLE_DOMINATOR_COL_IDX = 5;
    public static final int BLOCK_TABLE_PREDECESSORS_COL_IDX = 6;
    public static final int BLOCK_TABLE_SUCCESSORS_COL_IDX = 7;
    public static final int BLOCK_TABLE_XHANDLERS_COL_IDX = 8;
    public static final int BLOCK_TABLE_PROBABILITY_COL_IDX = 9;
    public static final String[] COLUMN_NAMES = new String[]{"Name", "BCI", "Flags", "Loop Depth", "Loop Index", "Dominator", "Predecessors", "Successors", "XHandlers", "Probability"};
    public static final int[] COLUMN_WIDTHS = new int[]{60, 60, 60, 80, 80, 60, 120, 120, 120};
    private List<BasicBlock> blocks = Collections.emptyList();

    public void setControlFlowGraph(ControlFlowGraph cfg) {
        this.blocks = cfg == null ? Collections.emptyList() : cfg.getBasicBlocks();
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.blocks.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        BasicBlock block = this.blocks.get(row);
        switch (column) {
            case 0: {
                return block.getName();
            }
            case 1: {
                return "[" + block.getFromBci() + ", " + block.getToBci() + "]";
            }
            case 2: {
                return this.formatFlags(block.getFlags());
            }
            case 3: {
                return Integer.toString(block.getLoopDepth());
            }
            case 4: {
                return block.getLoopDepth() > 0 ? Integer.toString(block.getLoopIndex()) : "";
            }
            case 5: {
                return block.getDominator() != null ? block.getDominator().getName() : "";
            }
            case 6: {
                return this.formatBlocks(block.getPredecessors());
            }
            case 7: {
                return this.formatBlocks(block.getSuccessors());
            }
            case 8: {
                return this.formatBlocks(block.getXhandlers());
            }
            case 9: {
                return Double.isNaN(block.getProbability()) ? "" : Double.valueOf(block.getProbability());
            }
        }
        throw new Error("invalid column");
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.blocks.isEmpty()) {
            return Object.class;
        }
        return this.getValueAt(0, columnIndex).getClass();
    }

    private String formatFlags(List<String> flags) {
        StringBuilder sb = new StringBuilder();
        String prefix = "";
        for (String flag : flags) {
            sb.append(prefix).append(flag);
            prefix = ", ";
        }
        return sb.toString();
    }

    private String formatBlocks(List<BasicBlock> blocks) {
        StringBuilder sb = new StringBuilder();
        String prefix = "";
        for (BasicBlock block : blocks) {
            sb.append(prefix).append(block.getName());
            prefix = ", ";
        }
        return sb.toString();
    }
}

