/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.graphhelper;

import at.ssw.visualizer.graphhelper.Block;
import at.ssw.visualizer.graphhelper.Edge;
import at.ssw.visualizer.graphhelper.Embedding;
import at.ssw.visualizer.graphhelper.Node;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedList;

public class DiGraph {
    protected Hashtable<String, Node> nodes = new Hashtable();
    protected LinkedList<Edge> edges = new LinkedList();
    private int dfsCount = 0;
    static final int LEFT = 1;
    static final int RIGHT = 2;
    private DiGraph BiConnected = null;
    private int cur_nr = 0;

    public void addNode(Node n) {
        this.nodes.put(n.ID, n);
    }

    public void removeNode(Node n) {
        for (Edge e : n.edges.toArray(new Edge[n.edges.size()])) {
            this.removeEdge(e);
        }
        this.nodes.remove(n.ID);
    }

    public Node getNode(String id) {
        return this.nodes.get(id);
    }

    public boolean contains(String id) {
        return this.nodes.containsKey(id);
    }

    public void addEdge(Edge e) {
        e.source.succ.add(e.destination);
        e.destination.pred.add(e.source);
        this.edges.add(e);
        e.source.edges.add(e);
        e.destination.edges.add(e);
    }

    public void removeEdge(Edge e) {
        if (e == null) {
            return;
        }
        this.edges.remove(e);
        e.source.succ.remove(e.destination);
        e.destination.pred.remove(e.source);
        e.source.edges.remove(e);
        e.destination.edges.remove(e);
    }

    public Collection<Node> getNodes() {
        return this.nodes.values();
    }

    public Collection<Edge> getEdges() {
        return this.edges;
    }

    protected Edge getEdge(Node source, Node dest) {
        for (Edge e : this.edges) {
            if (e.source != source || e.destination != dest) continue;
            return e;
        }
        return null;
    }

    public void resetNodeFlags() {
        for (Node n : this.nodes.values()) {
            n.visited = false;
        }
    }

    public DiGraph clone() {
        DiGraph c = new DiGraph();
        for (Node n : this.nodes.values()) {
            c.addNode(new Node(n.ID));
        }
        for (Edge e : this.edges) {
            c.addEdge(new Edge(c.getNode(e.source.ID), c.getNode(e.destination.ID)));
        }
        return c;
    }

    public void makeBiDirected() {
        for (Node n : this.nodes.values()) {
            for (Node s : n.succ) {
                if (n.pred.contains(s)) continue;
                this.addEdge(new Edge(s, n));
            }
            for (Node p : n.pred) {
                if (n.succ.contains(p)) continue;
                this.addEdge(new Edge(n, p));
            }
        }
    }

    public void breakBiDirection() {
        LinkedList<Edge> del = new LinkedList<Edge>();
        for (Node n : this.nodes.values()) {
            for (Node p : n.pred) {
                Edge ed;
                if (!n.succ.contains(p) || del.contains(ed = this.getEdge(n, p))) continue;
                del.add(this.getEdge(p, n));
            }
        }
        for (Edge e : del) {
            this.removeEdge(e);
        }
    }

    public Collection<DiGraph> getConnectedComponents() {
        LinkedList<DiGraph> list = new LinkedList<DiGraph>();
        this.resetNodeFlags();
        for (Node n : this.nodes.values()) {
            if (n.visited) continue;
            list.add(this.findConnctedComponent(n));
        }
        return list;
    }

    private DiGraph findConnctedComponent(Node n) {
        DiGraph dg = new DiGraph();
        this.findConnctedComponent_rek(n, dg);
        for (Edge e : this.getEdges()) {
            if (!dg.contains(e.source.ID)) continue;
            dg.addEdge(new Edge(dg.getNode(e.source.ID), dg.getNode(e.destination.ID)));
        }
        return dg;
    }

    private void findConnctedComponent_rek(Node n, DiGraph dg) {
        if (n.visited) {
            return;
        }
        n.visited = true;
        dg.addNode(new Node(n.ID));
        for (Node node : n.succ) {
            this.findConnctedComponent_rek(node, dg);
        }
        for (Node node : n.pred) {
            this.findConnctedComponent_rek(node, dg);
        }
    }

    public Collection<Node[]> getCircularDependency(Node n) {
        LinkedList<Node[]> ret = new LinkedList<Node[]>();
        LinkedList<Node> current = new LinkedList<Node>();
        this.resetNodeFlags();
        n.visited = true;
        current.add(n);
        for (Node s : n.succ) {
            this.getCircularDependency_rec(n, s, current, ret);
        }
        return ret;
    }

    private void getCircularDependency_rec(Node source, Node node, LinkedList<Node> current, LinkedList<Node[]> result) {
        if (node.visited) {
            return;
        }
        node.visited = true;
        current.addLast(node);
        for (Node n : node.succ) {
            if (n == source) {
                result.add(current.toArray(new Node[current.size()]));
                continue;
            }
            if (n.visited) continue;
            this.getCircularDependency_rec(source, n, current, result);
        }
        node.visited = false;
        current.removeLast();
    }

    public void makeBiConnected() {
        for (Node n : this.nodes.values()) {
            n.data = new BiConPayload();
        }
        this.dfsCount = 0;
        if (this.nodes.size() > 0) {
            this.dfsInMakeBiConnected(this.nodes.values().iterator().next());
        }
    }

    private void dfsInMakeBiConnected(Node n) {
        Node[] na;
        BiConPayload pl = (BiConPayload)n.data;
        pl.lowPt = pl.dfsNum = this.dfsCount++;
        pl.reached = true;
        if (n.succ.size() == 0) {
            return;
        }
        Node u = n.succ.getFirst();
        for (Node w : na = n.succ.toArray(new Node[n.succ.size()])) {
            BiConPayload plw = (BiConPayload)w.data;
            if (!plw.reached) {
                plw.parent = n;
                this.dfsInMakeBiConnected(w);
                if (plw.lowPt == pl.dfsNum) {
                    Edge e;
                    if (w == u && pl.parent != null) {
                        e = new Edge(w, pl.parent);
                        this.addEdge(e);
                        this.addEdge(e.getReverseEdge());
                    }
                    if (u != w) {
                        e = new Edge(w, u);
                        this.addEdge(e);
                        this.addEdge(e.getReverseEdge());
                    }
                }
                if (pl.lowPt <= plw.lowPt) continue;
                pl.lowPt = plw.lowPt;
                continue;
            }
            if (pl.lowPt <= plw.dfsNum) continue;
            pl.lowPt = plw.dfsNum;
        }
    }

    public String toString() {
        String ret = "Nodes: ";
        for (Node n : this.nodes.values()) {
            ret = ret + n.ID;
            if (n.data != null) {
                ret = ret + "(" + n.data + ")";
            }
            ret = ret + ", ";
        }
        ret = ret + "\nEdges: ";
        for (Edge e : this.edges) {
            ret = ret + "(" + e.source.ID + "->" + e.destination.ID + ") ";
        }
        return ret;
    }

    public boolean isPlanar() {
        boolean ret = true;
        for (DiGraph dg : this.getConnectedComponents()) {
            ret = ret && dg.planar();
        }
        return ret;
    }

    protected boolean planar() {
        int num = this.nodes.size();
        if (num <= 3) {
            return true;
        }
        if (this.edges.size() > 6 * num - 12) {
            return false;
        }
        this.makeBiDirected();
        this.makeBiConnected();
        this.BiConnected = this.clone();
        for (Node n : this.nodes.values()) {
            n.data = new PlanarityNodePayload();
        }
        for (Edge e : this.edges) {
            e.data = new PlanarityEdgePayload();
        }
        this.reorder();
        LinkedList<Integer> Att = new LinkedList<Integer>();
        if (this.nodes.size() == 0) {
            return true;
        }
        Node first = this.nodes.values().iterator().next();
        assert (first.succ.size() > 0);
        Edge firstEdge = this.getEdge(first, first.succ.getFirst());
        ((PlanarityEdgePayload)firstEdge.data).alpha = 1;
        return this.stronglyPlanar(firstEdge, Att);
    }

    private boolean stronglyPlanar(Edge e0, LinkedList<Integer> Att) {
        Node x = e0.source;
        Node y = e0.destination;
        Edge e = this.getEdge(y, y.succ.getFirst());
        Node wk = y;
        while (((PlanarityNodePayload)e.destination.data).dfsNum > ((PlanarityNodePayload)wk.data).dfsNum) {
            wk = e.destination;
            e = this.getEdge(wk, wk.succ.getFirst());
        }
        Node w0 = e.destination;
        Node w = wk;
        LinkedList<Block> S = new LinkedList<Block>();
        while (w != x) {
            int count = 0;
            for (Node r : w.succ) {
                e = this.getEdge(w, r);
                if (++count == 1) continue;
                LinkedList<Integer> A = new LinkedList<Integer>();
                if (((PlanarityNodePayload)w.data).dfsNum < ((PlanarityNodePayload)e.destination.data).dfsNum) {
                    if (!this.stronglyPlanar(e, A)) {
                        return false;
                    }
                } else {
                    A.add(new Integer(((PlanarityNodePayload)e.destination.data).dfsNum));
                }
                Block B = new Block(e, A);
                while (true) {
                    if (B.leftInterlace(S)) {
                        S.getFirst().flip();
                    }
                    if (B.leftInterlace(S)) {
                        return false;
                    }
                    if (!B.rightInterlace(S)) break;
                    B.combine(S.poll());
                }
                S.addFirst(B);
            }
            while (!S.isEmpty() && ((Block)S.getFirst()).clean(((PlanarityNodePayload)((PlanarityNodePayload)w.data).parent.data).dfsNum)) {
                S.removeFirst();
            }
            w = ((PlanarityNodePayload)w.data).parent;
        }
        Att.clear();
        while (!S.isEmpty()) {
            Block B = (Block)S.poll();
            if (!B.emptyLatt() && !B.emptyRatt() && B.headOfLatt() > ((PlanarityNodePayload)w0.data).dfsNum && B.headOfRatt() > ((PlanarityNodePayload)w0.data).dfsNum) {
                return false;
            }
            B.addToAtt(Att, ((PlanarityNodePayload)w0.data).dfsNum);
        }
        if (w0 != x) {
            Att.add(new Integer(((PlanarityNodePayload)w0.data).dfsNum));
        }
        return true;
    }

    private void reorder() {
        if (this.nodes.size() == 0) {
            return;
        }
        LinkedList<Edge> deledges = new LinkedList<Edge>();
        this.dfsCount = 0;
        this.dfsInReorder(this.nodes.values().iterator().next(), deledges);
        for (Edge e : deledges) {
            this.removeEdge(e);
        }
        for (Edge e : this.edges) {
            PlanarityNodePayload source = (PlanarityNodePayload)e.source.data;
            PlanarityNodePayload dest = (PlanarityNodePayload)e.destination.data;
            PlanarityEdgePayload epl = (PlanarityEdgePayload)e.data;
            if (dest.dfsNum < source.dfsNum) {
                epl.cost = 2 * dest.dfsNum;
                continue;
            }
            if (dest.lowpt2 >= source.dfsNum) {
                epl.cost = 2 * dest.lowpt1;
                continue;
            }
            epl.cost = 2 * dest.lowpt1 + 1;
        }
        this.sortEdges();
    }

    private void dfsInReorder(Node v, LinkedList<Edge> deledges) {
        PlanarityNodePayload wpl;
        PlanarityNodePayload vpl = (PlanarityNodePayload)v.data;
        vpl.lowpt1 = vpl.lowpt2 = (vpl.dfsNum = this.dfsCount++);
        vpl.reached = true;
        for (Node w : v.succ) {
            wpl = (PlanarityNodePayload)w.data;
            if (!wpl.reached) {
                wpl.parent = v;
                this.dfsInReorder(w, deledges);
                vpl.lowpt1 = this.Min(wpl.lowpt1, vpl.lowpt1);
                continue;
            }
            vpl.lowpt1 = this.Min(wpl.dfsNum, vpl.lowpt1);
            if (wpl.dfsNum < vpl.dfsNum && w != vpl.parent) continue;
            deledges.add(this.getEdge(v, w));
        }
        for (Node w : v.succ) {
            wpl = (PlanarityNodePayload)w.data;
            if (wpl.parent == v) {
                if (wpl.lowpt1 != vpl.lowpt1) {
                    vpl.lowpt2 = this.Min(wpl.lowpt1, vpl.lowpt2);
                }
                vpl.lowpt2 = this.Min(vpl.lowpt2, wpl.lowpt2);
                continue;
            }
            if (vpl.lowpt1 == wpl.dfsNum) continue;
            vpl.lowpt2 = this.Min(vpl.lowpt2, wpl.dfsNum);
        }
    }

    private int Min(int a, int b) {
        if (a > b) {
            return b;
        }
        return a;
    }

    private void sortEdges() {
        Edge[] e = this.edges.toArray(new Edge[this.edges.size()]);
        Arrays.sort(e, new Comparator<Edge>(){

            @Override
            public int compare(Edge e1, Edge e2) {
                if (e1 == null || e2 == null || e1.data == null || e2.data == null || !(e1.data instanceof PlanarityEdgePayload) || !(e2.data instanceof PlanarityEdgePayload)) {
                    return 0;
                }
                return ((PlanarityEdgePayload)e1.data).cost - ((PlanarityEdgePayload)e2.data).cost;
            }
        });
        for (Edge edge : e) {
            this.removeEdge(edge);
        }
        for (Edge edge : e) {
            this.addEdge(edge);
        }
    }

    public Embedding createEmbedding() {
        DiGraph G = this.clone();
        if (G.planar()) {
            if (G.nodes.size() < 4) {
                return new Embedding(this.clone());
            }
            DiGraph H = G.BiConnected;
            for (Edge e : H.edges) {
                e.data = new EmbeddingEdgePayload();
            }
            LinkedList<Edge> T = new LinkedList<Edge>();
            LinkedList<Edge> A = new LinkedList<Edge>();
            this.cur_nr = 0;
            Node first = G.nodes.values().iterator().next();
            assert (first.succ.size() > 0);
            Edge firstEdge = G.getEdge(first, first.succ.getFirst());
            G.resetNodeFlags();
            this.embedding(firstEdge, G, H, 1, T, A);
            T.addAll(A);
            for (Edge e : T) {
                ++this.cur_nr;
                ((EmbeddingEdgePayload)e.data).sortNum = ((EmbeddingEdgePayload)e.data).sortNum;
            }
            for (Edge e : this.edges) {
                PlanarityEdgePayload pl = new PlanarityEdgePayload();
                pl.cost = ((EmbeddingEdgePayload)H.getEdge((Node)H.getNode((String)e.source.ID), (Node)H.getNode((String)e.destination.ID)).data).sortNum;
                e.data = pl;
            }
            this.sortEdges();
            return new Embedding(this.clone());
        }
        return null;
    }

    private void embedding(Edge e0, DiGraph G, DiGraph H, int t, LinkedList<Edge> T, LinkedList<Edge> A) {
        Node x = e0.source;
        Node y = e0.destination;
        ((PlanarityNodePayload)y.data).treeEdgeInto = e0;
        Edge e1 = G.getEdge(y, y.succ.getFirst());
        Node wk = y;
        while (((PlanarityNodePayload)e1.destination.data).dfsNum > ((PlanarityNodePayload)wk.data).dfsNum) {
            wk = e1.destination;
            ((PlanarityNodePayload)wk.data).treeEdgeInto = e1;
            e1 = G.getEdge(wk, wk.succ.getFirst());
        }
        Node w0 = e1.destination;
        Edge back_edge_into_w0 = e1;
        Node w = wk;
        LinkedList<Edge> Al = new LinkedList<Edge>();
        LinkedList<Edge> Ar = new LinkedList<Edge>();
        LinkedList<Edge> Tprime = new LinkedList<Edge>();
        LinkedList<Edge> Aprime = new LinkedList<Edge>();
        T.clear();
        T.add(H.getEdge(H.getNode(e1.source.ID), H.getNode(e1.destination.ID)));
        while (w != x) {
            int count = 0;
            for (Node n : w.succ) {
                Edge e = G.getEdge(w, n);
                if (++count == 1) continue;
                if (((PlanarityNodePayload)w.data).dfsNum < ((PlanarityNodePayload)e.destination.data).dfsNum) {
                    int tprime = t == ((PlanarityEdgePayload)e.data).alpha ? 1 : 2;
                    this.embedding(e, G, H, tprime, Tprime, Aprime);
                } else {
                    Tprime.add(H.getEdge(H.getNode(e.source.ID), H.getNode(e.destination.ID)));
                    Aprime.add(H.getEdge(H.getNode(e.destination.ID), H.getNode(e.source.ID)));
                }
                if (t == ((PlanarityEdgePayload)e.data).alpha) {
                    Tprime.addAll(T);
                    T.clear();
                    T.addAll(Tprime);
                    Tprime.clear();
                    Al.addAll(Aprime);
                    Aprime.clear();
                    continue;
                }
                T.addAll(Tprime);
                Tprime.clear();
                Aprime.addAll(Ar);
                Ar.clear();
                Ar.addAll(Aprime);
                Aprime.clear();
            }
            Edge ne = ((PlanarityNodePayload)w.data).treeEdgeInto;
            T.add(H.getEdge(H.getNode(ne.destination.ID), H.getNode(ne.source.ID)));
            for (Edge e : T) {
                ++this.cur_nr;
                ((EmbeddingEdgePayload)e.data).sortNum = ((EmbeddingEdgePayload)e.data).sortNum;
            }
            T.clear();
            while (!Al.isEmpty() && ((Edge)Al.getLast()).source == H.getNode(((PlanarityNodePayload)w.data).parent.ID)) {
                T.addFirst((Edge)Al.removeLast());
            }
            ne = ((PlanarityNodePayload)w.data).treeEdgeInto;
            T.add(H.getEdge(H.getNode(ne.source.ID), H.getNode(ne.destination.ID)));
            while (!Ar.isEmpty() && ((Edge)Ar.getFirst()).source == H.getNode(((PlanarityNodePayload)w.data).parent.ID)) {
                T.add((Edge)Ar.removeFirst());
            }
            w = ((PlanarityNodePayload)w.data).parent;
        }
        A.clear();
        A.addAll(Ar);
        Ar.clear();
        A.add(H.getEdge(H.getNode(back_edge_into_w0.destination.ID), H.getNode(back_edge_into_w0.source.ID)));
        A.addAll(Al);
        Al.clear();
    }

    public boolean reverseEdge(Edge e) {
        if (this.edges.contains(e)) {
            Node source = e.source;
            Node dest = e.destination;
            source.succ.remove(dest);
            dest.pred.remove(source);
            source.pred.add(dest);
            dest.succ.add(source);
            e.reverseEdge();
            return true;
        }
        return false;
    }

    public class BiConPayload {
        public int dfsNum = 0;
        public int lowPt = 0;
        public boolean reached = false;
        public Node parent = null;
    }

    public class PlanarityNodePayload {
        public int dfsNum = 0;
        public Node parent = null;
        public boolean reached = false;
        public int lowpt1 = 0;
        public int lowpt2 = 0;
        public Edge treeEdgeInto = null;
    }

    public class PlanarityEdgePayload {
        public int alpha = 0;
        public int cost = 0;
    }

    public class EmbeddingEdgePayload {
        public int sortNum = 0;
    }
}

