/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.modelimpl.cfg;

import at.ssw.visualizer.model.cfg.BasicBlock;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import at.ssw.visualizer.model.cfg.IRInstruction;
import at.ssw.visualizer.model.cfg.State;
import at.ssw.visualizer.modelimpl.cfg.ControlFlowGraphImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class BasicBlockImpl
implements BasicBlock {
    private ControlFlowGraph parent;
    private String name;
    private int fromBci;
    private int toBci;
    private BasicBlock[] predecessors;
    private BasicBlock[] successors;
    private BasicBlock[] xhandlers;
    private String[] flags;
    private BasicBlock dominator;
    private int loopIndex;
    private int loopDepth;
    private int firstLirId;
    private int lastLirId;
    private double probability;
    private State[] states;
    private IRInstruction[] hirInstructions;
    private IRInstruction[] lirOperations;

    public void setValues(String name, int fromBci, int toBci, BasicBlock[] predecessors, BasicBlock[] successors, BasicBlock[] xhandlers, String[] flags, BasicBlock dominator, int loopIndex, int loopDepth, int firstLirId, int lastLirId, double probability, State[] states, IRInstruction[] hirInstructions, IRInstruction[] lirOperations) {
        this.name = name;
        this.fromBci = fromBci;
        this.toBci = toBci;
        this.predecessors = predecessors;
        this.successors = successors;
        this.xhandlers = xhandlers;
        this.flags = flags;
        this.dominator = dominator;
        this.loopIndex = loopIndex;
        this.loopDepth = loopDepth;
        this.firstLirId = firstLirId;
        this.lastLirId = lastLirId;
        this.probability = probability;
        this.states = states;
        this.hirInstructions = hirInstructions;
        this.lirOperations = lirOperations;
    }

    @Override
    public ControlFlowGraph getParent() {
        return this.parent;
    }

    protected void setParent(ControlFlowGraphImpl parent) {
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getFromBci() {
        return this.fromBci;
    }

    @Override
    public int getToBci() {
        return this.toBci;
    }

    public void setToBci(int toBci) {
        this.toBci = toBci;
    }

    @Override
    public List<BasicBlock> getPredecessors() {
        return Collections.unmodifiableList(Arrays.asList(this.predecessors));
    }

    @Override
    public List<BasicBlock> getSuccessors() {
        return Collections.unmodifiableList(Arrays.asList(this.successors));
    }

    @Override
    public List<BasicBlock> getXhandlers() {
        return Collections.unmodifiableList(Arrays.asList(this.xhandlers));
    }

    @Override
    public List<String> getFlags() {
        return Collections.unmodifiableList(Arrays.asList(this.flags));
    }

    @Override
    public BasicBlock getDominator() {
        return this.dominator;
    }

    @Override
    public int getLoopIndex() {
        return this.loopIndex;
    }

    @Override
    public int getLoopDepth() {
        return this.loopDepth;
    }

    @Override
    public int getFirstLirId() {
        return this.firstLirId;
    }

    @Override
    public int getLastLirId() {
        return this.lastLirId;
    }

    @Override
    public double getProbability() {
        return this.probability;
    }

    @Override
    public boolean hasState() {
        return this.states != null;
    }

    @Override
    public List<State> getStates() {
        return Collections.unmodifiableList(Arrays.asList(this.states));
    }

    @Override
    public boolean hasHir() {
        return this.hirInstructions != null;
    }

    @Override
    public List<IRInstruction> getHirInstructions() {
        return Collections.unmodifiableList(Arrays.asList(this.hirInstructions));
    }

    @Override
    public boolean hasLir() {
        return this.lirOperations != null;
    }

    @Override
    public List<IRInstruction> getLirOperations() {
        return Collections.unmodifiableList(Arrays.asList(this.lirOperations));
    }

    public String toString() {
        return this.name;
    }
}

