/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.modelimpl.cfg;

import at.ssw.visualizer.model.cfg.IRInstruction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class IRInstructionImpl
implements IRInstruction {
    private final String[] keys;
    private final String[] values;
    static final String[] twoKeys = new String[]{"nr", "instruction"};
    static final String[] noOperandKeys = new String[]{"p", "bci", "use", "tid", "instruction"};
    static final String[] withOperandKeys = new String[]{"p", "bci", "use", "tid", "result", "instruction"};

    public IRInstructionImpl(LinkedHashMap<String, String> data) {
        Object[] skeys = new String[data.size()];
        String[] svalues = new String[data.size()];
        int index = 0;
        for (Map.Entry<String, String> e : data.entrySet()) {
            skeys[index] = e.getKey().intern();
            svalues[index++] = e.getValue().intern();
        }
        this.keys = Arrays.equals(skeys, twoKeys) ? twoKeys : skeys;
        this.values = svalues;
    }

    public IRInstructionImpl(String pinned, int bci, int useCount, String name, String text, String operand) {
        String p = this.checkIntern(pinned);
        String b = Integer.toString(bci).intern();
        String u = Integer.toString(useCount).intern();
        String n = this.checkIntern(name);
        String i = this.checkIntern(text);
        if (operand != null) {
            this.keys = withOperandKeys;
            this.values = new String[]{p, b, u, n, this.checkIntern(operand), i};
        } else {
            this.keys = noOperandKeys;
            this.values = new String[]{p, b, u, n, i};
        }
    }

    public IRInstructionImpl(int number, String text) {
        this.keys = twoKeys;
        this.values = new String[]{Integer.toString(number).intern(), this.checkIntern(text)};
    }

    @Override
    public Collection<String> getNames() {
        return Collections.unmodifiableList(Arrays.asList(this.keys));
    }

    @Override
    public String getValue(String name) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(name)) continue;
            return this.values[i];
        }
        return null;
    }

    private String checkIntern(String s) {
        if (s != s.intern()) {
            throw new InternalError("non-interned String passed to IRInstructionImpl constructor");
        }
        return s;
    }
}

