/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.modelimpl.interval;

import at.ssw.visualizer.model.interval.ChildInterval;
import at.ssw.visualizer.model.interval.Interval;
import at.ssw.visualizer.model.interval.IntervalList;
import at.ssw.visualizer.modelimpl.interval.ChildIntervalImpl;
import at.ssw.visualizer.modelimpl.interval.IntervalListImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class IntervalImpl
implements Interval {
    private IntervalList parent;
    private ChildInterval[] children;

    public IntervalImpl(ChildIntervalImpl[] children) {
        this.children = children;
        for (ChildIntervalImpl child : children) {
            child.setParent(this);
        }
    }

    @Override
    public IntervalList getParent() {
        return this.parent;
    }

    protected void setParent(IntervalListImpl parent) {
        this.parent = parent;
    }

    @Override
    public List<ChildInterval> getChildren() {
        return Collections.unmodifiableList(Arrays.asList(this.children));
    }

    @Override
    public String getRegNum() {
        return this.children[0].getRegNum();
    }

    @Override
    public int getFrom() {
        return this.children[0].getFrom();
    }

    @Override
    public int getTo() {
        return this.children[this.children.length - 1].getTo();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.children.length; ++i) {
            if (i > 0) {
                result.append("\n  ");
            }
            result.append(this.children[i]);
        }
        return result.toString();
    }
}

