/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.parser;

import at.ssw.visualizer.parser.FatalError;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.netbeans.api.progress.ProgressHandle;

class Buffer {
    public static final int EOF = 65536;
    private static final int MIN_BUFFER_LENGTH = 1024;
    private static final int MAX_BUFFER_LENGTH = 65536;
    private byte[] buf;
    private long bufStart;
    private int bufLen;
    private long fileLen;
    private int bufPos;
    private RandomAccessFile file;
    private InputStream stream;
    ProgressHandle progressHandle;
    int maxSetPosValue;

    public Buffer(InputStream s) {
        this.stream = s;
        this.fileLen = 0L;
        this.bufLen = 0;
        this.bufStart = 0L;
        this.bufPos = 0;
        this.buf = new byte[1024];
    }

    public Buffer(String fileName, ProgressHandle progressHandle) {
        this.progressHandle = progressHandle;
        try {
            this.file = new RandomAccessFile(fileName, "r");
            this.fileLen = this.file.length();
            if (progressHandle != null) {
                progressHandle.start((int)(this.fileLen / 65536L));
            }
            this.bufLen = (int)Math.min(this.fileLen, 65536L);
            this.buf = new byte[this.bufLen];
            this.bufStart = Long.MAX_VALUE;
            if (this.fileLen > 0L) {
                this.setPos(0L);
            } else {
                this.bufPos = 0;
            }
            if ((long)this.bufLen == this.fileLen) {
                this.Close();
            }
        }
        catch (IOException e) {
            throw new FatalError("Could not open file " + fileName);
        }
    }

    protected Buffer(Buffer b) {
        this.buf = b.buf;
        this.bufStart = b.bufStart;
        this.bufLen = b.bufLen;
        this.fileLen = b.fileLen;
        this.bufPos = b.bufPos;
        this.file = b.file;
        this.stream = b.stream;
        b.file = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.Close();
    }

    protected void Close() {
        if (this.file != null) {
            try {
                this.file.close();
                this.file = null;
            }
            catch (IOException e) {
                throw new FatalError(e.getMessage());
            }
        }
    }

    public int Read() {
        if (this.bufPos < this.bufLen) {
            return this.buf[this.bufPos++] & 0xFF;
        }
        if (this.getPos() < this.fileLen) {
            this.setPos(this.getPos());
            return this.buf[this.bufPos++] & 0xFF;
        }
        if (this.stream != null && this.ReadNextStreamChunk() > 0) {
            return this.buf[this.bufPos++] & 0xFF;
        }
        return 65536;
    }

    public int Peek() {
        long curPos = this.getPos();
        int ch = this.Read();
        this.setPos(curPos);
        return ch;
    }

    public String GetString(long beg, long end) {
        int len = 0;
        char[] buf = new char[(int)(end - beg)];
        long oldPos = this.getPos();
        this.setPos(beg);
        while (this.getPos() < end) {
            buf[len++] = (char)this.Read();
        }
        this.setPos(oldPos);
        return new String(buf, 0, len);
    }

    public long getPos() {
        return (long)this.bufPos + this.bufStart;
    }

    public void setPos(long value) {
        if (value >= this.fileLen && this.stream != null) {
            while (value >= this.fileLen && this.ReadNextStreamChunk() > 0) {
            }
        }
        if (value < 0L || value > this.fileLen) {
            throw new FatalError("buffer out of bounds access, position: " + value);
        }
        if (value >= this.bufStart && value < this.bufStart + (long)this.bufLen) {
            this.bufPos = (int)(value - this.bufStart);
        } else if (this.file != null) {
            try {
                this.file.seek(value);
                this.bufLen = this.file.read(this.buf);
                this.bufStart = value;
                this.bufPos = 0;
            }
            catch (IOException e) {
                throw new FatalError(e.getMessage());
            }
            int newPosValue = (int)(value / 65536L);
            if (this.progressHandle != null && newPosValue > this.maxSetPosValue) {
                this.progressHandle.progress(newPosValue);
                this.maxSetPosValue = newPosValue;
            }
        } else {
            throw new InternalError();
        }
    }

    private int ReadNextStreamChunk() {
        int read;
        int free = this.buf.length - this.bufLen;
        if (free == 0) {
            byte[] newBuf = new byte[this.bufLen * 2];
            System.arraycopy(this.buf, 0, newBuf, 0, this.bufLen);
            this.buf = newBuf;
            free = this.bufLen;
        }
        try {
            read = this.stream.read(this.buf, this.bufLen, free);
        }
        catch (IOException ioex) {
            throw new FatalError(ioex.getMessage());
        }
        if (read > 0) {
            this.fileLen = this.bufLen += read;
            return read;
        }
        return 0;
    }
}

