/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.parser;

import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import at.ssw.visualizer.model.interval.Range;
import at.ssw.visualizer.model.interval.UsePosition;
import at.ssw.visualizer.modelimpl.interval.ChildIntervalImpl;
import at.ssw.visualizer.modelimpl.interval.IntervalImpl;
import at.ssw.visualizer.modelimpl.interval.IntervalListImpl;
import at.ssw.visualizer.parser.IntervalHelper;
import at.ssw.visualizer.parser.Parser;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class IntervalListHelper {
    protected String shortName;
    protected String name;
    protected LinkedHashMap<String, IntervalHelper> helpers = new LinkedHashMap();

    public void add(IntervalHelper helper) {
        this.helpers.put(helper.regNum, helper);
    }

    public IntervalListImpl resolve(Parser parser, ControlFlowGraph controlFlowGraph) {
        for (IntervalHelper helper : this.helpers.values()) {
            ChildIntervalImpl registerHint = null;
            if (this.helpers.containsKey(helper.registerHint)) {
                registerHint = this.helpers.get((Object)helper.registerHint).childInterval;
            }
            Range[] ranges = helper.ranges.toArray(new Range[helper.ranges.size()]);
            UsePosition[] usePositions = helper.usePositions.toArray(new UsePosition[helper.usePositions.size()]);
            helper.childInterval.setValues(helper.regNum, helper.type, helper.operand, helper.spillState, registerHint, ranges, usePositions);
            IntervalHelper parent = this.helpers.get(helper.splitParent);
            if (parent != null) {
                parent.splitChildren.add(helper.childInterval);
                continue;
            }
            parser.SemErr("Unknown split parent: " + helper.splitParent);
        }
        ArrayList<IntervalImpl> intervals = new ArrayList<IntervalImpl>();
        for (IntervalHelper helper : this.helpers.values()) {
            if (helper.splitChildren.size() <= 0) continue;
            ChildIntervalImpl[] children = helper.splitChildren.toArray(new ChildIntervalImpl[helper.splitChildren.size()]);
            intervals.add(new IntervalImpl(children));
        }
        return new IntervalListImpl(this.shortName, this.name, intervals.toArray(new IntervalImpl[intervals.size()]), controlFlowGraph);
    }
}

