/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.parser;

import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import at.ssw.visualizer.modelimpl.CompilationModelImpl;
import at.ssw.visualizer.modelimpl.bc.BytecodesImpl;
import at.ssw.visualizer.modelimpl.cfg.ControlFlowGraphImpl;
import at.ssw.visualizer.modelimpl.cfg.IRInstructionImpl;
import at.ssw.visualizer.modelimpl.cfg.StateEntryImpl;
import at.ssw.visualizer.modelimpl.cfg.StateImpl;
import at.ssw.visualizer.modelimpl.interval.IntervalListImpl;
import at.ssw.visualizer.modelimpl.interval.RangeImpl;
import at.ssw.visualizer.modelimpl.interval.UsePositionImpl;
import at.ssw.visualizer.modelimpl.nc.NativeMethodImpl;
import at.ssw.visualizer.parser.BBHelper;
import at.ssw.visualizer.parser.CFGHelper;
import at.ssw.visualizer.parser.CompilationHelper;
import at.ssw.visualizer.parser.Errors;
import at.ssw.visualizer.parser.IntervalHelper;
import at.ssw.visualizer.parser.IntervalListHelper;
import at.ssw.visualizer.parser.Scanner;
import at.ssw.visualizer.parser.Token;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;

public class Parser {
    public static final int _EOF = 0;
    public static final int _ident = 1;
    public static final int maxT = 54;
    static final boolean _T = true;
    static final boolean _x = false;
    static final int minErrDist = 2;
    public Token t;
    public Token la;
    int errDist = 2;
    public Scanner scanner;
    public Errors errors;
    private CompilationModelImpl compilationModel;
    private boolean[][] set = new boolean[][]{{true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, true, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, true, false, true, false, false, false, false}, {false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, false}, {false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, false}};

    public boolean hasErrors() {
        return this.errors.errors.size() > 0;
    }

    public String getErrors() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.errors.errors) {
            sb.append(s);
            sb.append('\n');
        }
        return sb.toString();
    }

    public void setCompilationModel(CompilationModelImpl compilationModel) {
        this.compilationModel = compilationModel;
    }

    private String simpleName(String className) {
        int index = className.lastIndexOf(46);
        if (index < 0) {
            return className;
        }
        return className.substring(index + 1);
    }

    private String shortName(String name) {
        int methodPoint;
        name = this.longName(name);
        String params = "";
        int openParam = name.indexOf(40);
        if (openParam >= 0) {
            int closeParam = name.indexOf(41, openParam);
            if (closeParam >= 0) {
                String[] parts = name.substring(openParam + 1, closeParam).split(", *");
                for (int i = 0; i < parts.length; ++i) {
                    if (!params.isEmpty()) {
                        params = params + ",";
                    }
                    params = params + this.simpleName(parts[i]);
                }
                params = "(" + params + ")";
            }
            name = name.substring(0, openParam);
        }
        if ((methodPoint = name.lastIndexOf(".")) < 0) {
            return name + params;
        }
        int classPoint = name.lastIndexOf(".", methodPoint - 1);
        if (classPoint < 0) {
            return name + params;
        }
        return name.substring(classPoint + 1) + params;
    }

    private String longName(String name) {
        return name.replace("::", ".");
    }

    public Parser(Scanner scanner) {
        this.scanner = scanner;
        this.errors = new Errors();
    }

    void SynErr(int n) {
        if (this.errDist >= 2) {
            this.errors.SynErr(this.la.line, this.la.col, n);
        }
        this.errDist = 0;
    }

    public void SemErr(String msg) {
        if (this.errDist >= 2) {
            this.errors.SemErr(this.t.line, this.t.col, msg);
        }
        this.errDist = 0;
    }

    void Get() {
        while (true) {
            this.t = this.la;
            this.la = this.scanner.Scan();
            if (this.la.kind <= 54) {
                ++this.errDist;
                break;
            }
            this.la = this.t;
        }
    }

    void Expect(int n) {
        if (this.la.kind == n) {
            this.Get();
        } else {
            this.SynErr(n);
        }
    }

    boolean StartOf(int s) {
        return this.set[s][this.la.kind];
    }

    void ExpectWeak(int n, int follow) {
        if (this.la.kind == n) {
            this.Get();
        } else {
            this.SynErr(n);
            while (!this.StartOf(follow)) {
                this.Get();
            }
        }
    }

    boolean WeakSeparator(int n, int syFol, int repFol) {
        int kind = this.la.kind;
        if (kind == n) {
            this.Get();
            return true;
        }
        if (this.StartOf(repFol)) {
            return false;
        }
        this.SynErr(n);
        while (!(this.set[syFol][kind] || this.set[repFol][kind] || this.set[0][kind])) {
            this.Get();
            kind = this.la.kind;
        }
        return this.StartOf(syFol);
    }

    void InputFile() {
        CompilationHelper lastComp = null;
        ControlFlowGraphImpl lastCFG = null;
        IntervalListImpl lastIL = null;
        while (this.StartOf(1)) {
            if (this.la.kind == 2) {
                CompilationHelper curComp = this.Compilation();
                if (lastComp != null) {
                    this.compilationModel.addCompilation(lastComp.resolve());
                }
                lastComp = curComp;
                continue;
            }
            if (this.la.kind == 7) {
                lastCFG = this.CFG(lastComp);
                continue;
            }
            if (this.la.kind == 46) {
                lastIL = this.IntervalList(lastCFG);
                lastComp.elements.add(lastIL);
                continue;
            }
            if (this.la.kind == 49) {
                this.NativeMethod(lastCFG);
                continue;
            }
            this.Bytecodes(lastCFG);
        }
        if (lastComp != null) {
            this.compilationModel.addCompilation(lastComp.resolve());
        }
    }

    CompilationHelper Compilation() {
        CompilationHelper helper = new CompilationHelper();
        this.Expect(2);
        this.Expect(3);
        String name = this.StringValue();
        helper.name = this.longName(name);
        helper.shortName = this.shortName(name);
        this.Expect(4);
        String method = this.StringValue();
        helper.method = this.longName(method);
        this.Expect(5);
        helper.date = this.DateValue();
        this.Expect(6);
        return helper;
    }

    ControlFlowGraphImpl CFG(CompilationHelper lastComp) {
        CFGHelper helper = new CFGHelper();
        this.Expect(7);
        this.Expect(3);
        String name = this.StringValue();
        helper.name = this.longName(name);
        helper.shortName = this.shortName(name);
        if (this.la.kind == 8) {
            this.Get();
            helper.id = this.IntegerValue();
            this.Expect(9);
            helper.parentId = this.IntegerValue();
        }
        while (this.la.kind == 11) {
            BBHelper basicBlock = this.BasicBlock();
            helper.add(basicBlock);
        }
        ControlFlowGraphImpl res = helper.resolve(lastComp, this);
        this.Expect(10);
        return res;
    }

    IntervalListImpl IntervalList(ControlFlowGraph controlFlowGraph) {
        IntervalListHelper helper = new IntervalListHelper();
        if (controlFlowGraph == null) {
            this.SemErr("must have CFG before intervals");
        }
        this.Expect(46);
        this.Expect(3);
        String name = this.StringValue();
        helper.name = this.longName(name);
        helper.shortName = this.shortName(name);
        while (this.la.kind == 1) {
            IntervalHelper interval = this.Interval();
            helper.add(interval);
        }
        IntervalListImpl res = helper.resolve(this, controlFlowGraph);
        this.Expect(47);
        return res;
    }

    void NativeMethod(ControlFlowGraphImpl cfg) {
        this.Expect(49);
        String res = this.NoTrimFreeValue();
        cfg.setNativeMethod(new NativeMethodImpl(cfg, res));
        this.Expect(50);
    }

    void Bytecodes(ControlFlowGraphImpl cfg) {
        this.Expect(51);
        String res = this.FreeValue();
        cfg.setBytecodes(new BytecodesImpl(cfg, res));
        this.Expect(52);
    }

    String StringValue() {
        this.Expect(53);
        long beg = this.la.pos;
        while (this.StartOf(2)) {
            this.Get();
        }
        String res = this.scanner.buffer.GetString(beg, this.la.pos).trim().intern();
        this.Expect(53);
        return res;
    }

    Date DateValue() {
        Date res = null;
        this.Expect(1);
        try {
            res = new Date(Long.parseLong(this.t.val));
        }
        catch (NumberFormatException ex) {
            this.SemErr(this.t.val);
        }
        return res;
    }

    int IntegerValue() {
        int res = 0;
        this.Expect(1);
        try {
            res = Integer.parseInt(this.t.val);
        }
        catch (NumberFormatException ex) {
            this.SemErr(this.t.val);
        }
        return res;
    }

    BBHelper BasicBlock() {
        BBHelper helper = new BBHelper();
        this.Expect(11);
        this.Expect(3);
        helper.name = this.StringValue();
        this.Expect(12);
        helper.fromBci = this.IntegerValue();
        this.Expect(13);
        helper.toBci = this.IntegerValue();
        this.Expect(14);
        helper.predecessors = this.StringList();
        this.Expect(15);
        helper.successors = this.StringList();
        this.Expect(16);
        helper.xhandlers = this.StringList();
        this.Expect(17);
        helper.flags = this.StringList();
        if (this.la.kind == 18) {
            this.Get();
            helper.dominator = this.StringValue();
        }
        if (this.la.kind == 19) {
            this.Get();
            helper.loopIndex = this.IntegerValue();
        }
        if (this.la.kind == 20) {
            this.Get();
            helper.loopDepth = this.IntegerValue();
        }
        if (this.la.kind == 21) {
            this.Get();
            helper.firstLirId = this.IntegerValue();
        }
        if (this.la.kind == 22) {
            this.Get();
            helper.lastLirId = this.IntegerValue();
        }
        if (this.la.kind == 23) {
            this.Get();
            helper.probability = this.DoubleValue();
        }
        if (this.la.kind == 25) {
            this.StateList(helper);
        }
        if (this.la.kind == 36) {
            this.HIR(helper);
        }
        if (this.la.kind == 39) {
            this.LIR(helper);
        }
        while (this.la.kind == 41) {
            this.IR(helper);
        }
        this.Expect(24);
        return helper;
    }

    String[] StringList() {
        ArrayList<String> list = new ArrayList<String>();
        while (this.la.kind == 53) {
            String item = this.StringValue();
            list.add(item);
        }
        String[] res = list.toArray(new String[list.size()]);
        return res;
    }

    double DoubleValue() {
        double res = Double.NaN;
        this.Expect(1);
        try {
            res = Double.longBitsToDouble(Long.parseLong(this.t.val));
        }
        catch (NumberFormatException ex) {
            this.SemErr(this.t.val);
        }
        return res;
    }

    void StateList(BBHelper helper) {
        this.Expect(25);
        while (this.la.kind == 26 || this.la.kind == 28 || this.la.kind == 30) {
            StateImpl state;
            if (this.la.kind == 26) {
                this.Get();
                state = this.State("Operands");
                helper.states.add(state);
                this.Expect(27);
                continue;
            }
            if (this.la.kind == 28) {
                this.Get();
                state = this.State("Locks");
                helper.states.add(state);
                this.Expect(29);
                continue;
            }
            this.Get();
            state = this.State("Locals");
            helper.states.add(state);
            this.Expect(31);
        }
        this.Expect(32);
    }

    void HIR(BBHelper helper) {
        this.Expect(36);
        while (this.la.kind == 1 || this.la.kind == 38) {
            IRInstructionImpl ins = this.HIRInstruction();
            helper.hirInstructions.add(ins);
        }
        this.Expect(37);
    }

    void LIR(BBHelper helper) {
        this.Expect(39);
        while (this.la.kind == 1) {
            IRInstructionImpl op = this.LIROperation();
            helper.lirOperations.add(op);
        }
        this.Expect(40);
    }

    void IR(BBHelper helper) {
        this.Expect(41);
        if (this.la.kind == 42) {
            this.Get();
            while (this.la.kind == 1 || this.la.kind == 45) {
                IRInstructionImpl op = this.IRInstruction();
                helper.hirInstructions.add(op);
            }
        } else if (this.la.kind == 43) {
            this.Get();
            while (this.la.kind == 1 || this.la.kind == 45) {
                IRInstructionImpl op = this.IRInstruction();
                helper.lirOperations.add(op);
            }
        } else {
            this.SynErr(55);
        }
        this.Expect(44);
    }

    StateImpl State(String kind) {
        String method = "";
        ArrayList<StateEntryImpl> entries = new ArrayList<StateEntryImpl>();
        this.Expect(33);
        int size = this.IntegerValue();
        if (this.la.kind == 4) {
            this.Get();
            method = this.StringValue();
        }
        while (this.la.kind == 1) {
            StateEntryImpl entry = this.StateEntry();
            entries.add(entry);
        }
        StateImpl res = new StateImpl(kind, size, this.longName(method), entries.toArray(new StateEntryImpl[entries.size()]));
        return res;
    }

    StateEntryImpl StateEntry() {
        String[] operands = null;
        String operand = null;
        int index = this.IntegerValue();
        String name = this.HIRName();
        if (this.la.kind == 34) {
            this.Get();
            ArrayList<String> operandsList = new ArrayList<String>();
            while (this.la.kind == 1) {
                String opd = this.HIRName();
                operandsList.add(opd);
            }
            this.Expect(35);
            operands = operandsList.toArray(new String[operandsList.size()]);
        }
        if (this.la.kind == 53) {
            operand = this.StringValue();
        }
        StateEntryImpl res = new StateEntryImpl(index, name, operands, operand);
        return res;
    }

    String HIRName() {
        String res = this.IdentValue();
        if (res.charAt(0) >= '0' && res.charAt(0) <= '9') {
            res = "v" + res;
            res = res.intern();
        }
        return res;
    }

    IRInstructionImpl HIRInstruction() {
        String pinned = "";
        String operand = null;
        if (this.la.kind == 38) {
            this.Get();
            pinned = ".";
        }
        int bci = this.IntegerValue();
        int useCount = this.IntegerValue();
        if (this.la.kind == 53) {
            operand = this.StringValue();
        }
        String name = this.HIRName();
        String text = this.FreeValue();
        IRInstructionImpl res = new IRInstructionImpl(pinned, bci, useCount, name, text, operand);
        return res;
    }

    String FreeValue() {
        long beg = this.la.pos;
        while (this.StartOf(3)) {
            this.Get();
        }
        String res = this.scanner.buffer.GetString(beg, this.la.pos).trim();
        if (res.indexOf(13) != -1) {
            res = res.replace("\r\n", "\n");
        }
        res = res.intern();
        this.Expect(45);
        return res;
    }

    String IdentValue() {
        this.Expect(1);
        String res = this.t.val.trim().intern();
        return res;
    }

    IRInstructionImpl LIROperation() {
        int number = this.IntegerValue();
        String text = this.FreeValue();
        IRInstructionImpl res = new IRInstructionImpl(number, text);
        return res;
    }

    IRInstructionImpl IRInstruction() {
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        while (this.la.kind == 1) {
            String name = this.IdentValue();
            String value = this.FreeValue();
            data.put(name.intern(), value.intern());
        }
        this.Expect(45);
        IRInstructionImpl res = new IRInstructionImpl(data);
        return res;
    }

    IntervalHelper Interval() {
        IntervalHelper helper = new IntervalHelper();
        helper.regNum = this.IdentValue();
        helper.type = this.IdentValue();
        if (this.la.kind == 53) {
            helper.operand = this.StringValue();
        }
        helper.splitParent = this.IdentValue();
        helper.registerHint = this.IdentValue();
        RangeImpl range = this.Range();
        helper.ranges.add(range);
        while (this.la.kind == 34) {
            range = this.Range();
            helper.ranges.add(range);
        }
        while (this.la.kind == 1) {
            UsePositionImpl usePosition = this.UsePosition();
            helper.usePositions.add(usePosition);
        }
        helper.spillState = this.StringValue();
        return helper;
    }

    RangeImpl Range() {
        this.Expect(34);
        int from = this.IntegerValue();
        this.Expect(48);
        int to = this.IntegerValue();
        this.Expect(34);
        RangeImpl res = new RangeImpl(from, to);
        return res;
    }

    UsePositionImpl UsePosition() {
        int position = this.IntegerValue();
        String kindStr = this.IdentValue();
        UsePositionImpl res = new UsePositionImpl(position, kindStr.charAt(0));
        return res;
    }

    String NoTrimFreeValue() {
        long beg = this.la.pos;
        while (this.StartOf(3)) {
            this.Get();
        }
        String res = this.scanner.buffer.GetString(beg, this.la.pos);
        if (res.indexOf(13) != -1) {
            res = res.replace("\r\n", "\n");
        }
        res = res.intern();
        this.Expect(45);
        return res;
    }

    public void Parse() {
        this.la = new Token();
        this.la.val = "";
        this.Get();
        this.InputFile();
        this.Expect(0);
        this.Expect(0);
    }
}

