/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.bc;

import at.ssw.visualizer.bc.BCEditor;
import at.ssw.visualizer.bc.model.BCTextBuilder;
import at.ssw.visualizer.model.bc.Bytecodes;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import at.ssw.visualizer.texteditor.EditorSupport;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.openide.text.CloneableEditor;
import org.openide.util.ImageUtilities;

public class BCEditorSupport
extends EditorSupport {
    public static final String MIME_TYPE = "text/x-compilation-bc";
    private Bytecodes bytecodes;

    public BCEditorSupport(Bytecodes bytecodes) {
        super(bytecodes.getControlFlowGraph());
        this.bytecodes = bytecodes;
        this.text = new BCTextBuilder().buildDocument(this.cfg);
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    public Bytecodes getBytecodes() {
        return this.bytecodes;
    }

    protected CloneableEditor createCloneableEditor() {
        return new BCEditor(this);
    }

    protected StyledDocument createStyledDocument(EditorKit kit) {
        StyledDocument doc = super.createStyledDocument(kit);
        doc.putProperty(Bytecodes.class, this.bytecodes);
        doc.putProperty(ControlFlowGraph.class, this.bytecodes.getControlFlowGraph());
        return doc;
    }

    public String messageName() {
        return this.bytecodes.getControlFlowGraph().getShortName();
    }

    protected String messageToolTip() {
        return this.bytecodes.getControlFlowGraph().getName();
    }

    protected void initializeCloneableEditor(CloneableEditor editor) {
        super.initializeCloneableEditor(editor);
        editor.setIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/bc/icons/bytecode.gif"));
    }
}

