/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.bc.model;

import at.ssw.visualizer.bc.model.BCScanner;
import at.ssw.visualizer.bc.model.BytecodeModel;
import at.ssw.visualizer.model.Compilation;
import at.ssw.visualizer.model.bc.Bytecodes;
import at.ssw.visualizer.model.cfg.BasicBlock;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import at.ssw.visualizer.texteditor.model.BlockRegion;
import at.ssw.visualizer.texteditor.model.FoldingRegion;
import at.ssw.visualizer.texteditor.model.HoverParser;
import at.ssw.visualizer.texteditor.model.Text;
import at.ssw.visualizer.texteditor.model.TextBuilder;
import at.ssw.visualizer.texteditor.model.TextRegion;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.editor.TokenID;
import org.openide.util.Lookup;

public class BCTextBuilder
extends TextBuilder {
    private static final FoldType KIND_BLOCK = new FoldType("...");
    private static final String BLOCK_LIST_PREFIX = "BlockListBuilder ";

    public BCTextBuilder() {
        this.scanner = new BCScanner();
    }

    public Text buildDocument(ControlFlowGraph cfg) {
        BytecodeModel bcModel = (BytecodeModel)Lookup.getDefault().lookup(BytecodeModel.class);
        Bytecodes bytecodes = bcModel.getBytecodes(cfg);
        bytecodes.parseBytecodes();
        Compilation compilation = cfg.getCompilation();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        String name = cfg.getName();
        if (name.startsWith(BLOCK_LIST_PREFIX)) {
            name = name.substring(BLOCK_LIST_PREFIX.length());
        }
        this.text.append(name).append("\n");
        this.text.append(dateFormat.format(compilation.getDate())).append("\n\n");
        BasicBlock[] sortedBlocks = this.sortBlocks(cfg.getBasicBlocks());
        if (sortedBlocks.length == 0) {
            this.appendAll(bytecodes);
        } else {
            for (int i = 0; i < sortedBlocks.length; ++i) {
                this.appendBlock(sortedBlocks, bytecodes, i);
            }
        }
        this.text.append("\n\n").append(bytecodes.getEpilogue());
        return this.buildText(cfg, "text/x-compilation-bc");
    }

    public String buildView(ControlFlowGraph cfg, BasicBlock[] basicBlocks) {
        BytecodeModel bcModel = (BytecodeModel)Lookup.getDefault().lookup(BytecodeModel.class);
        Bytecodes bytecodes = bcModel.getBytecodes(cfg);
        if (bytecodes == null) {
            return "No bytecodes available\n";
        }
        StringBuilder view = new StringBuilder(1024);
        this.buildDocument(cfg);
        for (BasicBlock b : basicBlocks) {
            BlockRegion br = (BlockRegion)this.blocks.get(b);
            view.append(this.text.substring(br.getStart(), br.getEnd()));
        }
        return view.toString();
    }

    private void appendAll(Bytecodes bytecodes) {
        String[] bcs;
        int fromBCI = 0;
        int toBCI = Integer.MAX_VALUE;
        for (String s : bcs = bytecodes.getBytecodes(fromBCI, toBCI).split("\n")) {
            this.appendBytecode(null, s);
        }
    }

    private void appendBlock(BasicBlock[] basicBlocks, Bytecodes bytecodes, int index) {
        String[] bcs;
        int start = this.text.length();
        int fromBCI = basicBlocks[index].getFromBci();
        int toBCI = Integer.MAX_VALUE;
        if (basicBlocks.length > index + 1 && basicBlocks[index + 1].getFromBci() >= 0) {
            toBCI = basicBlocks[index + 1].getFromBci();
        }
        this.appendBlockDetails(basicBlocks[index]);
        this.text.append("\n");
        int bytecodesStart = this.text.length();
        for (String s : bcs = bytecodes.getBytecodes(fromBCI, toBCI).split("\n")) {
            this.appendBytecode(basicBlocks[index], s);
        }
        this.blocks.put(basicBlocks[index], new BlockRegion(basicBlocks[index], start, this.text.length(), start, start + basicBlocks[index].getName().length()));
        this.foldingRegions.add(new FoldingRegion(KIND_BLOCK, bytecodesStart - 1, this.text.length() - 1, false));
        this.hyperlinks.put(basicBlocks[index].getName(), new TextRegion(start, start + basicBlocks[index].getName().length()));
    }

    private void appendBytecode(BasicBlock block, String bytecode) {
        int start = this.text.length();
        HoverParser p = new HoverParser(bytecode);
        while (p.hasNext()) {
            int pstart = this.text.length();
            this.text.append(p.next());
            if (p.getHover() == null) continue;
            this.regionHovers.put(new TextRegion(pstart, this.text.length()), p.getHover());
        }
        this.text.append("\n");
        this.scanner.setText(bytecode, 0, bytecode.length());
        TokenID token = this.scanner.nextToken();
        while (token != null && token.getNumericID() != -1) {
            String tokenString = this.scanner.getTokenString();
            if (token.getNumericID() == 4) {
                if (this.scanner.getTokenString().startsWith("#")) {
                    this.addReference(block, tokenString, bytecode);
                    this.addReference(block, tokenString.substring(1, tokenString.length()), bytecode);
                } else {
                    this.hoverKeys.add(tokenString);
                    this.hoverKeys.add('#' + tokenString);
                    this.addDefinition(block, tokenString, bytecode);
                    this.addDefinition(block, '#' + tokenString, bytecode);
                    this.hyperlinks.put('#' + tokenString, new TextRegion(start + this.scanner.getTokenOffset(), start + this.scanner.getOffset()));
                }
            } else if (token.getNumericID() == 6) {
                this.hoverKeys.add(tokenString);
                this.addReference(block, tokenString, bytecode);
            }
            token = this.scanner.nextToken();
        }
    }

    private void addReference(BasicBlock block, String key, String s) {
        if (block == null) {
            return;
        }
        if (!this.hoverReferences.containsKey(key)) {
            this.hoverReferences.put(key, new ArrayList());
        }
        ((List)this.hoverReferences.get(key)).add(block.getName() + ":\t" + s);
    }

    private void addDefinition(BasicBlock block, String key, String s) {
        if (block == null) {
            return;
        }
        this.hoverDefinitions.put(key, block.getName() + ":\t" + s);
    }

    protected void buildHighlighting() {
        this.scanner.setText(this.text.toString(), 0, this.text.length());
        TokenID token = this.scanner.nextToken();
        HashMap highlightings = new HashMap();
        while (token != null && token.getNumericID() != -1) {
            String key = this.scanner.getTokenString();
            switch (token.getNumericID()) {
                case 4: {
                    if (key.startsWith("#")) {
                        key = key.substring(1, key.length());
                    }
                    ArrayList tr = new ArrayList();
                    if (!highlightings.containsKey(key)) {
                        highlightings.put(key, tr);
                        highlightings.put('#' + key, tr);
                    }
                    ((List)highlightings.get(key)).add(new TextRegion(this.scanner.getTokenOffset(), this.scanner.getOffset()));
                    break;
                }
                case 6: 
                case 7: {
                    if (!highlightings.containsKey(key)) {
                        highlightings.put(key, new ArrayList());
                    }
                    ((List)highlightings.get(key)).add(new TextRegion(this.scanner.getTokenOffset(), this.scanner.getOffset()));
                }
            }
            token = this.scanner.nextToken();
        }
        for (String key : highlightings.keySet()) {
            List regions = (List)highlightings.get(key);
            this.highlighting.put(key, regions.toArray(new TextRegion[regions.size()]));
        }
    }

    protected BasicBlock[] sortBlocks(List<BasicBlock> blocks) {
        ArrayList<BasicBlock> blockList = new ArrayList<BasicBlock>(blocks);
        Collections.sort(blockList, new Comparator<BasicBlock>(){

            @Override
            public int compare(BasicBlock b1, BasicBlock b2) {
                if (b1.getFromBci() >= 0 && b2.getFromBci() < 0) {
                    return -1;
                }
                if (b1.getFromBci() < 0 && b2.getFromBci() >= 0) {
                    return 1;
                }
                if (b1 != b2 && b1.getFromBci() == b2.getFromBci()) {
                    return -1;
                }
                return b1.getFromBci() - b2.getFromBci();
            }
        });
        return blockList.toArray(new BasicBlock[blocks.size()]);
    }
}

