/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.compilation.view.action;

import at.ssw.visualizer.model.CompilationModel;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public final class OpenCompilationAction
extends AbstractAction {
    public OpenCompilationAction() {
        super("&Open Compiled Methods...", new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/compilation/view/icons/open.gif")));
        this.putValue("ShortDescription", "Open Compiled Methods");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JFileChooser ch = new JFileChooser();
        ch.setCurrentDirectory(this.getLastDirectory());
        ch.setFileFilter(new FileNameExtensionFilter("Compiled methods (*.cfg)", "cfg"));
        if (ch.showOpenDialog(WindowManager.getDefault().getMainWindow()) != 0 || ch.getSelectedFile() == null) {
            return;
        }
        this.setLastDirectory(ch.getSelectedFile());
        final String fileName = ch.getSelectedFile().getAbsolutePath();
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                CompilationModel model = (CompilationModel)Lookup.getDefault().lookup(CompilationModel.class);
                String errorMsg = model.parseInputFile(fileName);
                if (errorMsg != null) {
                    NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)("Errors while parsing input:\n" + errorMsg), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                }
            }
        });
    }

    private File getLastDirectory() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String fileName = prefs.get("lastDirectory", null);
        File file = null;
        if (fileName != null) {
            file = new File(fileName);
        }
        if (file == null || !file.exists()) {
            file = new File(System.getProperty("user.home"));
        }
        return file;
    }

    private void setLastDirectory(File file) {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        prefs.put("lastDirectory", file.getPath());
    }
}

