/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.ir.view;

import at.ssw.visualizer.ir.IREditorKit;
import at.ssw.visualizer.ir.model.IRTextBuilder;
import at.ssw.visualizer.model.cfg.BasicBlock;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import at.ssw.visualizer.texteditor.EditorKit;
import at.ssw.visualizer.texteditor.view.AbstractTextViewTopComponent;
import java.io.Serializable;
import org.openide.windows.WindowManager;

final class HIRViewTopComponent
extends AbstractTextViewTopComponent {
    private static final String PREFERRED_ID = "HIRViewTopComponent";
    private static HIRViewTopComponent instance;

    private HIRViewTopComponent() {
        super((EditorKit)new IREditorKit());
        this.setName("HIR");
        this.setToolTipText("High-level Intermediate Representation");
    }

    protected String getContent(ControlFlowGraph cfg, BasicBlock[] blocks) {
        IRTextBuilder builder = new IRTextBuilder();
        return builder.buildHir(cfg, blocks);
    }

    public static synchronized HIRViewTopComponent getDefault() {
        if (instance == null) {
            instance = new HIRViewTopComponent();
        }
        return instance;
    }

    public static synchronized HIRViewTopComponent findInstance() {
        return (HIRViewTopComponent)WindowManager.getDefault().findTopComponent(PREFERRED_ID);
    }

    public int getPersistenceType() {
        return 0;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return HIRViewTopComponent.getDefault();
        }
    }
}

