/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.dataflow.layout;

import at.ssw.dataflow.layout.ExternalGraphLayouter;
import at.ssw.dataflow.layout.RoutingHelper;
import at.ssw.dataflow.layout.doublePoint;
import at.ssw.dataflow.options.BooleanStringValidator;
import at.ssw.dataflow.options.DoubleStringValidator;
import at.ssw.dataflow.options.IntStringValidator;
import at.ssw.dataflow.options.Validator;
import at.ssw.positionmanager.LayoutGraph;
import at.ssw.positionmanager.Link;
import at.ssw.positionmanager.Vertex;
import at.ssw.visualizer.graphhelper.DiGraph;
import at.ssw.visualizer.graphhelper.Edge;
import at.ssw.visualizer.graphhelper.Node;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;

public class ForceLayouter
implements ExternalGraphLayouter {
    private double SPRINGLEN = 50.0;
    private double STIFFNESS = 15.0;
    private double REPULSION = 100.0;
    private double SPRINGLENEXP = 50.0;
    private double STIFFNESSEXP = 15.0;
    private double REPULSIONEXP = 300.0;
    private double MAXIMUMMOVEMENT = 500.0;
    private int PADDING = 30;
    private int ITERATIONS = 150;
    private long SEED = 133L;
    private boolean USELOGSPRINGS = false;
    private boolean USECURRENTNODEPOSITIONS = false;
    private Hashtable<String, Point2D> posList;
    private static String[] options = new String[]{"Componentpadding", "Springlength", "Expanded Springlength", "Stiffness", "Expanded Stiffness", "Iterations", "Repulsion", "Expanded Repulsion", "Seed", "Log. Springs", "Maximum Displacement"};
    private static String[] descriptions = new String[]{"Minimum space between connected components", "Length of the spring between nodes", "Length of the spring between expanded nodes", "Stiffness of the spring between the nodes", "Stiffness of the spring between expanded nodes", "Relaxation iterations the algorithm performs", "Standard repulsion of a unexpanded Node", "Standard repulsion of a expanded Node", "Seed for the random prepositioning", "Logarithmic spring simulation is used?", "Maximum displacement in x and y direction during relaxation."};
    private static Class[] optionclass = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
    private static Validator[] validators = new Validator[]{new IntStringValidator(0, 1000), new DoubleStringValidator(0.0, 1000.0), new DoubleStringValidator(0.0, 1000.0), new DoubleStringValidator(0.0, 1000.0), new DoubleStringValidator(0.0, 1000.0), new IntStringValidator(0, 5000), new DoubleStringValidator(0.0, 10000.0), new DoubleStringValidator(0.0, 10000.0), new IntStringValidator(0, Integer.MAX_VALUE), new BooleanStringValidator(), new DoubleStringValidator(0.0, 5000.0)};

    public void doLayout(LayoutGraph graph) {
        Hashtable<String, Vertex> idtoverticles = new Hashtable<String, Vertex>();
        Hashtable<Vertex, String> verticlestoid = new Hashtable<Vertex, String>();
        DiGraph dg = new DiGraph();
        Iterator iter = graph.getVertices().iterator();
        int i = 0;
        while (iter.hasNext()) {
            String id = String.valueOf(i);
            dg.addNode(new Node(id));
            Vertex v = (Vertex)iter.next();
            idtoverticles.put(id, v);
            verticlestoid.put(v, id);
            ++i;
        }
        for (Link l : graph.getLinks()) {
            String from = verticlestoid.get(l.getFrom().getVertex());
            String to = verticlestoid.get(l.getTo().getVertex());
            dg.addEdge(new Edge(dg.getNode(from), dg.getNode(to)));
        }
        this.layout(graph, dg, idtoverticles, verticlestoid);
    }

    private void layout(LayoutGraph lg, DiGraph digraph, Hashtable<String, Vertex> idtoverticles, Hashtable<Vertex, String> verticlestoid) {
        int lastmax = 0;
        int max = 0;
        for (DiGraph dg : digraph.getConnectedComponents()) {
            this.posList = new Hashtable();
            Random rand = new Random(this.SEED);
            for (Node w : dg.getNodes()) {
                if (this.USECURRENTNODEPOSITIONS) {
                    Vertex v = idtoverticles.get(w.ID);
                    double x = 0.0;
                    double y = 0.0;
                    if (v != null) {
                        x = v.getPosition().x;
                        y = v.getPosition().y;
                    }
                    this.posList.put(w.ID, new doublePoint(x, y));
                    continue;
                }
                this.posList.put(w.ID, new doublePoint(rand.nextDouble() * 300.0, rand.nextDouble() * 300.0));
            }
            for (int i = 0; i < this.ITERATIONS; ++i) {
                for (Node n : dg.getNodes()) {
                    this.relaxation(n, dg, idtoverticles);
                }
            }
            double smallestX = Double.MAX_VALUE;
            double smallestY = Double.MAX_VALUE;
            for (Node w : dg.getNodes()) {
                Point2D p = this.posList.get(w.ID);
                if (smallestX > p.getX()) {
                    smallestX = p.getX();
                }
                if (!(smallestY > p.getY())) continue;
                smallestY = p.getY();
            }
            max = 0;
            for (Node w : dg.getNodes()) {
                Vertex v = idtoverticles.get(w.ID);
                Point2D p = this.posList.get(w.ID);
                int x = (int)(p.getX() - smallestX) + lastmax + this.PADDING;
                int y = (int)(p.getY() - smallestY) + this.PADDING;
                if (x + v.getSize().width > max) {
                    max = x + v.getSize().width;
                }
                v.setPosition(new Point(x, y));
            }
            lastmax = max;
        }
    }

    private void relaxation(Node n, DiGraph dg, Hashtable<String, Vertex> idtoverticles) {
        double X = this.posList.get(n.ID).getX();
        double Y = this.posList.get(n.ID).getY();
        boolean nExpanded = false;
        Vertex v = idtoverticles.get(n.ID);
        if (v != null) {
            nExpanded = v.isExpanded();
        }
        LinkedList<Node> adjacentVertices = new LinkedList<Node>();
        for (Node pre : n.pred) {
            if (n.ID.equals(pre.ID)) continue;
            adjacentVertices.add(pre);
        }
        for (Node succ : n.succ) {
            if (n.ID.equals(succ.ID)) continue;
            adjacentVertices.add(succ);
        }
        double SpringX = 0.0;
        double SpringY = 0.0;
        for (Node adjacent : adjacentVertices) {
            double springlen;
            double stiffness;
            boolean expanded = nExpanded;
            v = idtoverticles.get(adjacent.ID);
            if (v != null) {
                expanded |= v.isExpanded();
            }
            if (expanded) {
                stiffness = this.STIFFNESSEXP;
                springlen = this.SPRINGLENEXP;
            } else {
                stiffness = this.STIFFNESS;
                springlen = this.SPRINGLEN;
            }
            double adjX = this.posList.get(adjacent.ID).getX();
            double adjY = this.posList.get(adjacent.ID).getY();
            double distance = Point2D.distance(adjX, adjY, X, Y);
            if (distance == 0.0) {
                distance = 0.01;
            }
            if (this.USELOGSPRINGS) {
                SpringX += stiffness * Math.log(distance / springlen) * ((X - adjX) / distance);
                SpringY += stiffness * Math.log(distance / springlen) * ((Y - adjY) / distance);
                continue;
            }
            SpringX += stiffness * ((distance - springlen) / (2.0 * springlen)) * ((X - adjX) / distance);
            SpringY += stiffness * ((distance - springlen) / (2.0 * springlen)) * ((Y - adjY) / distance);
        }
        double RepulsionX = 0.0;
        double RepulsionY = 0.0;
        for (Node w : dg.getNodes()) {
            double nY;
            if (w == n) continue;
            boolean expanded = nExpanded;
            v = idtoverticles.get(w.ID);
            if (v != null) {
                expanded |= v.isExpanded();
            }
            double repulsion = expanded ? this.REPULSIONEXP : this.REPULSION;
            double nX = this.posList.get(w.ID).getX();
            double distance = Point2D.distance(nX, nY = this.posList.get(w.ID).getY(), X, Y);
            if (distance == 0.0) {
                distance = 0.01;
            }
            RepulsionX -= repulsion / distance * ((X - nX) / distance);
            RepulsionY -= repulsion / distance * ((Y - nY) / distance);
        }
        double dx = -(SpringX + RepulsionX);
        double dy = -(SpringY + RepulsionY);
        if (dx > this.MAXIMUMMOVEMENT) {
            dx = this.MAXIMUMMOVEMENT;
        }
        if (dx * -1.0 > this.MAXIMUMMOVEMENT) {
            dx = -this.MAXIMUMMOVEMENT;
        }
        if (dy > this.MAXIMUMMOVEMENT) {
            dy = this.MAXIMUMMOVEMENT;
        }
        if (dy * -1.0 > this.MAXIMUMMOVEMENT) {
            dy = -this.MAXIMUMMOVEMENT;
        }
        Point2D p = this.posList.get(n.ID);
        p.setLocation(p.getX() + dx, p.getY() + dy);
    }

    public void doRouting(LayoutGraph graph) {
        RoutingHelper.doRouting(graph);
    }

    @Override
    public boolean isClusteringSupported() {
        return false;
    }

    @Override
    public boolean isAnimationSupported() {
        return true;
    }

    @Override
    public boolean isMovementSupported() {
        return true;
    }

    @Override
    public void setUseCurrentNodePositions(boolean b) {
        this.USECURRENTNODEPOSITIONS = b;
    }

    @Override
    public String[] getOptionKeys() {
        return options;
    }

    @Override
    public boolean setOption(String key, Object value) {
        if (key == null) {
            return false;
        }
        if (key.equals(options[0])) {
            if (validators[0].validate(value)) {
                this.PADDING = Integer.parseInt((String)value);
                return true;
            }
        } else if (key.equals(options[1])) {
            if (validators[1].validate(value)) {
                this.SPRINGLEN = Double.parseDouble((String)value);
                return true;
            }
        } else if (key.equals(options[2])) {
            if (validators[2].validate(value)) {
                this.SPRINGLENEXP = Double.parseDouble((String)value);
                return true;
            }
        } else if (key.equals(options[3])) {
            if (validators[3].validate(value)) {
                this.STIFFNESS = Double.parseDouble((String)value);
                return true;
            }
        } else if (key.equals(options[4])) {
            if (validators[4].validate(value)) {
                this.STIFFNESSEXP = Double.parseDouble((String)value);
                return true;
            }
        } else if (key.equals(options[5])) {
            if (validators[5].validate(value)) {
                this.ITERATIONS = Integer.parseInt((String)value);
                return true;
            }
        } else if (key.equals(options[6])) {
            if (validators[6].validate(value)) {
                this.REPULSION = Double.parseDouble((String)value);
                return true;
            }
        } else if (key.equals(options[7])) {
            if (validators[7].validate(value)) {
                this.REPULSIONEXP = Double.parseDouble((String)value);
                return true;
            }
        } else if (key.equals(options[8])) {
            if (validators[8].validate(value)) {
                this.SEED = Integer.parseInt((String)value);
                return true;
            }
        } else if (key.equals(options[9])) {
            if (validators[9].validate(value)) {
                this.USELOGSPRINGS = Boolean.parseBoolean((String)value);
                return true;
            }
        } else if (key.equals(options[10]) && validators[10].validate(value)) {
            this.MAXIMUMMOVEMENT = Double.parseDouble((String)value);
            return true;
        }
        return false;
    }

    @Override
    public Object getOption(String key) {
        if (key == null) {
            return null;
        }
        if (key.equals(options[0])) {
            return String.valueOf(this.PADDING);
        }
        if (key.equals(options[1])) {
            return String.valueOf(this.SPRINGLEN);
        }
        if (key.equals(options[2])) {
            return String.valueOf(this.SPRINGLENEXP);
        }
        if (key.equals(options[3])) {
            return String.valueOf(this.STIFFNESS);
        }
        if (key.equals(options[4])) {
            return String.valueOf(this.STIFFNESSEXP);
        }
        if (key.equals(options[5])) {
            return String.valueOf(this.ITERATIONS);
        }
        if (key.equals(options[6])) {
            return String.valueOf(this.REPULSION);
        }
        if (key.equals(options[7])) {
            return String.valueOf(this.REPULSIONEXP);
        }
        if (key.equals(options[8])) {
            return String.valueOf(this.SEED);
        }
        if (key.equals(options[9])) {
            return String.valueOf(this.USELOGSPRINGS);
        }
        if (key.equals(options[10])) {
            return String.valueOf(this.MAXIMUMMOVEMENT);
        }
        return null;
    }

    @Override
    public String getOptionDescription(String key) {
        if (key == null) {
            return null;
        }
        for (int i = 0; i < descriptions.length && i < options.length; ++i) {
            if (!key.equals(options[i])) continue;
            return descriptions[i];
        }
        return null;
    }

    @Override
    public Validator getOptionValidator(String key) {
        if (key == null) {
            return null;
        }
        for (int i = 0; i < validators.length && i < options.length; ++i) {
            if (!key.equals(options[i])) continue;
            return validators[i];
        }
        return null;
    }

    @Override
    public Class getOptionClass(String key) {
        if (key == null) {
            return null;
        }
        for (int i = 0; i < optionclass.length && i < options.length; ++i) {
            if (!key.equals(options[i])) continue;
            return optionclass[i];
        }
        return null;
    }
}

