/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.dataflow.layout;

import at.ssw.dataflow.layout.ExternalGraphLayouter;
import at.ssw.dataflow.layout.RoutingHelper;
import at.ssw.dataflow.options.IntStringValidator;
import at.ssw.dataflow.options.Validator;
import at.ssw.positionmanager.LayoutGraph;
import at.ssw.positionmanager.Link;
import at.ssw.positionmanager.Vertex;
import at.ssw.visualizer.graphhelper.DiGraph;
import at.ssw.visualizer.graphhelper.Node;
import java.awt.Point;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;

public class HierarchicalNodesLayouter
implements ExternalGraphLayouter {
    private static final int TOP_BORDER = 20;
    private static final int LEFT_BORDER = 20;
    private int PADDING = 30;
    private static String[] options = new String[]{"Padding"};
    private static String[] descriptions = new String[]{"Minimum space between nodes"};
    private static Class[] optionclass = new Class[]{String.class};
    private static Validator paddingValidator = new IntStringValidator(0, 1000);

    public void doLayout(LayoutGraph graph) {
        Hashtable<Object, Vertex> idtoverticles = new Hashtable<Object, Vertex>();
        Hashtable<Vertex, Object> verticlestoid = new Hashtable<Vertex, Object>();
        Hashtable<String, org.eclipse.draw2d.graph.Node> d2dNodes = new Hashtable<String, org.eclipse.draw2d.graph.Node>();
        DiGraph dg = new DiGraph();
        Iterator iter = graph.getVertices().iterator();
        int i = 0;
        while (iter.hasNext()) {
            String id = String.valueOf(i);
            dg.addNode(new Node(id));
            Vertex v = (Vertex)iter.next();
            idtoverticles.put(id, v);
            verticlestoid.put(v, id);
            ++i;
        }
        for (Link l : graph.getLinks()) {
            String from = (String)verticlestoid.get(l.getFrom().getVertex());
            String to = (String)verticlestoid.get(l.getTo().getVertex());
            dg.addEdge(new at.ssw.visualizer.graphhelper.Edge(dg.getNode(from), dg.getNode(to)));
        }
        int max = 0;
        int lastmax = 0;
        for (DiGraph g : dg.getConnectedComponents()) {
            DirectedGraph d2dGraph = new DirectedGraph();
            for (Node n : g.getNodes()) {
                Vertex v = (Vertex)idtoverticles.get(n.ID);
                org.eclipse.draw2d.graph.Node node = new org.eclipse.draw2d.graph.Node();
                node.data = v;
                node.width = v.getSize().width;
                node.height = v.getSize().height;
                node.setPadding(new Insets(this.PADDING, this.PADDING, this.PADDING, this.PADDING));
                d2dGraph.nodes.add(node);
                d2dNodes.put(n.ID, node);
            }
            for (at.ssw.visualizer.graphhelper.Edge e : g.getEdges()) {
                Edge edge = new Edge((org.eclipse.draw2d.graph.Node)d2dNodes.get(e.source.ID), (org.eclipse.draw2d.graph.Node)d2dNodes.get(e.destination.ID));
                d2dGraph.edges.add(edge);
            }
            DirectedGraphLayout layout = new DirectedGraphLayout();
            layout.visit(d2dGraph);
            lastmax += max + this.PADDING;
            max = 0;
            for (int j = 0; j < d2dGraph.nodes.size(); ++j) {
                org.eclipse.draw2d.graph.Node n = d2dGraph.nodes.getNode(j);
                assert (n.data != null);
                Vertex v = (Vertex)n.data;
                Point p = new Point(lastmax + n.x + 20, n.y + 20);
                int width = v.getSize().width;
                if (n.x + width > max) {
                    max = n.x + width;
                }
                v.setPosition(p);
            }
        }
    }

    public void doRouting(LayoutGraph graph) {
        RoutingHelper.doRouting(graph);
    }

    @Override
    public boolean isClusteringSupported() {
        return false;
    }

    @Override
    public boolean isAnimationSupported() {
        return true;
    }

    @Override
    public boolean isMovementSupported() {
        return true;
    }

    @Override
    public void setUseCurrentNodePositions(boolean b) {
    }

    @Override
    public String[] getOptionKeys() {
        return options;
    }

    @Override
    public boolean setOption(String key, Object value) {
        if (key != null && key.equals(options[0]) && paddingValidator.validate(value)) {
            this.PADDING = Integer.parseInt((String)value);
            return true;
        }
        return false;
    }

    @Override
    public Validator getOptionValidator(String key) {
        if (key != null && key.equals(options[0])) {
            return paddingValidator;
        }
        return null;
    }

    @Override
    public String getOptionDescription(String key) {
        if (key == null) {
            return null;
        }
        for (int i = 0; i < descriptions.length && i < options.length; ++i) {
            if (!key.equals(options[i])) continue;
            return descriptions[i];
        }
        return null;
    }

    @Override
    public Object getOption(String key) {
        if (key != null && key.equals(options[0])) {
            return String.valueOf(this.PADDING);
        }
        return null;
    }

    @Override
    public Class getOptionClass(String key) {
        if (key == null) {
            return null;
        }
        for (int i = 0; i < optionclass.length && i < options.length; ++i) {
            if (!key.equals(options[i])) continue;
            return optionclass[i];
        }
        return null;
    }
}

