/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.dataflow.options;

import at.ssw.dataflow.options.Validator;

public class IntStringValidator
implements Validator {
    private int min;
    private int max;
    String error = null;

    public IntStringValidator(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public IntStringValidator() {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public boolean validate(Object option) {
        try {
            if (!(option instanceof String)) {
                this.error = "Option is not a string";
                return false;
            }
            int x = Integer.parseInt((String)option);
            if (x >= this.min && x <= this.max) {
                this.error = null;
                return true;
            }
            this.error = "Value not within intervall: [" + this.min + "," + this.max + "]";
            return false;
        }
        catch (Exception e) {
            this.error = "No integer value.";
            return false;
        }
    }

    @Override
    public String getLastErrorMessage() {
        return this.error;
    }
}

