/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.graphanalyzer.positioning;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class Curves {
    private static float b(int i, float t) {
        switch (i) {
            case -2: {
                return (((-t + 3.0f) * t - 3.0f) * t + 1.0f) / 6.0f;
            }
            case -1: {
                return ((3.0f * t - 6.0f) * t * t + 4.0f) / 6.0f;
            }
            case 0: {
                return (((-3.0f * t + 3.0f) * t + 3.0f) * t + 1.0f) / 6.0f;
            }
            case 1: {
                return t * t * t / 6.0f;
            }
        }
        return 0.0f;
    }

    private static Point p(int i, float t, List<Point> points) {
        float px = 0.0f;
        float py = 0.0f;
        for (int j = -2; j <= 1; ++j) {
            Point point = points.get(i + j);
            px += Curves.b(j, t) * (float)point.x;
            py += Curves.b(j, t) * (float)point.y;
        }
        return new Point(Math.round(px), Math.round(py));
    }

    public static List<Point> bsplines(List<Point> inputPoints, Point startRef, Point endRef, int steps) {
        if (inputPoints.size() == 2) {
            return inputPoints;
        }
        ArrayList<Point> points = new ArrayList<Point>(inputPoints);
        Point firstPoint = inputPoints.get(0);
        Point lastPoint = inputPoints.get(inputPoints.size() - 1);
        ArrayList<Point> result = new ArrayList<Point>();
        Point q = Curves.p(2, 0.0f, points);
        for (int i = 2; i < points.size() - 1; ++i) {
            for (int j = 1; j <= steps; ++j) {
                q = Curves.p(i, (float)j / (float)steps, points);
                result.add(q);
            }
        }
        result.add(0, firstPoint);
        result.add(lastPoint);
        return result;
    }

    public static Point scaleVector(Point p, double len) {
        double scale = Math.sqrt(p.x * p.x + p.y * p.y);
        scale = len / scale;
        Point result = new Point(p);
        result.x = (int)Math.round((double)result.x * scale);
        result.y = (int)Math.round((double)result.y * scale);
        return result;
    }

    public static int quadraticOffset(Point p1, Point p2) {
        return (p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y);
    }

    public static List<Point> convertToBezier(List<Point> list, Point startRefPoint, Point endRefPoint, double bezierScale, int numberOfIntermediatePoints) {
        if (list.size() == 2) {
            return list;
        }
        ArrayList<Point> result = new ArrayList<Point>();
        Point prev = null;
        for (int i = 0; i < list.size() - 1; ++i) {
            Point cur = list.get(i);
            Point next = list.get(i + 1);
            Point nextnext = null;
            if (i < list.size() - 2) {
                nextnext = list.get(i + 2);
            }
            Point bezierFrom = null;
            Point bezierTo = null;
            bezierFrom = prev == null ? new Point(cur.x - startRefPoint.x, cur.y - startRefPoint.y) : new Point(next.x - prev.x, next.y - prev.y);
            bezierTo = nextnext == null ? new Point(next.x - endRefPoint.x, next.y - endRefPoint.y) : new Point(cur.x - nextnext.x, cur.y - nextnext.y);
            Point vec = new Point(cur.x - next.x, cur.y - next.y);
            double len = Math.sqrt(vec.x * vec.x + vec.y * vec.y);
            double scale = len * bezierScale;
            bezierFrom = Curves.scaleVector(bezierFrom, scale);
            bezierFrom.translate(cur.x, cur.y);
            bezierTo = Curves.scaleVector(bezierTo, scale);
            bezierTo.translate(next.x, next.y);
            List<Point> curList = Curves.bezier(cur, next, bezierFrom, bezierTo, 1.0 / (double)numberOfIntermediatePoints);
            for (Point p : curList) {
                if (result.size() > 0) {
                    Point other = (Point)result.get(result.size() - 1);
                    if (Curves.quadraticOffset(p, other) <= 80) continue;
                    result.add(p);
                    continue;
                }
                result.add(p);
            }
            prev = cur;
        }
        result.add(list.get(list.size() - 1));
        return result;
    }

    private static List<Point> bezier(Point from, Point to, Point bezierFrom, Point bezierTo, double offset) {
        ArrayList<Point> list = new ArrayList<Point>();
        Point lastPoint = new Point(-1, -1);
        for (double t = 0.0; t <= 1.0; t += offset) {
            double tInv = 1.0 - t;
            double tInv2 = tInv * tInv;
            double tInv3 = tInv2 * tInv;
            double t2 = t * t;
            double t3 = t2 * t;
            double x = tInv3 * (double)from.x + 3.0 * t * tInv2 * (double)bezierFrom.x + 3.0 * t2 * tInv * (double)bezierTo.x + t3 * (double)to.x;
            double y = tInv3 * (double)from.y + 3.0 * t * tInv2 * (double)bezierFrom.y + 3.0 * t2 * tInv * (double)bezierTo.y + t3 * (double)to.y;
            Point p = new Point((int)Math.round(x), (int)Math.round(y));
            if (lastPoint.x == p.x && lastPoint.y == p.y) continue;
            int offx = p.x - lastPoint.x;
            int offy = p.y - lastPoint.y;
            int off = offx * offx + offy * offy;
            if (list.size() != 1 && off <= 2) continue;
            list.add(p);
            lastPoint = p;
        }
        list.remove(list.size() - 1);
        list.add(to);
        return list;
    }
}

