/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.graphanalyzer.positioning;

import at.ssw.graphanalyzer.positioning.Graph;
import at.ssw.graphanalyzer.positioning.Node;

public class Edge<N, E> {
    private E data;
    private Node<N, E> source;
    private Node<N, E> dest;
    private Graph<N, E> graph;

    protected Edge(Graph<N, E> graph, Node<N, E> source, Node<N, E> dest, E data) {
        this.setData(data);
        this.graph = graph;
        this.source = source;
        this.dest = dest;
    }

    public Node<N, E> getSource() {
        return this.source;
    }

    public Node<N, E> getDest() {
        return this.dest;
    }

    public E getData() {
        return this.data;
    }

    public void setData(E e) {
        this.data = e;
    }

    public void remove() {
        this.graph.removeEdge(this, null);
    }

    public boolean isSelfLoop() {
        return this.source == this.dest;
    }

    public void reverse() {
        this.source.removeOutEdge(this);
        this.dest.removeInEdge(this);
        Node<N, E> tmp = this.source;
        this.source = this.dest;
        this.dest = tmp;
        this.source.addOutEdge(this);
        this.dest.addInEdge(this);
    }

    public String toString() {
        return "Edge (" + this.source + " -- " + this.dest + "): " + this.data;
    }
}

