/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.graphanalyzer.positioning;

import at.ssw.graphanalyzer.positioning.Edge;
import at.ssw.graphanalyzer.positioning.Graph;
import at.ssw.graphanalyzer.positioning.Node;
import at.ssw.positionmanager.LayoutGraph;
import at.ssw.positionmanager.LayoutManager;
import at.ssw.positionmanager.Link;
import at.ssw.positionmanager.Port;
import at.ssw.positionmanager.Vertex;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class HierarchicalLayoutManager
implements LayoutManager {
    public static final int DUMMY_WIDTH = 0;
    public static final int DUMMY_HEIGHT = 0;
    public static final int LAYER_OFFSET = 50;
    public static final int OFFSET = 8;
    public static final boolean VERTICAL_LAYOUT = true;
    public static final boolean ASSERT = false;
    public static final boolean TRACE = false;
    private Combine combine;
    private Graph<NodeData, EdgeData> graph;
    private Map<Vertex, Node<NodeData, EdgeData>> nodeMap;
    private int layerOffset;
    private int maxLayer;

    public HierarchicalLayoutManager(Combine combine) {
        this(combine, 50);
    }

    public HierarchicalLayoutManager(Combine combine, int layerOffset) {
        this.combine = combine;
        this.layerOffset = layerOffset;
    }

    public void doRouting(LayoutGraph graph) {
    }

    public void doLayout(LayoutGraph layoutGraph) {
        this.doLayout(layoutGraph, new HashSet(), new HashSet());
    }

    public void doLayout(LayoutGraph layoutGraph, Set<? extends Vertex> firstLayerHint, Set<? extends Vertex> lastLayerHint) {
        this.doLayout(layoutGraph, firstLayerHint, lastLayerHint, new HashSet());
    }

    public void doLayout(LayoutGraph layoutGraph, Set<? extends Vertex> firstLayerHint, Set<? extends Vertex> lastLayerHint, Set<? extends Link> importantLinksHint) {
        if (layoutGraph.getVertices().size() == 0) {
            return;
        }
        this.nodeMap = new HashMap<Vertex, Node<NodeData, EdgeData>>();
        this.graph = new Graph();
        HashSet<Node<NodeData, EdgeData>> rootNodes = new HashSet<Node<NodeData, EdgeData>>();
        HashSet<Object> startRootVertices = new HashSet<Object>();
        for (Object v : layoutGraph.getVertices()) {
            if (!v.isRoot()) continue;
            startRootVertices.add(v);
        }
        Set rootVertices = layoutGraph.findRootVertices(startRootVertices);
        for (Vertex node : layoutGraph.getVertices()) {
            NodeData data = new NodeData(node);
            Link[] n = this.graph.createNode(data, node);
            this.nodeMap.put(node, (Node<NodeData, EdgeData>)n);
            if (!rootVertices.contains(node)) continue;
            rootNodes.add((Node<NodeData, EdgeData>)n);
        }
        Set links = layoutGraph.getLinks();
        Link[] linkArr = new Link[links.size()];
        links.toArray(linkArr);
        ArrayList<Link> linkList = new ArrayList<Link>();
        for (Link l : linkArr) {
            linkList.add(l);
        }
        Collections.sort(linkList, new Comparator<Link>(){

            @Override
            public int compare(Link o1, Link o2) {
                int result = o1.getFrom().getVertex().compareTo((Object)o2.getFrom().getVertex());
                if (result == 0) {
                    return o1.getTo().getVertex().compareTo((Object)o2.getTo().getVertex());
                }
                return result;
            }
        });
        for (Link link : linkList) {
            EdgeData data = new EdgeData(link);
            this.graph.createEdge(this.graph.getNode(link.getFrom().getVertex()), this.graph.getNode(link.getTo().getVertex()), data, data);
            if (importantLinksHint.size() <= 0 || importantLinksHint.contains(link)) continue;
            data.setImportant(false);
        }
        this.removeCycles(rootNodes);
        for (Node node : this.graph.getNodes()) {
            ArrayList edges = new ArrayList(node.getOutEdges());
            Collections.sort(edges, new Comparator<Edge<NodeData, EdgeData>>(){

                @Override
                public int compare(Edge<NodeData, EdgeData> o1, Edge<NodeData, EdgeData> o2) {
                    return o2.getData().getRelativeEnd().x - o1.getData().getRelativeEnd().x;
                }
            });
            for (Edge edge : edges) {
                if (!((EdgeData)edge.getData()).isReversed()) continue;
                ((NodeData)edge.getSource().getData()).addReversedEndEdge(edge);
            }
        }
        for (Node node : this.graph.getNodes()) {
            ArrayList edges = new ArrayList(node.getInEdges());
            Collections.sort(edges, new Comparator<Edge<NodeData, EdgeData>>(){

                @Override
                public int compare(Edge<NodeData, EdgeData> o1, Edge<NodeData, EdgeData> o2) {
                    return o2.getData().getRelativeStart().x - o1.getData().getRelativeStart().x;
                }
            });
            for (Edge edge : edges) {
                if (!((EdgeData)edge.getData()).isReversed()) continue;
                ((NodeData)edge.getDest().getData()).addReversedStartEdge(edge);
            }
        }
        this.assignLayers(rootNodes, firstLayerHint, lastLayerHint);
        int maxLayer = 0;
        for (Node<NodeData, EdgeData> n : this.graph.getNodes()) {
            maxLayer = Math.max(maxLayer, n.getData().getLayer());
        }
        ArrayList[] arrayListArray = new ArrayList[maxLayer + 1];
        int[] layerSizes = new int[maxLayer + 1];
        for (int i = 0; i < maxLayer + 1; ++i) {
            arrayListArray[i] = new ArrayList();
        }
        for (Node<NodeData, EdgeData> node : this.graph.getNodes()) {
            int curLayer = node.getData().getLayer();
            arrayListArray[curLayer].add(node);
        }
        this.insertDummyNodes(arrayListArray);
        this.assignLayerCoordinates(arrayListArray, layerSizes);
        this.crossingReduction(arrayListArray);
        this.assignCoordinates(arrayListArray);
        for (Node<NodeData, EdgeData> node : this.graph.getNodes()) {
            if (node.getData().isDummy()) continue;
            Vertex node2 = node.getData().getNode();
            node2.setPosition(new Point(node.getData().getX(), node.getData().getY()));
        }
        for (Node<NodeData, EdgeData> node : this.graph.getNodes()) {
            if (node.getData().isDummy()) continue;
            Vertex node3 = node.getData().getNode();
            List<Edge<NodeData, EdgeData>> outEdges = node.getOutEdges();
            for (Edge<NodeData, EdgeData> e : outEdges) {
                ArrayList<Point> points;
                Node<NodeData, EdgeData> succ = e.getDest();
                if (succ.getData().isDummy()) {
                    points = new ArrayList<Point>();
                    this.assignToRealObjects(layerSizes, succ, points);
                    continue;
                }
                points = new ArrayList();
                EdgeData otherEdgeData = e.getData();
                points.addAll(otherEdgeData.getAbsoluteStartPoints());
                Link otherEdge = otherEdgeData.getEdge();
                Point relFrom = new Point(otherEdgeData.getRelativeStart());
                Point from = otherEdge.getFrom().getVertex().getPosition();
                relFrom.move(relFrom.x + from.x, relFrom.y + from.y);
                points.add(relFrom);
                Point relTo = new Point(otherEdgeData.getRelativeEnd());
                Point to = otherEdge.getTo().getVertex().getPosition();
                relTo.move(relTo.x + to.x, relTo.y + to.y);
                assert (from != null);
                assert (to != null);
                points.add(relTo);
                points.addAll(otherEdgeData.getAbsoluteEndPoints());
                e.getData().getEdge().setControlPoints(points);
            }
        }
    }

    public boolean onOneLine(Point p1, Point p2, Point p3) {
        int xoff1 = p1.x - p2.x;
        int yoff2 = p3.y - p2.x;
        int yoff1 = p1.y - p2.y;
        int xoff2 = p3.x - p2.x;
        return xoff1 * yoff2 - yoff1 * xoff2 == 0;
    }

    public void assignToRealObjects(int[] layerSizes, Node<NodeData, EdgeData> cur, List<Point> points) {
        assert (cur.getData().isDummy());
        ArrayList<Point> otherPoints = new ArrayList<Point>(points);
        int size = layerSizes[cur.getData().getLayer()];
        otherPoints.add(new Point(cur.getData().getX(), cur.getData().getY() - size / 2));
        if (otherPoints.size() >= 3 && this.onOneLine(otherPoints.get(otherPoints.size() - 1), otherPoints.get(otherPoints.size() - 2), otherPoints.get(otherPoints.size() - 3))) {
            otherPoints.remove(otherPoints.size() - 2);
        }
        otherPoints.add(new Point(cur.getData().getX(), cur.getData().getY() + size / 2));
        if (otherPoints.size() >= 3 && this.onOneLine(otherPoints.get(otherPoints.size() - 1), otherPoints.get(otherPoints.size() - 2), otherPoints.get(otherPoints.size() - 3))) {
            otherPoints.remove(otherPoints.size() - 2);
        }
        for (int i = 0; i < cur.getOutEdges().size(); ++i) {
            Node<NodeData, EdgeData> otherSucc = cur.getOutEdges().get(i).getDest();
            if (otherSucc.getData().isDummy()) {
                this.assignToRealObjects(layerSizes, otherSucc, otherPoints);
                continue;
            }
            EdgeData otherEdgeData = cur.getOutEdges().get(i).getData();
            Link otherEdge = otherEdgeData.getEdge();
            ArrayList<Point> middlePoints = new ArrayList<Point>(otherPoints);
            if (cur.getOutEdges().get(i).getData().isReversed()) {
                Collections.reverse(middlePoints);
            }
            ArrayList<Point> copy = new ArrayList<Point>();
            Point relFrom = new Point(otherEdgeData.getRelativeStart());
            Point from = otherEdge.getFrom().getVertex().getPosition();
            relFrom.move(relFrom.x + from.x, relFrom.y + from.y);
            copy.addAll(otherEdgeData.getAbsoluteStartPoints());
            copy.add(relFrom);
            copy.addAll(middlePoints);
            Point relTo = new Point(otherEdgeData.getRelativeEnd());
            Point to = otherEdge.getTo().getVertex().getPosition();
            relTo.move(relTo.x + to.x, relTo.y + to.y);
            copy.add(relTo);
            copy.addAll(otherEdgeData.getAbsoluteEndPoints());
            otherEdge.setControlPoints(copy);
        }
    }

    private boolean checkDummyNodes() {
        for (Edge<NodeData, EdgeData> e : this.graph.getEdges()) {
            if (e.getSource().getData().getLayer() == e.getDest().getData().getLayer() - 1) continue;
            return false;
        }
        return true;
    }

    private void insertDummyNodes(ArrayList<Node<NodeData, EdgeData>>[] layers) {
        int sum = 0;
        ArrayList<Node<NodeData, EdgeData>> nodes = new ArrayList<Node<NodeData, EdgeData>>(this.graph.getNodes());
        int edgeCount = 0;
        int innerMostLoop = 0;
        for (Node<NodeData, EdgeData> n : nodes) {
            ArrayList edges = new ArrayList(n.getOutEdges());
            for (Edge<NodeData, EdgeData> edge : edges) {
                ++edgeCount;
                Link edge2 = ((EdgeData)edge.getData()).getEdge();
                Node destNode = edge.getDest();
                Node<NodeData, EdgeData> lastNode = n;
                Edge<NodeData, EdgeData> lastEdge = edge;
                boolean searchForNode = this.combine != Combine.NONE;
                for (int i = ((NodeData)n.getData()).getLayer() + 1; i < ((NodeData)destNode.getData()).getLayer(); ++i) {
                    Node<NodeData, EdgeData> foundNode = null;
                    if (searchForNode) {
                        for (Node<NodeData, EdgeData> sameLayerNode : layers[i]) {
                            ++innerMostLoop;
                            if (this.combine == Combine.SAME_OUTPUTS) {
                                if (!sameLayerNode.getData().isDummy() || sameLayerNode.getData().getEdge().getFrom() != edge2.getFrom()) continue;
                                foundNode = sameLayerNode;
                                break;
                            }
                            if (this.combine != Combine.SAME_INPUTS || !sameLayerNode.getData().isDummy() || sameLayerNode.getData().getEdge().getTo() != edge2.getTo()) continue;
                            foundNode = sameLayerNode;
                            break;
                        }
                    }
                    if (foundNode == null) {
                        searchForNode = false;
                        NodeData intermediateData = new NodeData(edge2);
                        Node<NodeData, EdgeData> curNode = this.graph.createNode(intermediateData, null);
                        curNode.getData().setLayer(i);
                        layers[i].add(0, curNode);
                        ++sum;
                        lastEdge.remove();
                        this.graph.createEdge(lastNode, curNode, edge.getData(), null);
                        assert (((NodeData)lastNode.getData()).getLayer() == curNode.getData().getLayer() - 1);
                        lastEdge = this.graph.createEdge(curNode, destNode, edge.getData(), null);
                        lastNode = curNode;
                        continue;
                    }
                    lastEdge.remove();
                    lastEdge = this.graph.createEdge(foundNode, destNode, (EdgeData)edge.getData(), null);
                    lastNode = foundNode;
                }
            }
        }
    }

    private void assignLayerCoordinates(ArrayList<Node<NodeData, EdgeData>>[] layers, int[] layerSizes) {
        int cur = 0;
        for (int i = 0; i < layers.length; ++i) {
            int maxHeight = 0;
            for (Node<NodeData, EdgeData> n : layers[i]) {
                maxHeight = Math.max(maxHeight, n.getData().getHeight());
            }
            layerSizes[i] = maxHeight;
            for (Node<NodeData, EdgeData> n : layers[i]) {
                int curCoordinate = cur + (maxHeight - n.getData().getHeight()) / 2;
                n.getData().setLayerCoordinate(curCoordinate);
            }
            cur += maxHeight + this.layerOffset;
        }
    }

    private void assignCoordinates(ArrayList<Node<NodeData, EdgeData>>[] layers) {
        for (int i = 0; i < layers.length; ++i) {
            ArrayList<Node<NodeData, EdgeData>> curArray = layers[i];
            int curY = 0;
            for (Node<NodeData, EdgeData> n : curArray) {
                n.getData().setCoordinate(curY);
                if (!n.getData().isDummy()) {
                    curY += n.getData().getWidth();
                }
                curY += 8;
            }
        }
        int curSol = this.evaluateSolution();
        for (int i = 0; i < 2; ++i) {
            this.optimizeMedian(layers);
            curSol = this.evaluateSolution();
        }
        this.normalizeCoordinate();
    }

    private void normalizeCoordinate() {
        int min = Integer.MAX_VALUE;
        for (Node<NodeData, EdgeData> n : this.graph.getNodes()) {
            min = Math.min(min, n.getData().getCoordinate());
        }
        for (Node<NodeData, EdgeData> n : this.graph.getNodes()) {
            n.getData().setCoordinate(n.getData().getCoordinate() - min);
        }
    }

    private void optimizeMedian(ArrayList<Node<NodeData, EdgeData>>[] layers) {
        int pos;
        ArrayList<Node<NodeData, EdgeData>> alreadyAssigned;
        ArrayList<Node<NodeData, EdgeData>> processingList;
        int i;
        for (i = 1; i < layers.length; ++i) {
            processingList = new ArrayList<Node<NodeData, EdgeData>>(layers[i]);
            Collections.sort(processingList, new Comparator<Node<NodeData, EdgeData>>(){

                @Override
                public int compare(Node<NodeData, EdgeData> o1, Node<NodeData, EdgeData> o2) {
                    if (o2.getData().isDummy()) {
                        return 1;
                    }
                    if (o1.getData().isDummy()) {
                        return -1;
                    }
                    return o2.getInEdges().size() - o1.getInEdges().size();
                }
            });
            alreadyAssigned = new ArrayList<Node<NodeData, EdgeData>>();
            for (Node<NodeData, EdgeData> n : processingList) {
                ArrayList<Node<NodeData, EdgeData>> preds = new ArrayList<Node<NodeData, EdgeData>>(n.getPredecessors());
                pos = n.getData().getCoordinate();
                if (preds.size() > 0) {
                    Collections.sort(preds, new Comparator<Node<NodeData, EdgeData>>(){

                        @Override
                        public int compare(Node<NodeData, EdgeData> o1, Node<NodeData, EdgeData> o2) {
                            return o1.getData().getCoordinate() - o2.getData().getCoordinate();
                        }
                    });
                    if (preds.size() % 2 == 0) {
                        assert (preds.size() >= 2);
                        pos = (preds.get(preds.size() / 2).getData().getCoordinate() - this.calcRelativeCoordinate(preds.get(preds.size() / 2), n) + preds.get(preds.size() / 2 - 1).getData().getCoordinate() - this.calcRelativeCoordinate(preds.get(preds.size() / 2 - 1), n)) / 2;
                    } else {
                        assert (preds.size() >= 1);
                        pos = preds.get(preds.size() / 2).getData().getCoordinate() - this.calcRelativeCoordinate(preds.get(preds.size() / 2), n);
                    }
                }
                this.tryAdding(alreadyAssigned, n, pos);
            }
        }
        for (i = layers.length - 2; i >= 0; --i) {
            processingList = new ArrayList<Node<NodeData, EdgeData>>(layers[i]);
            Collections.sort(processingList, new Comparator<Node<NodeData, EdgeData>>(){

                @Override
                public int compare(Node<NodeData, EdgeData> o1, Node<NodeData, EdgeData> o2) {
                    if (o2.getData().isDummy()) {
                        return 1;
                    }
                    if (o1.getData().isDummy()) {
                        return -1;
                    }
                    return o2.getOutEdges().size() - o1.getOutEdges().size();
                }
            });
            alreadyAssigned = new ArrayList();
            for (Node<NodeData, EdgeData> n : processingList) {
                ArrayList<Node<NodeData, EdgeData>> succs = new ArrayList<Node<NodeData, EdgeData>>(n.getSuccessors());
                pos = n.getData().getCoordinate();
                if (succs.size() > 0) {
                    Collections.sort(succs, new Comparator<Node<NodeData, EdgeData>>(){

                        @Override
                        public int compare(Node<NodeData, EdgeData> o1, Node<NodeData, EdgeData> o2) {
                            return o1.getData().getCoordinate() - o2.getData().getCoordinate();
                        }
                    });
                    if (succs.size() % 2 == 0) {
                        assert (succs.size() >= 2);
                        pos = (succs.get(succs.size() / 2).getData().getCoordinate() - this.calcRelativeCoordinate(n, succs.get(succs.size() / 2)) + succs.get(succs.size() / 2 - 1).getData().getCoordinate() - this.calcRelativeCoordinate(n, succs.get(succs.size() / 2 - 1))) / 2;
                    } else {
                        assert (succs.size() >= 1);
                        pos = succs.get(succs.size() / 2).getData().getCoordinate() - this.calcRelativeCoordinate(n, succs.get(succs.size() / 2));
                    }
                }
                this.tryAdding(alreadyAssigned, n, pos);
            }
        }
    }

    private int median(ArrayList<Integer> arr) {
        assert (arr.size() > 0);
        Collections.sort(arr);
        if (arr.size() % 2 == 0) {
            return (arr.get(arr.size() / 2) + arr.get(arr.size() / 2 - 1)) / 2;
        }
        return arr.get(arr.size() / 2);
    }

    private int calcRelativeCoordinate(Node<NodeData, EdgeData> n, Node<NodeData, EdgeData> succ) {
        if (n.getData().isDummy() && succ.getData().isDummy()) {
            return 0;
        }
        int pos = 0;
        int pos2 = 0;
        ArrayList<Integer> coords2 = new ArrayList<Integer>();
        ArrayList<Integer> coords = new ArrayList<Integer>();
        for (Edge<NodeData, EdgeData> e : n.getOutEdges()) {
            if (e.getDest() != succ) continue;
            if (e.getData().isReversed()) {
                if (!n.getData().isDummy()) {
                    coords.add(e.getData().getRelativeEnd().x);
                }
                if (succ.getData().isDummy()) continue;
                coords2.add(e.getData().getRelativeStart().x);
                continue;
            }
            if (!n.getData().isDummy()) {
                coords.add(e.getData().getRelativeStart().x);
            }
            if (succ.getData().isDummy()) continue;
            coords2.add(e.getData().getRelativeEnd().x);
        }
        if (!n.getData().isDummy()) {
            pos = this.median(coords);
        }
        if (!succ.getData().isDummy()) {
            pos2 = this.median(coords2);
        }
        return pos - pos2;
    }

    private boolean intersect(int v1, int w1, int v2, int w2) {
        if (v1 >= v2 && v1 < v2 + w2) {
            return true;
        }
        if (v1 + w1 > v2 && v1 + w1 < v2 + w2) {
            return true;
        }
        return v1 < v2 && v1 + w1 > v2;
    }

    private boolean intersect(Node<NodeData, EdgeData> n1, Node<NodeData, EdgeData> n2) {
        return this.intersect(n1.getData().getCoordinate(), n1.getData().getWidth() + 8, n2.getData().getCoordinate(), n2.getData().getWidth() + 8);
    }

    private void tryAdding(List<Node<NodeData, EdgeData>> alreadyAssigned, Node<NodeData, EdgeData> node, int pos) {
        boolean doesIntersect = false;
        node.getData().setCoordinate(pos);
        for (Node<NodeData, EdgeData> n : alreadyAssigned) {
            if (!this.intersect(node, n)) continue;
            doesIntersect = true;
            break;
        }
        if (!doesIntersect) {
            int insertPosition = 0;
            int z = 0;
            for (Node<NodeData, EdgeData> n : alreadyAssigned) {
                if (pos <= n.getData().getCoordinate()) break;
                insertPosition = z + 1;
                ++z;
            }
            alreadyAssigned.add(insertPosition, node);
        } else {
            assert (alreadyAssigned.size() > 0);
            int minOffset = Integer.MAX_VALUE;
            int minIndex = -1;
            int minPos = 0;
            int w = node.getData().getWidth() + 8;
            minIndex = 0;
            minPos = alreadyAssigned.get(0).getData().getCoordinate() - w;
            minOffset = Math.abs(minPos - pos);
            Node<NodeData, EdgeData> lastNode = alreadyAssigned.get(alreadyAssigned.size() - 1);
            int lastPos = lastNode.getData().getCoordinate() + lastNode.getData().getWidth() + 8;
            int lastOffset = Math.abs(lastPos - pos);
            if (lastOffset < minOffset) {
                minPos = lastPos;
                minOffset = lastOffset;
                minIndex = alreadyAssigned.size();
            }
            for (int i = 0; i < alreadyAssigned.size() - 1; ++i) {
                Node<NodeData, EdgeData> curNode = alreadyAssigned.get(i);
                Node<NodeData, EdgeData> nextNode = alreadyAssigned.get(i + 1);
                int start = curNode.getData().getCoordinate() + curNode.getData().getWidth() + 8;
                int end = nextNode.getData().getCoordinate() - 8;
                if (end - start < node.getData().getWidth()) continue;
                int cand1 = start;
                int cand2 = end - node.getData().getWidth();
                int off1 = Math.abs(cand1 - pos);
                int off2 = Math.abs(cand2 - pos);
                if (off1 < minOffset) {
                    minPos = cand1;
                    minOffset = off1;
                    minIndex = i + 1;
                }
                if (off2 >= minOffset) continue;
                minPos = cand2;
                minOffset = off2;
                minIndex = i + 1;
            }
            assert (minIndex != -1);
            node.getData().setCoordinate(minPos);
            alreadyAssigned.add(minIndex, node);
        }
    }

    private boolean findOverlap(List<Node<NodeData, EdgeData>> nodes, Node<NodeData, EdgeData> node) {
        for (Node<NodeData, EdgeData> n1 : nodes) {
            if (!this.intersect(n1, node)) continue;
            return true;
        }
        return false;
    }

    private int evaluateSolution() {
        int sum = 0;
        for (Edge<NodeData, EdgeData> e : this.graph.getEdges()) {
            Node<NodeData, EdgeData> source = e.getSource();
            Node<NodeData, EdgeData> dest = e.getDest();
            int offset = 0;
            offset = Math.abs(source.getData().getCoordinate() - dest.getData().getCoordinate());
            sum += offset;
        }
        return sum;
    }

    private void crossingReduction(ArrayList<Node<NodeData, EdgeData>>[] layers) {
        for (int i = 0; i < layers.length - 1; ++i) {
            ArrayList<Node<NodeData, EdgeData>> curNodes = layers[i];
            ArrayList<Node<NodeData, EdgeData>> nextNodes = layers[i + 1];
            for (Node<NodeData, EdgeData> n : curNodes) {
                for (Node<NodeData, EdgeData> succ : n.getSuccessors()) {
                    nextNodes.remove(succ);
                    nextNodes.add(succ);
                }
            }
        }
    }

    private void removeCycles(Set<Node<NodeData, EdgeData>> rootNodes) {
        final ArrayList reversedEdges = new ArrayList();
        int removedCount = 0;
        int reversedCount = 0;
        Graph<NodeData, EdgeData> graph = this.graph;
        Objects.requireNonNull(graph);
        Graph.DFSTraversalVisitor visitor = new Graph.DFSTraversalVisitor(graph){

            public boolean visitEdge(Edge<NodeData, EdgeData> e, boolean backEdge) {
                if (backEdge) {
                    reversedEdges.add(e);
                    e.getData().setReversed(!e.getData().isReversed());
                }
                return e.getData().isImportant();
            }
        };
        HashSet nodes = new HashSet();
        nodes.addAll(rootNodes);
        assert (nodes.size() > 0);
        this.graph.traverseDFS(nodes, visitor);
        for (Edge e : reversedEdges) {
            if (e.isSelfLoop()) {
                e.remove();
                ++removedCount;
                continue;
            }
            e.reverse();
            ++reversedCount;
        }
    }

    private boolean checkRemoveCycles() {
        return !this.graph.hasCycles();
    }

    private void assignLayers(Set<Node<NodeData, EdgeData>> rootNodes, Set<? extends Vertex> firstLayerHints, Set<? extends Vertex> lastLayerHints) {
        this.maxLayer = -1;
        for (Node<NodeData, EdgeData> n : this.graph.getNodes()) {
            n.getData().setLayer(-1);
        }
        Graph.BFSTraversalVisitor traverser = new Graph.BFSTraversalVisitor(this.graph){

            public void visitNode(Node<NodeData, EdgeData> n, int depth) {
                if (depth > n.getData().getLayer()) {
                    n.getData().setLayer(depth);
                    HierarchicalLayoutManager.this.maxLayer = Math.max(HierarchicalLayoutManager.this.maxLayer, depth);
                }
            }
        };
        for (Node<NodeData, EdgeData> node : rootNodes) {
            if (node.getData().getLayer() != -1) continue;
            this.graph.traverseBFS(node, traverser, true);
        }
        for (Vertex vertex : firstLayerHints) {
            assert (this.nodeMap.containsKey(vertex));
            this.nodeMap.get(vertex).getData().setLayer(0);
        }
        for (Vertex vertex : lastLayerHints) {
            assert (this.nodeMap.containsKey(vertex));
            this.nodeMap.get(vertex).getData().setLayer(this.maxLayer);
        }
    }

    private boolean checkAssignLayers() {
        for (Edge<NodeData, EdgeData> edge : this.graph.getEdges()) {
            Node<NodeData, EdgeData> node = edge.getSource();
            Node<NodeData, EdgeData> dest = edge.getDest();
            if (node.getData().getLayer() < dest.getData().getLayer()) continue;
            return false;
        }
        int maxLayer = 0;
        for (Node<NodeData, EdgeData> node : this.graph.getNodes()) {
            assert (node.getData().getLayer() >= 0);
            if (node.getData().getLayer() <= maxLayer) continue;
            maxLayer = node.getData().getLayer();
        }
        int[] nArray = new int[maxLayer + 1];
        for (Node<NodeData, EdgeData> n : this.graph.getNodes()) {
            int n2 = n.getData().getLayer();
            nArray[n2] = nArray[n2] + 1;
        }
        return true;
    }

    public static enum Combine {
        NONE,
        SAME_INPUTS,
        SAME_OUTPUTS;

    }

    private class NodeData {
        private Map<Port, Integer> reversePositions;
        private Vertex node;
        private Link edge;
        private int layer;
        private int x;
        private int y;
        private int width;

        public NodeData(Vertex node) {
            this.reversePositions = new HashMap<Port, Integer>();
            this.layer = -1;
            this.node = node;
            assert (node != null);
            this.width = node.getSize().width;
        }

        public NodeData(Link edge) {
            this.layer = -1;
            this.edge = edge;
            assert (edge != null);
            this.width = 0;
        }

        public Vertex getNode() {
            return this.node;
        }

        public Link getEdge() {
            return this.edge;
        }

        public int getCoordinate() {
            return this.x;
        }

        public int getLayerCoordinate() {
            return this.y;
        }

        public void setCoordinate(int x) {
            this.x = x;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public void setLayerCoordinate(int y) {
            this.y = y;
        }

        public void setLayer(int x) {
            this.layer = x;
        }

        public int getLayer() {
            return this.layer;
        }

        public boolean isDummy() {
            return this.edge != null;
        }

        public int getWidth() {
            return this.width;
        }

        public void addReversedStartEdge(Edge<NodeData, EdgeData> e) {
            assert (e.getData().isReversed());
            Port port = e.getData().getEdge().getTo();
            int pos = this.addReversedPort(port);
            Point start = e.getData().getRelativeStart();
            e.getData().addStartPoint(start);
            int yCoord = this.node.getSize().height + this.width - this.node.getSize().width;
            e.getData().addStartPoint(new Point(start.x, yCoord));
            e.getData().addStartPoint(new Point(pos, yCoord));
            e.getData().setRelativeStart(new Point(pos, 0));
        }

        private int addReversedPort(Port p) {
            if (this.reversePositions.containsKey(p)) {
                return this.reversePositions.get(p);
            }
            this.width += 8;
            this.reversePositions.put(p, this.width);
            return this.width;
        }

        public void addReversedEndEdge(Edge<NodeData, EdgeData> e) {
            assert (e.getData().isReversed());
            int pos = this.addReversedPort(e.getData().getEdge().getFrom());
            Point end = e.getData().getRelativeEnd();
            e.getData().setRelativeEnd(new Point(pos, this.node.getSize().height));
            int yCoord = 0 - this.width + this.node.getSize().width;
            e.getData().addEndPoint(new Point(pos, yCoord));
            e.getData().addEndPoint(new Point(end.x, yCoord));
            e.getData().addEndPoint(end);
        }

        public int getHeight() {
            if (this.isDummy()) {
                return 0;
            }
            return this.node.getSize().height;
        }

        public String toString() {
            if (this.isDummy()) {
                return this.edge.toString() + "(layer=" + this.layer + ")";
            }
            return this.node.toString() + "(layer=" + this.layer + ")";
        }
    }

    private class EdgeData {
        private Point relativeEnd;
        private Point relativeStart;
        private List<Point> startPoints;
        private List<Point> endPoints;
        private boolean important;
        private boolean reversed;
        private Link edge;

        public EdgeData(Link edge) {
            this(edge, false);
        }

        public EdgeData(Link edge, boolean rev) {
            this.edge = edge;
            this.reversed = rev;
            this.relativeStart = edge.getFrom().getRelativePosition();
            this.relativeEnd = edge.getTo().getRelativePosition();
            assert (this.relativeStart.x >= 0 && this.relativeStart.x <= edge.getFrom().getVertex().getSize().width);
            assert (this.relativeStart.y >= 0 && this.relativeStart.y <= edge.getFrom().getVertex().getSize().height);
            assert (this.relativeEnd.x >= 0 && this.relativeEnd.x <= edge.getTo().getVertex().getSize().width);
            assert (this.relativeEnd.y >= 0 && this.relativeEnd.y <= edge.getTo().getVertex().getSize().height);
            this.startPoints = new ArrayList<Point>();
            this.endPoints = new ArrayList<Point>();
            this.important = true;
        }

        public boolean isImportant() {
            return this.important;
        }

        public void setImportant(boolean b) {
            this.important = b;
        }

        public List<Point> getStartPoints() {
            return this.startPoints;
        }

        public List<Point> getEndPoints() {
            return this.endPoints;
        }

        public List<Point> getAbsoluteEndPoints() {
            if (this.endPoints.size() == 0) {
                return this.endPoints;
            }
            ArrayList<Point> result = new ArrayList<Point>();
            Point point = this.edge.getTo().getVertex().getPosition();
            for (Point p : this.endPoints) {
                Point p2 = new Point(p.x + point.x, p.y + point.y);
                result.add(p2);
            }
            return result;
        }

        public List<Point> getAbsoluteStartPoints() {
            if (this.startPoints.size() == 0) {
                return this.startPoints;
            }
            ArrayList<Point> result = new ArrayList<Point>();
            Point point = this.edge.getFrom().getVertex().getPosition();
            for (Point p : this.startPoints) {
                Point p2 = new Point(p.x + point.x, p.y + point.y);
                result.add(p2);
            }
            return result;
        }

        public void addEndPoint(Point p) {
            this.endPoints.add(p);
        }

        public void addStartPoint(Point p) {
            this.startPoints.add(p);
        }

        public Link getEdge() {
            return this.edge;
        }

        public void setRelativeEnd(Point p) {
            this.relativeEnd = p;
        }

        public void setRelativeStart(Point p) {
            this.relativeStart = p;
        }

        public Point getRelativeEnd() {
            return this.relativeEnd;
        }

        public Point getRelativeStart() {
            return this.relativeStart;
        }

        public boolean isReversed() {
            return this.reversed;
        }

        public void setReversed(boolean b) {
            this.reversed = b;
        }

        public String toString() {
            return "EdgeData[reversed=" + this.reversed + "]";
        }
    }
}

