/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.nc.model;

import at.ssw.visualizer.model.Compilation;
import at.ssw.visualizer.model.cfg.BasicBlock;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import at.ssw.visualizer.nc.model.NCScanner;
import at.ssw.visualizer.nc.model.NCTokenContext;
import at.ssw.visualizer.texteditor.model.BlockRegion;
import at.ssw.visualizer.texteditor.model.FoldingRegion;
import at.ssw.visualizer.texteditor.model.HoverParser;
import at.ssw.visualizer.texteditor.model.Text;
import at.ssw.visualizer.texteditor.model.TextBuilder;
import at.ssw.visualizer.texteditor.model.TextRegion;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.editor.TokenID;

public class NCTextBuilder
extends TextBuilder {
    public static final FoldType KIND_BLOCK = new FoldType("...");
    public static final FoldType LIR_BLOCK = new FoldType("");
    private CodeBlock codeBlock = null;
    private CommentBlock commentBlock = null;

    public NCTextBuilder() {
        this.scanner = new NCScanner();
    }

    public Text buildDocument(ControlFlowGraph cfg) {
        Compilation compilation = cfg.getCompilation();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        this.text.append(compilation.getMethod()).append("\n");
        this.text.append(dateFormat.format(compilation.getDate())).append("\n\n");
        return this.buildDocument(cfg, false);
    }

    private Text buildDocument(ControlFlowGraph cfg, boolean skipLIR) {
        String[] methodText;
        String text = cfg.getNativeMethod().getMethodText().trim();
        if (text.startsWith("<<<HexCodeFile") && text.endsWith("HexCodeFile>>>")) {
            this.append(text);
            return this.buildText(cfg, "text/x-compilation-nc");
        }
        block5: for (String s : methodText = text.split("\n")) {
            String l = s.trim();
            if (l.length() <= 0) continue;
            switch (l.charAt(0)) {
                case '[': {
                    this.checkComment();
                    this.append(s);
                    this.append("\n");
                    continue block5;
                }
                case ';': {
                    this.parseComment(cfg, s, skipLIR);
                    continue block5;
                }
                case '0': {
                    this.checkComment();
                    this.parseCodeLine(l);
                    this.append(l);
                    this.append("\n");
                }
            }
        }
        if (this.codeBlock != null) {
            this.foldingRegions.add(new FoldingRegion(KIND_BLOCK, this.codeBlock.codeStart + 1, this.codeBlock.start + this.codeBlock.length - 1, false));
        }
        return this.buildText(cfg, "text/x-compilation-nc");
    }

    public String buildView(ControlFlowGraph cfg, BasicBlock[] blocks) {
        if (cfg.getNativeMethod() == null) {
            return "No native code available\n";
        }
        Text t = this.buildDocument(cfg, true);
        String contents = t.getText();
        StringBuilder view = new StringBuilder();
        for (BasicBlock bb : blocks) {
            BlockRegion reg = (BlockRegion)t.getBlocks().get(bb);
            if (reg == null) continue;
            view.append(contents.substring(reg.getStart(), reg.getEnd()));
        }
        return view.toString();
    }

    private void parseComment(ControlFlowGraph cfg, String s, boolean skipComments) {
        int i;
        String l = s.trim();
        for (i = 0; i < l.length() && (l.charAt(i) == ';' || l.charAt(i) == ' '); ++i) {
        }
        if (l.length() > i + 5 && l.substring(i, i + 5).equals("block")) {
            if (this.codeBlock != null) {
                this.appendBlock();
            }
            this.codeBlock = new CodeBlock(l.substring(i + 6, l.indexOf(32, i + 6)), cfg);
        } else if (l.contains("slow case") && this.codeBlock != null && this.codeBlock.name != null) {
            this.appendBlock();
            this.codeBlock = new CodeBlock(null, cfg);
            this.append(s);
            this.append("\n");
        } else {
            if (this.commentBlock == null) {
                this.commentBlock = new CommentBlock();
            }
            if (!skipComments) {
                this.append(s);
                this.append("\n");
                this.commentBlock.length += s.length() + 1;
            }
        }
    }

    private void parseCodeLine(String s) {
        int start = this.text.length() + 2;
        boolean refAdr = false;
        String addr = null;
        this.scanner.setText(s, 0, s.length());
        TokenID token = this.scanner.nextToken();
        while (token != null && token != NCTokenContext.EOF_TOKEN) {
            switch (token.getNumericID()) {
                case 4: {
                    addr = this.scanner.getTokenString();
                    if (refAdr) {
                        this.addReference(this.normalizeAddr(addr), s);
                        this.addReference(this.trimAddr(addr), s);
                        break;
                    }
                    this.hyperlinks.put(this.trimAddr(addr), new TextRegion(start, start + addr.length()));
                    this.hoverKeys.add(this.normalizeAddr(addr));
                    this.hoverKeys.add(this.trimAddr(addr));
                    this.addDefinition(this.normalizeAddr(addr), s);
                    this.addDefinition(this.trimAddr(addr), s);
                    refAdr = true;
                    break;
                }
                case 6: {
                    String reg = this.scanner.getTokenString();
                    this.hoverKeys.add(reg);
                    this.addReference(reg, s);
                }
            }
            token = this.scanner.nextToken();
        }
    }

    private void addReference(String key, String s) {
        if (!this.hoverReferences.containsKey(key)) {
            this.hoverReferences.put(key, new ArrayList());
        }
        String bn = this.codeBlock == null || this.codeBlock.name == null ? "" : this.codeBlock.name + ":\t";
        ((List)this.hoverReferences.get(key)).add(bn + s.trim());
    }

    private void addDefinition(String key, String s) {
        String bn = this.codeBlock == null || this.codeBlock.name == null ? "" : this.codeBlock.name + ":\t";
        this.hoverDefinitions.put(key, bn + s.trim());
    }

    private static boolean isAddressParseableAsSignedLong(String addr) {
        return addr.length() < 18 && Character.isDigit(addr.charAt(2));
    }

    private String normalizeAddr(String addr) {
        if (!NCTextBuilder.isAddressParseableAsSignedLong(addr)) {
            return addr;
        }
        StringBuilder addrString = new StringBuilder(Long.toString(Long.decode(addr), 16));
        for (int i = addrString.length(); i < 8; ++i) {
            addrString.insert(0, 0);
        }
        addrString.insert(0, "0x");
        return addrString.toString();
    }

    private String trimAddr(String addr) {
        if (!NCTextBuilder.isAddressParseableAsSignedLong(addr)) {
            return addr;
        }
        return "0x" + Long.toString(Long.decode(addr), 16);
    }

    private void appendBlock() {
        this.foldingRegions.add(new FoldingRegion(KIND_BLOCK, this.codeBlock.codeStart, this.codeBlock.start + this.codeBlock.length - 1, false));
        if (this.codeBlock != null && this.codeBlock.basicBlock != null) {
            this.blocks.put(this.codeBlock.basicBlock, new BlockRegion(this.codeBlock.basicBlock, this.codeBlock.start, this.codeBlock.start + this.codeBlock.length, this.codeBlock.start, this.codeBlock.start + this.codeBlock.basicBlock.getName().length()));
        }
        this.hyperlinks.put(this.codeBlock.name, new TextRegion(this.codeBlock.start, this.codeBlock.start + this.codeBlock.name.length()));
        this.codeBlock = null;
    }

    private void checkComment() {
        if (this.commentBlock != null) {
            this.foldingRegions.add(new FoldingRegion(LIR_BLOCK, this.commentBlock.start, this.commentBlock.start + this.commentBlock.length + 1, false));
            this.commentBlock = null;
        }
    }

    private void append(String s) {
        HoverParser p = new HoverParser(s);
        while (p.hasNext()) {
            int start = this.text.length();
            String part = p.next();
            this.text.append(part);
            if (this.codeBlock != null) {
                this.codeBlock.length += part.length();
            }
            if (p.getHover() == null) continue;
            this.regionHovers.put(new TextRegion(start, this.text.length()), p.getHover());
        }
    }

    protected void buildHighlighting() {
        this.scanner.setText(this.text.toString(), 0, this.text.length());
        TokenID token = this.scanner.nextToken();
        HashMap highlightings = new HashMap();
        while (token != null && token != NCTokenContext.EOF_TOKEN) {
            switch (token.getNumericID()) {
                case 4: {
                    String name = this.trimAddr(this.scanner.getTokenString());
                    if (!highlightings.containsKey(this.scanner.getTokenString()) && !highlightings.containsKey(name)) {
                        ArrayList tr = new ArrayList();
                        highlightings.put(this.normalizeAddr(name), tr);
                        highlightings.put(name, tr);
                    }
                    ((List)highlightings.get(this.normalizeAddr(name))).add(new TextRegion(this.scanner.getTokenOffset(), this.scanner.getOffset()));
                    ((List)highlightings.get(name)).add(new TextRegion(this.scanner.getTokenOffset(), this.scanner.getOffset()));
                    break;
                }
                case 6: 
                case 7: {
                    if (!highlightings.containsKey(this.scanner.getTokenString())) {
                        highlightings.put(this.scanner.getTokenString(), new ArrayList());
                    }
                    ((List)highlightings.get(this.scanner.getTokenString())).add(new TextRegion(this.scanner.getTokenOffset(), this.scanner.getOffset()));
                }
            }
            token = this.scanner.nextToken();
        }
        for (String key : highlightings.keySet()) {
            List regions = (List)highlightings.get(key);
            this.highlighting.put(key, regions.toArray(new TextRegion[regions.size()]));
        }
    }

    private class CodeBlock {
        private String name;
        private BasicBlock basicBlock;
        private int start;
        private int codeStart;
        private int length;

        private CodeBlock(String name, ControlFlowGraph cfg) {
            this.name = name;
            this.basicBlock = name == null ? null : cfg.getBasicBlockByName(name);
            this.start = NCTextBuilder.this.text.length();
            if (this.basicBlock != null) {
                NCTextBuilder.this.appendBlockDetails(this.basicBlock);
                NCTextBuilder.this.append("\n");
            }
            this.codeStart = NCTextBuilder.this.text.length() - 1;
            this.length = NCTextBuilder.this.text.length() - this.start;
        }
    }

    private class CommentBlock {
        int start;
        int length;

        private CommentBlock() {
            this.start = NCTextBuilder.this.text.length();
            this.length = 0;
        }
    }
}

