/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.bc.modelimpl;

import at.ssw.visualizer.bc.modelimpl.BytecodesImpl;
import at.ssw.visualizer.bc.modelimpl.MethodName;
import at.ssw.visualizer.model.bc.Bytecodes;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class BytecodesParser {
    private BytecodesParser() {
    }

    public static List<Bytecodes> readMethod(ControlFlowGraph cfg, String method, String[] classPaths) {
        ArrayList<Bytecodes> result = new ArrayList<Bytecodes>();
        MethodName methodName = MethodName.parse(method);
        if (methodName == null) {
            return result;
        }
        for (String classPath : classPaths) {
            try {
                ClassParser cp = BytecodesParser.locateClass(methodName, classPath);
                if (cp == null) continue;
                JavaClass c = cp.parse();
                for (Method m : c.getMethods()) {
                    if (!methodName.matches(m)) continue;
                    result.add(BytecodesParser.readBytecodes(cfg, methodName, m));
                }
            }
            catch (IOException ex) {
                Logger log = Logger.getLogger(BytecodesParser.class.getName());
                log.log(Level.INFO, ex.getMessage(), ex);
            }
        }
        return result;
    }

    private static ClassParser locateClass(MethodName methodName, String classPath) throws IOException {
        File baseFile = new File(classPath);
        if (!baseFile.exists()) {
            return null;
        }
        if (baseFile.isDirectory()) {
            String className = methodName.className.replace('.', File.separatorChar) + ".class";
            File classFile = new File(baseFile, className);
            if (classFile.exists()) {
                return new ClassParser(new FileInputStream(classFile), className);
            }
        } else {
            ZipFile zipFile = new ZipFile(baseFile);
            String className = methodName.className.replace('.', '/') + ".class";
            ZipEntry zipEntry = zipFile.getEntry(className);
            if (zipEntry != null) {
                return new ClassParser(zipFile.getInputStream(zipEntry), className);
            }
        }
        return null;
    }

    private static Bytecodes readBytecodes(ControlFlowGraph cfg, MethodName methodName, Method method) {
        Code code = method.getCode();
        Scanner bcScanner = new Scanner(code.toString());
        String prolog = "";
        String attributes = "";
        TreeMap<Integer, String> byteCodes = new TreeMap<Integer, String>();
        bcScanner.useDelimiter("\n");
        while (bcScanner.hasNext()) {
            String codeLine = bcScanner.next();
            if (codeLine.startsWith("Code")) {
                prolog = codeLine;
                continue;
            }
            if (codeLine.length() > 0 && codeLine.charAt(0) >= '0' && codeLine.charAt(0) <= '9' && codeLine.indexOf(58) > 0) {
                Scanner codeLineScanner = new Scanner(codeLine);
                codeLineScanner.useDelimiter(":\\s*");
                int key = Integer.parseInt(codeLineScanner.next());
                byteCodes.put(key, codeLineScanner.next());
                codeLineScanner.close();
                continue;
            }
            if (codeLine.length() <= 0 || codeLine.charAt(0) == ' ') continue;
            attributes = attributes + codeLine + "\n";
        }
        bcScanner.close();
        StringBuilder sb = new StringBuilder();
        sb.append(method.getReturnType()).append(" ");
        sb.append(methodName.className);
        sb.append(".").append(method.getName()).append("(");
        boolean sep = false;
        for (Type t : method.getArgumentTypes()) {
            if (sep) {
                sb.append(", ");
            }
            sb.append(t);
            sep = true;
        }
        sb.append(")");
        String name = sb.toString();
        sb = new StringBuilder();
        int point = methodName.className.lastIndexOf(46);
        if (point > 0) {
            sb.append(methodName.className.substring(point + 1));
        } else {
            sb.append(methodName.className);
        }
        sb.append(".").append(method.getName());
        String shortName = sb.toString();
        return new BytecodesImpl(cfg, name, shortName, prolog, attributes, byteCodes);
    }
}

