/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.bc.modelimpl;

import at.ssw.visualizer.bc.modelimpl.BytecodesParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class MethodName {
    public String methodModifier;
    public Type returnValType;
    public String className;
    public String methodName;
    public List<Type> arguments;

    private MethodName() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodName parse(String name) {
        Scanner methodScanner = new Scanner(name);
        methodScanner.useDelimiter("\\s|\\,\\s|\\(|\\)$");
        try {
            MethodName result = new MethodName();
            result.methodModifier = methodScanner.next();
            result.returnValType = MethodName.getTypeOf(methodScanner.next());
            String[] classMethodName = methodScanner.next().split("\\.");
            StringBuilder pkgClass = new StringBuilder();
            pkgClass.append(classMethodName[0]);
            for (int i = 1; i < classMethodName.length - 1; ++i) {
                pkgClass.append(".");
                pkgClass.append(classMethodName[i]);
            }
            result.className = pkgClass.toString();
            result.methodName = classMethodName[classMethodName.length - 1];
            result.arguments = new ArrayList<Type>();
            while (methodScanner.hasNext()) {
                String argument = methodScanner.next();
                if (argument.equals("")) continue;
                result.arguments.add(MethodName.getTypeOf(argument));
            }
            MethodName methodName = result;
            return methodName;
        }
        catch (Exception ex) {
            Logger log = Logger.getLogger(BytecodesParser.class.getName());
            log.log(Level.WARNING, ex.getMessage(), ex);
            MethodName methodName = null;
            return methodName;
        }
        finally {
            methodScanner.close();
        }
    }

    public boolean matches(Method m) {
        if (!this.methodName.equals(m.getName())) {
            return false;
        }
        if (this.returnValType != Type.UNKNOWN && this.returnValType != m.getReturnType()) {
            return false;
        }
        if (this.arguments.size() != m.getArgumentTypes().length) {
            return false;
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (this.arguments.get(i) == Type.UNKNOWN || this.arguments.get(i) == m.getArgumentTypes()[i]) continue;
            return false;
        }
        return true;
    }

    private static Type getTypeOf(String type) {
        if (type.equals("void")) {
            return Type.VOID;
        }
        if (type.equals("jint")) {
            return Type.INT;
        }
        if (type.equals("jshort")) {
            return Type.SHORT;
        }
        if (type.equals("jlong")) {
            return Type.LONG;
        }
        if (type.equals("jchar")) {
            return Type.CHAR;
        }
        if (type.equals("jboolean")) {
            return Type.BOOLEAN;
        }
        if (type.equals("jdouble")) {
            return Type.DOUBLE;
        }
        if (type.equals("jfloat")) {
            return Type.FLOAT;
        }
        return Type.UNKNOWN;
    }
}

