/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.texteditor;

import at.ssw.visualizer.core.selection.Selection;
import at.ssw.visualizer.core.selection.SelectionManager;
import at.ssw.visualizer.core.selection.SelectionProvider;
import at.ssw.visualizer.model.cfg.BasicBlock;
import at.ssw.visualizer.texteditor.EditorSupport;
import at.ssw.visualizer.texteditor.model.BlockRegion;
import at.ssw.visualizer.texteditor.model.Text;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;

public abstract class Editor
extends CloneableEditor
implements SelectionProvider {
    protected Selection selection;
    private boolean selectionUpdating;
    private BasicBlock[] curBlocks;
    private boolean initialized;
    private ChangeListener selectionListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent event) {
            if (Editor.this.selectionUpdating) {
                return;
            }
            Editor.this.selectionUpdating = true;
            Text text = (Text)Editor.this.getEditorPane().getDocument().getProperty(Text.class);
            Object[] newBlocks = (BasicBlock[])Editor.this.selection.get(BasicBlock[].class);
            if (newBlocks != null && newBlocks.length > 0 && !Arrays.equals(Editor.this.curBlocks, newBlocks)) {
                BlockRegion r = text.getBlocks().get(newBlocks[0]);
                int startOffset = r.getNameStart();
                int endOffset = r.getNameEnd();
                if (newBlocks.length > 1) {
                    for (Object b : newBlocks) {
                        r = text.getBlocks().get(b);
                        startOffset = Math.min(startOffset, r.getStart());
                        endOffset = Math.max(endOffset, r.getEnd());
                    }
                }
                Editor.this.getEditorPane().select(startOffset, endOffset);
            }
            Editor.access$102(Editor.this, (BasicBlock[])newBlocks);
            Editor.this.selectionUpdating = false;
        }
    };
    private CaretListener caretListener = new CaretListener(){

        @Override
        public void caretUpdate(CaretEvent event) {
            if (Editor.this.selectionUpdating) {
                return;
            }
            Editor.this.selectionUpdating = true;
            Text text = (Text)Editor.this.getEditorPane().getDocument().getProperty(Text.class);
            ArrayList<BasicBlock> newBlocks = new ArrayList<BasicBlock>();
            int startOffset = Math.min(event.getDot(), event.getMark());
            int endOffset = Math.max(event.getDot(), event.getMark());
            for (BlockRegion region : text.getBlocks().values()) {
                if (region.getStart() > endOffset || region.getEnd() <= startOffset) continue;
                newBlocks.add(region.getBlock());
            }
            Editor.access$102(Editor.this, newBlocks.toArray(new BasicBlock[newBlocks.size()]));
            Editor.this.selection.put((Object)Editor.this.curBlocks);
            Editor.this.selectionUpdating = false;
        }
    };

    protected Editor(EditorSupport support) {
        super((CloneableEditorSupport)support);
        this.selection = new Selection();
        this.selection.put((Object)support.getControlFlowGraph());
        this.selection.addChangeListener(this.selectionListener);
    }

    public Selection getSelection() {
        return this.selection;
    }

    protected void componentShowing() {
        super.componentShowing();
        if (!this.initialized) {
            this.getEditorPane().addCaretListener(this.caretListener);
            this.initialized = true;
        }
    }

    protected void componentActivated() {
        super.componentActivated();
        SelectionManager.getDefault().setSelection(this.selection);
    }

    protected void componentClosed() {
        super.componentClosed();
        SelectionManager.getDefault().removeSelection(this.selection);
    }

    public int getPersistenceType() {
        return 2;
    }

    static /* synthetic */ BasicBlock[] access$102(Editor x0, BasicBlock[] x1) {
        x0.curBlocks = x1;
        return x1;
    }
}

