/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.texteditor;

import at.ssw.visualizer.model.Compilation;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import at.ssw.visualizer.texteditor.model.Text;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.text.CloneableEditorSupport;
import org.openide.windows.CloneableOpenSupport;

public abstract class EditorSupport
extends CloneableEditorSupport
implements EditCookie,
EditorCookie,
EditorCookie.Observable {
    protected ControlFlowGraph cfg;
    protected Text text;

    protected EditorSupport(ControlFlowGraph cfg) {
        super((CloneableEditorSupport.Env)new Env());
        ((Env)this.env).editorSupport = this;
        this.cfg = cfg;
    }

    public ControlFlowGraph getControlFlowGraph() {
        return this.cfg;
    }

    protected StyledDocument createStyledDocument(EditorKit kit) {
        StyledDocument doc = super.createStyledDocument(kit);
        doc.putProperty(Text.class, this.text);
        doc.putProperty(Compilation.class, this.cfg.getCompilation());
        doc.putProperty(ControlFlowGraph.class, this.cfg);
        return doc;
    }

    public abstract String getMimeType();

    protected String messageOpening() {
        return "Opening " + this.messageToolTip();
    }

    protected String messageOpened() {
        return "Opened " + this.messageToolTip();
    }

    protected String messageSave() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected String messageName() {
        return this.cfg.getCompilation().getShortName();
    }

    protected String messageToolTip() {
        return this.cfg.getCompilation().getMethod() + " - " + this.cfg.getName();
    }

    public static class Env
    implements CloneableEditorSupport.Env {
        private PropertyChangeSupport prop = new PropertyChangeSupport(this);
        private VetoableChangeSupport veto = new VetoableChangeSupport(this);
        private EditorSupport editorSupport;

        public InputStream inputStream() throws IOException {
            return new ByteArrayInputStream(this.editorSupport.text.getText().getBytes());
        }

        public OutputStream outputStream() throws IOException {
            throw new IOException("Editor is readonly");
        }

        public Date getTime() {
            return this.editorSupport.cfg.getCompilation().getDate();
        }

        public String getMimeType() {
            return this.editorSupport.getMimeType();
        }

        public boolean isValid() {
            return true;
        }

        public boolean isModified() {
            return false;
        }

        public void markModified() throws IOException {
            throw new IOException("Editor is readonly");
        }

        public void unmarkModified() {
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return this.editorSupport;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.prop.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.prop.removePropertyChangeListener(l);
        }

        public void addVetoableChangeListener(VetoableChangeListener l) {
            this.veto.addVetoableChangeListener(l);
        }

        public void removeVetoableChangeListener(VetoableChangeListener l) {
            this.veto.removeVetoableChangeListener(l);
        }
    }
}

