/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.texteditor.hyperlink;

import at.ssw.visualizer.texteditor.model.Scanner;
import at.ssw.visualizer.texteditor.model.Text;
import at.ssw.visualizer.texteditor.model.TextRegion;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;

public class HyperlinkProvider
implements org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider {
    protected Scanner scanner = null;

    protected TextRegion findTarget(Document doc, int offset) {
        Text text = (Text)doc.getProperty(Text.class);
        if (text == null) {
            return null;
        }
        this.scanner = text.getScanner();
        this.scanner.setText(doc);
        this.scanner.findTokenBegin(offset);
        TokenID token = this.scanner.nextToken();
        if (token.getNumericID() < 0) {
            return null;
        }
        return text.getHyperlinkTarget(this.scanner.getTokenString());
    }

    public boolean isHyperlinkPoint(Document doc, int offset) {
        return this.findTarget(doc, offset) != null;
    }

    public int[] getHyperlinkSpan(Document doc, int offset) {
        if (this.findTarget(doc, offset) != null) {
            return new int[]{this.scanner.getTokenOffset(), this.scanner.getTokenOffset() + this.scanner.getTokenLength()};
        }
        return null;
    }

    public void performClickAction(Document doc, int offset) {
        TextRegion target = this.findTarget(doc, offset);
        if (target != null) {
            JTextComponent editor = Utilities.getFocusedComponent();
            editor.select(target.getStart(), target.getEnd());
        }
    }
}

