/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.texteditor.model;

import java.util.Iterator;

public class HoverParser
implements Iterator<String> {
    private static String HOVER_START = "<@";
    private static String HOVER_SEP = "|@";
    private static String HOVER_END = ">@";
    private String text;
    private int curPos;
    private String curText;
    private String curHover;
    private boolean curNewLine;

    public static String firstLine(String text) {
        if (text == null) {
            return "";
        }
        HoverParser p = new HoverParser(text);
        StringBuilder result = new StringBuilder(text.length());
        while (p.hasNext()) {
            String part = p.next();
            if (p.isNewLine()) break;
            result.append(part);
        }
        return result.toString();
    }

    public HoverParser(String text) {
        this.text = text;
    }

    private void advance() {
        int nextEnd;
        int nextSep;
        int lineStart = this.text.indexOf(10, this.curPos);
        int nextStart = this.text.indexOf(HOVER_START, this.curPos);
        if (lineStart == this.curPos) {
            this.curText = "\n";
            this.curHover = null;
            this.curPos = lineStart + 1;
            this.curNewLine = true;
            while (this.curPos < this.text.length() && this.text.charAt(this.curPos) <= ' ') {
                ++this.curPos;
            }
            return;
        }
        this.curNewLine = false;
        if (lineStart != -1 && (nextStart == -1 || lineStart < nextStart)) {
            this.curText = this.text.substring(this.curPos, lineStart);
            this.curHover = null;
            this.curPos = lineStart;
            return;
        }
        if (nextStart == this.curPos && (nextSep = this.text.indexOf(HOVER_SEP, nextStart)) != -1 && (nextEnd = this.text.indexOf(HOVER_END, nextSep)) != -1) {
            this.curText = this.text.substring(nextStart + HOVER_START.length(), nextSep);
            this.curHover = this.text.substring(nextSep + HOVER_SEP.length(), nextEnd);
            while (this.curHover.endsWith("\n")) {
                this.curHover = this.curHover.substring(0, this.curHover.length() - 1);
            }
            this.curPos = nextEnd + HOVER_END.length();
            return;
        }
        if (nextStart == this.curPos) {
            ++nextStart;
        }
        if (nextStart != -1) {
            this.curText = this.text.substring(this.curPos, nextStart);
            this.curHover = null;
            this.curPos = nextStart;
        } else if (this.curPos < this.text.length()) {
            this.curText = this.text.substring(this.curPos);
            this.curHover = null;
            this.curPos = this.text.length();
        } else {
            this.curText = null;
            this.curHover = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.curPos < this.text.length();
    }

    @Override
    public String next() {
        this.advance();
        return this.curText;
    }

    public String getHover() {
        return this.curHover;
    }

    public boolean isNewLine() {
        return this.curNewLine;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }
}

