/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.texteditor.model;

import at.ssw.visualizer.model.cfg.BasicBlock;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import at.ssw.visualizer.texteditor.model.BlockRegion;
import at.ssw.visualizer.texteditor.model.FoldingRegion;
import at.ssw.visualizer.texteditor.model.Scanner;
import at.ssw.visualizer.texteditor.model.Text;
import at.ssw.visualizer.texteditor.model.TextRegion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class TextBuilder {
    protected StringBuilder text = new StringBuilder(4096);
    protected Scanner scanner;
    protected List<FoldingRegion> foldingRegions = new ArrayList<FoldingRegion>();
    protected Map<String, TextRegion> hyperlinks = new HashMap<String, TextRegion>();
    protected Map<String, String> stringHovers = new HashMap<String, String>();
    protected Map<TextRegion, String> regionHovers = new HashMap<TextRegion, String>();
    protected Map<String, TextRegion[]> highlighting = new HashMap<String, TextRegion[]>();
    protected Map<BasicBlock, BlockRegion> blocks = new HashMap<BasicBlock, BlockRegion>();
    protected Set<String> hoverKeys = new HashSet<String>();
    protected Map<String, String> hoverDefinitions = new HashMap<String, String>();
    protected Map<String, List<String>> hoverReferences = new HashMap<String, List<String>>();

    public abstract Text buildDocument(ControlFlowGraph var1);

    protected abstract void buildHighlighting();

    protected Text buildText(ControlFlowGraph cfg, String mimeType) {
        this.buildHovers();
        this.buildHighlighting();
        return new Text(cfg, this.text.toString(), this.foldingRegions.toArray(new FoldingRegion[this.foldingRegions.size()]), this.hyperlinks, this.stringHovers, this.regionHovers, this.highlighting, this.blocks, this.scanner, mimeType);
    }

    protected void appendBlockDetails(BasicBlock block) {
        this.text.append(this.blockDetails(block));
    }

    protected String blockDetails(BasicBlock block) {
        StringBuilder sb = new StringBuilder();
        sb.append(block.getName());
        this.hoverKeys.add(block.getName());
        this.appendBlockList(sb, " <- ", block.getPredecessors());
        this.appendBlockList(sb, " -> ", block.getSuccessors());
        this.appendBlockList(sb, " xh ", block.getXhandlers());
        if (block.getDominator() != null) {
            sb.append(" dom ").append(block.getDominator().getName());
        }
        sb.append(" [").append(block.getFromBci()).append(", ").append(block.getToBci()).append("]");
        this.appendList(sb, " ", block.getFlags());
        if (block.getLoopDepth() > 0) {
            sb.append(" (loop ").append(block.getLoopIndex()).append(" depth ").append(block.getLoopDepth()).append(")");
        }
        return sb.toString();
    }

    protected void appendBlockList(StringBuilder sb, String prefix, List<BasicBlock> blocks) {
        for (BasicBlock block : blocks) {
            sb.append(prefix);
            prefix = ",";
            sb.append(block.getName());
        }
    }

    private void appendList(StringBuilder sb, String prefix, List<String> values) {
        for (String value : values) {
            sb.append(prefix).append(value);
            prefix = ",";
        }
    }

    protected void buildHovers() {
        for (String key : this.hoverKeys) {
            StringBuilder sb = new StringBuilder();
            if (this.hoverDefinitions.containsKey(key) && this.hoverReferences.containsKey(key)) {
                sb.append("Definition;\n");
                sb.append(this.hoverDefinitions.get(key));
                sb.append("\n");
            }
            if (this.hoverReferences.containsKey(key)) {
                sb.append("References:\n");
                for (String ref : this.hoverReferences.get(key)) {
                    sb.append(ref);
                    sb.append("\n");
                }
            }
            if (sb.length() <= 0) continue;
            this.stringHovers.put(key, sb.toString().substring(0, sb.length() - 1));
        }
    }
}

