/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.dataflow.view;

import at.ssw.visualizer.core.selection.Selection;
import at.ssw.visualizer.core.selection.SelectionManager;
import at.ssw.visualizer.dataflow.graph.InstructionNodeGraphScene;
import at.ssw.visualizer.dataflow.graph.InstructionNodeWidget;
import at.ssw.visualizer.dataflow.graph.InstructionSceneListener;
import at.ssw.visualizer.dataflow.view.DataflowTableModel;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class DataflowViewTopComponent
extends TopComponent {
    private InstructionNodeGraphScene curScene;
    private JTable nodeTable;
    private DataflowTableModel tableModel;
    private MouseListener tableMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent event) {
            JPopupMenu pop;
            InstructionNodeWidget w;
            if (event.getButton() == 1 && event.getClickCount() == 2) {
                String s = DataflowViewTopComponent.this.nodeTable.getValueAt(DataflowViewTopComponent.this.nodeTable.getSelectedRow(), 1).toString();
                if (DataflowViewTopComponent.this.curScene != null) {
                    DataflowViewTopComponent.this.curScene.setSingleSelectedWidget(s, true);
                }
            } else if (event.getButton() == 3 && event.getClickCount() == 1 && (w = DataflowViewTopComponent.this.tableModel.getWidgetAtRow(DataflowViewTopComponent.this.nodeTable.rowAtPoint(event.getPoint()))) != null && (pop = w.getPopup()) != null) {
                pop.show(DataflowViewTopComponent.this.nodeTable, event.getX(), event.getY());
            }
        }
    };
    private MouseListener headerMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent event) {
            DataflowViewTopComponent.this.tableModel.sort(DataflowViewTopComponent.this.nodeTable.columnAtPoint(event.getPoint()));
        }
    };
    private ChangeListener selectionChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent event) {
            DataflowViewTopComponent.this.updateContent();
        }
    };
    private InstructionSceneListener instructionSceneListener = new InstructionSceneListener(){

        public void doubleClicked(InstructionNodeWidget w) {
            if (w == null) {
                return;
            }
            String id = w.getID();
            for (int i = 0; i < DataflowViewTopComponent.this.nodeTable.getRowCount(); ++i) {
                if (!DataflowViewTopComponent.this.nodeTable.getValueAt(i, 1).equals(id)) continue;
                DataflowViewTopComponent.this.nodeTable.changeSelection(i, 0, false, false);
                break;
            }
        }

        public void updateNodeData() {
            DataflowViewTopComponent.this.nodeTable.repaint();
        }

        public void selectionChanged(Set<InstructionNodeWidget> w) {
        }
    };
    private static final String PREFERRED_ID = "DataflowViewTopComponent";
    private static DataflowViewTopComponent instance;

    private DataflowViewTopComponent() {
        this.setName("Data Flow");
        this.setToolTipText("Data Flow");
        this.tableModel = new DataflowTableModel();
        this.nodeTable = new JTable(this.tableModel);
        this.nodeTable.setRowMargin(0);
        this.nodeTable.getColumnModel().setColumnMargin(0);
        this.nodeTable.setShowGrid(false);
        this.nodeTable.setAutoResizeMode(0);
        for (int i = 0; i < DataflowTableModel.COLUMN_WIDTHS.length; ++i) {
            this.nodeTable.getColumnModel().getColumn(i).setPreferredWidth(DataflowTableModel.COLUMN_WIDTHS[i]);
        }
        this.nodeTable.addMouseListener(this.tableMouseListener);
        this.nodeTable.getTableHeader().addMouseListener(this.headerMouseListener);
        JScrollPane scrollPane = new JScrollPane(this.nodeTable);
        scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout());
        this.add(scrollPane);
    }

    protected void componentShowing() {
        super.componentShowing();
        SelectionManager.getDefault().addChangeListener(this.selectionChangeListener);
        this.updateContent();
    }

    protected void componentHidden() {
        super.componentHidden();
        SelectionManager.getDefault().removeChangeListener(this.selectionChangeListener);
        if (this.curScene != null) {
            this.curScene.removeInstructionSceneListener(this.instructionSceneListener);
        }
        this.curScene = null;
        this.tableModel.setDataSource(null);
    }

    private void updateContent() {
        Selection selection = SelectionManager.getDefault().getCurSelection();
        InstructionNodeGraphScene newScene = (InstructionNodeGraphScene)selection.get(InstructionNodeGraphScene.class);
        if (newScene != this.curScene) {
            if (this.curScene != null) {
                this.curScene.removeInstructionSceneListener(this.instructionSceneListener);
            }
            this.tableModel.setDataSource(newScene);
            if (newScene != null) {
                newScene.addInstructionSceneListener(this.instructionSceneListener);
            }
            this.curScene = newScene;
        }
    }

    public static synchronized DataflowViewTopComponent getDefault() {
        if (instance == null) {
            instance = new DataflowViewTopComponent();
        }
        return instance;
    }

    public static synchronized DataflowViewTopComponent findInstance() {
        return (DataflowViewTopComponent)WindowManager.getDefault().findTopComponent(PREFERRED_ID);
    }

    public int getPersistenceType() {
        return 0;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return DataflowViewTopComponent.getDefault();
        }
    }
}

