/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.bc.action;

import at.ssw.visualizer.bc.BCEditor;
import at.ssw.visualizer.bc.BCEditorSupport;
import at.ssw.visualizer.bc.model.BytecodeModel;
import at.ssw.visualizer.core.focus.Focus;
import at.ssw.visualizer.model.bc.Bytecodes;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import javax.swing.JOptionPane;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.CookieAction;

public final class ShowBCEditorAction
extends CookieAction {
    protected void performAction(Node[] activatedNodes) {
        ControlFlowGraph cfg;
        BytecodeModel bcModel = (BytecodeModel)Lookup.getDefault().lookup(BytecodeModel.class);
        Bytecodes bytecodes = bcModel.getBytecodes(cfg = (ControlFlowGraph)activatedNodes[0].getLookup().lookup(ControlFlowGraph.class));
        if (bytecodes == null) {
            JOptionPane.showMessageDialog(null, bcModel.noBytecodesMsg(cfg), "No bytecodes available", 1);
            return;
        }
        if (!Focus.findEditor(BCEditor.class, (Object)bytecodes.getControlFlowGraph())) {
            BCEditorSupport editor = new BCEditorSupport(bytecodes);
            editor.open();
        }
    }

    protected int mode() {
        return 8;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (!super.enable(activatedNodes)) {
            return false;
        }
        BytecodeModel bcModel = (BytecodeModel)Lookup.getDefault().lookup(BytecodeModel.class);
        ControlFlowGraph cfg = (ControlFlowGraph)activatedNodes[0].getLookup().lookup(ControlFlowGraph.class);
        return bcModel.hasBytecodes(cfg);
    }

    public String getName() {
        return "Open Bytecodes";
    }

    protected String iconResource() {
        return "at/ssw/visualizer/bc/icons/bytecode.gif";
    }

    protected Class[] cookieClasses() {
        return new Class[]{ControlFlowGraph.class};
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }
}

