/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.ir.model;

import at.ssw.visualizer.ir.model.IRScanner;
import at.ssw.visualizer.model.Compilation;
import at.ssw.visualizer.model.cfg.BasicBlock;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import at.ssw.visualizer.model.cfg.IRInstruction;
import at.ssw.visualizer.model.cfg.State;
import at.ssw.visualizer.model.cfg.StateEntry;
import at.ssw.visualizer.texteditor.model.BlockRegion;
import at.ssw.visualizer.texteditor.model.FoldingRegion;
import at.ssw.visualizer.texteditor.model.HoverParser;
import at.ssw.visualizer.texteditor.model.Text;
import at.ssw.visualizer.texteditor.model.TextBuilder;
import at.ssw.visualizer.texteditor.model.TextRegion;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.editor.TokenID;

public class IRTextBuilder
extends TextBuilder {
    public static final FoldType KIND_BLOCK = new FoldType("...");
    public static final FoldType KIND_STATE_WITH_PHIS = new FoldType("(State)");
    public static final FoldType KIND_STATE_WITHOUT_PHIS = new FoldType("(State)");
    public static final FoldType KIND_HIR = new FoldType("(HIR)");
    public static final FoldType KIND_LIR = new FoldType("(LIR)");
    public static final FoldType KIND_MULTILINE = new FoldType("...");
    private String[] hirColumnNames;
    private int[] hirColumnStarts;
    private String[] lirColumnNames;
    private int[] lirColumnStarts;

    public IRTextBuilder() {
        this.scanner = new IRScanner();
    }

    public String buildState(ControlFlowGraph cfg, BasicBlock[] blocks) {
        this.defineColumns(cfg);
        HashSet<BasicBlock> blockSet = new HashSet<BasicBlock>(Arrays.asList(blocks));
        for (BasicBlock block : cfg.getBasicBlocks()) {
            if (!block.hasState() || !blockSet.contains(block)) continue;
            this.appendBlockDetails(block);
            this.text.append("\n");
            this.appendStates(block);
            this.text.append("\n");
        }
        if (this.text.length() == 0) {
            return "No State available\n";
        }
        return this.text.toString();
    }

    public String buildHir(ControlFlowGraph cfg, BasicBlock[] blocks) {
        this.defineColumns(cfg);
        HashSet<BasicBlock> blockSet = new HashSet<BasicBlock>(Arrays.asList(blocks));
        for (BasicBlock block : cfg.getBasicBlocks()) {
            if (!block.hasHir() || !blockSet.contains(block)) continue;
            this.appendBlockDetails(block);
            this.text.append("\n");
            this.appendHir(block);
            this.text.append("\n");
        }
        if (this.text.length() == 0) {
            return "No HIR available\n";
        }
        return this.text.toString();
    }

    public String buildLir(ControlFlowGraph cfg, BasicBlock[] blocks) {
        this.defineColumns(cfg);
        HashSet<BasicBlock> blockSet = new HashSet<BasicBlock>(Arrays.asList(blocks));
        for (BasicBlock block : cfg.getBasicBlocks()) {
            if (!block.hasLir() || !blockSet.contains(block)) continue;
            this.appendBlockDetails(block);
            this.text.append("\n");
            this.appendLir(block);
            this.text.append("\n");
        }
        if (this.text.length() == 0) {
            return "No LIR available\n";
        }
        return this.text.toString();
    }

    public Text buildDocument(ControlFlowGraph cfg) {
        Compilation compilation = cfg.getCompilation();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        this.text.append(compilation.getMethod()).append("\n");
        this.text.append(dateFormat.format(compilation.getDate())).append("\n");
        this.text.append(cfg.getName()).append("\n\n");
        this.defineColumns(cfg);
        for (BasicBlock block : cfg.getBasicBlocks()) {
            this.appendBlock(cfg, block);
        }
        return this.buildText(cfg, "text/x-compilation-ir");
    }

    protected void defineColumns(ControlFlowGraph cfg) {
        int i;
        ArrayList<String> hirColumnNames = new ArrayList<String>();
        ArrayList<Integer> hirColumnWidths = new ArrayList<Integer>();
        ArrayList<String> lirColumnNames = new ArrayList<String>();
        ArrayList<Integer> lirColumnWidths = new ArrayList<Integer>();
        for (BasicBlock block : cfg.getBasicBlocks()) {
            if (cfg.hasHir()) {
                this.defineColumns(block.getHirInstructions(), hirColumnNames, hirColumnWidths);
            }
            if (!cfg.hasLir()) continue;
            this.defineColumns(block.getLirOperations(), lirColumnNames, lirColumnWidths);
        }
        this.hirColumnNames = hirColumnNames.toArray(new String[hirColumnNames.size()]);
        this.hirColumnStarts = new int[this.hirColumnNames.length];
        int start = 1;
        for (i = 0; i < this.hirColumnStarts.length; ++i) {
            this.hirColumnStarts[i] = start;
            start += hirColumnWidths.get(i) + 2;
        }
        this.lirColumnNames = lirColumnNames.toArray(new String[lirColumnNames.size()]);
        this.lirColumnStarts = new int[this.lirColumnNames.length];
        start = 1;
        for (i = 0; i < this.lirColumnStarts.length; ++i) {
            this.lirColumnStarts[i] = start;
            start += lirColumnWidths.get(i) + 2;
        }
    }

    protected void defineColumns(List<IRInstruction> instructions, List<String> columnNames, List<Integer> columnWidths) {
        for (IRInstruction instr : instructions) {
            int prevIdx = -1;
            for (String name : instr.getNames()) {
                int idx = columnNames.indexOf(name);
                int width = Math.min(HoverParser.firstLine((String)instr.getValue(name)).length(), 15);
                if (idx == -1) {
                    width = Math.max(width, name.length());
                    columnNames.add(prevIdx + 1, name);
                    columnWidths.add(prevIdx + 1, width);
                    ++prevIdx;
                    continue;
                }
                int oldWidth = columnWidths.get(idx);
                if (width > oldWidth) {
                    columnWidths.set(idx, width);
                }
                prevIdx = idx;
            }
        }
    }

    protected void buildHighlighting() {
        HashMap<String, ArrayList<TextRegion>> highlightingLists = new HashMap<String, ArrayList<TextRegion>>();
        this.scanner.setText(this.text.toString(), 0, this.text.length());
        TokenID token = this.scanner.nextToken();
        while (token != null && token.getNumericID() != -3) {
            if (token.getNumericID() == 2 || token.getNumericID() == 3 || token.getNumericID() == 1) {
                String key = this.scanner.getTokenString();
                ArrayList<TextRegion> list = (ArrayList<TextRegion>)highlightingLists.get(key);
                if (list == null) {
                    list = new ArrayList<TextRegion>();
                    highlightingLists.put(key, list);
                }
                list.add(new TextRegion(this.scanner.getTokenOffset(), this.scanner.getOffset()));
            }
            token = this.scanner.nextToken();
        }
        for (String key : highlightingLists.keySet()) {
            List list = (List)highlightingLists.get(key);
            this.highlighting.put(key, list.toArray(new TextRegion[list.size()]));
        }
    }

    private void appendBlock(ControlFlowGraph cfg, BasicBlock block) {
        int start = this.text.length();
        ArrayList<FoldingRegion> blockFoldings = new ArrayList<FoldingRegion>();
        this.appendBlockDetails(block);
        int bodyStart = this.text.length();
        this.text.append("\n");
        if (block.hasState()) {
            blockFoldings.add(this.appendStates(block));
        }
        if (block.hasHir()) {
            blockFoldings.add(this.appendHir(block));
        }
        if (block.hasLir()) {
            blockFoldings.add(this.appendLir(block));
        }
        if (blockFoldings.size() > 0) {
            this.text.append("  \n");
            this.foldingRegions.add(new FoldingRegion(KIND_BLOCK, bodyStart, this.text.length() - 1, false));
            if (blockFoldings.size() > 1) {
                for (FoldingRegion folding : blockFoldings) {
                    this.foldingRegions.add(folding);
                }
            }
        }
        this.recordBlock(block, new TextRegion(start, start + block.getName().length()));
        this.blocks.put(block, new BlockRegion(block, start, this.text.length(), start, start + block.getName().length()));
    }

    private void appendBlockDetails(StringBuilder sb, BasicBlock block) {
        sb.append(this.blockDetails(block));
    }

    private void recordBlock(BasicBlock block, TextRegion hyperlinkTarget) {
        StringBuilder blockText = new StringBuilder();
        this.appendBlockDetails(blockText, block);
        this.recordDefinition(block.getName(), blockText.toString(), hyperlinkTarget);
    }

    private FoldingRegion appendStates(BasicBlock block) {
        boolean hasPhiOperands = false;
        int start = this.text.length();
        if (block.hasState()) {
            for (State state : block.getStates()) {
                hasPhiOperands |= this.appendState(block, state);
            }
        }
        return new FoldingRegion(hasPhiOperands ? KIND_STATE_WITH_PHIS : KIND_STATE_WITHOUT_PHIS, start, this.text.length(), !hasPhiOperands);
    }

    private boolean appendState(BasicBlock block, State state) {
        boolean hasPhiOperands = false;
        this.text.append("  ").append(state.getKind()).append(" size ").append(state.getSize());
        if (state.getMethod().length() > 0) {
            this.text.append(" [").append(state.getMethod()).append("]");
        }
        this.text.append("\n");
        for (StateEntry entry : state.getEntries()) {
            int lineStart = this.text.length();
            this.text.append("    ");
            this.append(entry.getIndex(), 5);
            this.append(entry.getName(), 5);
            if (this.appendPhiOperands(this.text, block, entry)) {
                if (entry.getOperand() != null) {
                    this.text.append(" - ").append(entry.getOperand());
                }
                hasPhiOperands = true;
                TextRegion hyperlinkTarget = new TextRegion(lineStart, this.text.length());
                this.recordPhiFunction(block, entry, hyperlinkTarget);
            }
            this.text.append("\n");
        }
        return hasPhiOperands;
    }

    private void recordPhiFunction(BasicBlock block, StateEntry entry, TextRegion hyperlinkTarget) {
        StringBuilder sb = new StringBuilder();
        sb.append(block.getName()).append(" - ").append(entry.getName());
        if (entry.getOperand() != null) {
            sb.append(" ").append(entry.getOperand());
        }
        sb.append(" : ");
        int start = sb.length();
        this.appendPhiOperands(sb, block, entry);
        String s = sb.toString();
        this.recordDefinition(entry.getName(), s, hyperlinkTarget);
        if (entry.getOperand() != null) {
            this.recordDefinition(entry.getOperand().substring(1, entry.getOperand().length() - 1), s, hyperlinkTarget);
        }
        this.recordUses(s, start, s.length() - start);
    }

    private boolean appendPhiOperands(StringBuilder sb, BasicBlock block, StateEntry entry) {
        if (entry.hasPhiOperands()) {
            sb.append("[");
            this.appendList(sb, "", entry.getPhiOperands());
            sb.append("]");
            return true;
        }
        if (block.getPredecessors().size() == 0) {
            sb.append("[method parameter]");
            return true;
        }
        return false;
    }

    private FoldingRegion appendHir(BasicBlock block) {
        int start = this.text.length();
        this.appendColumnHeader(this.hirColumnNames, this.hirColumnStarts, " (HIR)");
        for (IRInstruction instruction : block.getHirInstructions()) {
            int lineStart = this.text.length();
            this.appendColumn(instruction, this.hirColumnNames, this.hirColumnStarts);
            TextRegion hyperlinkTarget = new TextRegion(lineStart, this.text.length() - 1);
            this.recordHir(block, instruction, hyperlinkTarget);
        }
        return new FoldingRegion(KIND_HIR, start, this.text.length(), false);
    }

    protected void appendColumnHeader(String[] columnNames, int[] columnStarts, String descr) {
        int lineStart = this.text.length();
        for (int i = 0; i < columnNames.length; ++i) {
            this.fillTo(columnStarts[i], lineStart, '_');
            this.text.append(columnNames[i]);
        }
        this.fillTo(80, lineStart, '_');
        this.text.append(descr).append("\n");
    }

    protected void appendColumn(IRInstruction instruction, String[] columnNames, int[] columnStarts) {
        int lineStart = this.text.length();
        int foldStart = -1;
        for (int i = 0; i < columnNames.length; ++i) {
            this.fillTo(columnStarts[i], lineStart, ' ');
            String val = instruction.getValue(columnNames[i]);
            if (val == null) continue;
            HoverParser p = new HoverParser(val);
            while (p.hasNext()) {
                int start = this.text.length();
                this.text.append(p.next());
                if (p.getHover() != null) {
                    this.regionHovers.put(new TextRegion(start, this.text.length()), p.getHover());
                }
                if (!p.isNewLine()) continue;
                if (foldStart == -1) {
                    foldStart = this.text.length() - 1;
                }
                lineStart = this.text.length();
                this.fillTo(columnStarts[i], lineStart, ' ');
            }
        }
        if (foldStart != -1) {
            this.foldingRegions.add(new FoldingRegion(KIND_MULTILINE, foldStart, this.text.length(), false));
        }
        this.text.append("\n");
    }

    private void recordHir(BasicBlock block, IRInstruction hir, TextRegion hyperlinkTarget) {
        String irName = hir.getValue("tid");
        String irText = HoverParser.firstLine((String)hir.getValue("instruction"));
        String irOperand = hir.getValue("result");
        StringBuilder sb = new StringBuilder();
        sb.append(block.getName()).append(" - ").append(irName);
        if (irOperand != null) {
            sb.append(" ").append(irOperand);
        }
        sb.append(" : ");
        int start = sb.length();
        sb.append(irText);
        String s = sb.toString();
        this.recordDefinition(irName, s, hyperlinkTarget);
        if (irOperand != null) {
            this.recordDefinition(irOperand.substring(1, irOperand.length() - 1), s, hyperlinkTarget);
        }
        this.recordUses(s, start, s.length() - start);
    }

    private FoldingRegion appendLir(BasicBlock block) {
        int start = this.text.length();
        this.appendColumnHeader(this.lirColumnNames, this.lirColumnStarts, " (LIR)");
        for (IRInstruction instruction : block.getLirOperations()) {
            this.appendColumn(instruction, this.lirColumnNames, this.lirColumnStarts);
            this.recordLir(block, instruction);
        }
        return new FoldingRegion(KIND_LIR, start, this.text.length() - 1, false);
    }

    private void recordLir(BasicBlock block, IRInstruction lir) {
        String irNumber = lir.getValue("nr");
        String irText = HoverParser.firstLine((String)lir.getValue("instruction"));
        StringBuilder sb = new StringBuilder();
        sb.append(block.getName()).append(" - ").append(irNumber).append(" ");
        int start = sb.length();
        sb.append(irText);
        this.recordUses(sb.toString(), start, sb.length() - start);
    }

    private void fillTo(int pos, int lineStart, char ch) {
        for (int i = pos + lineStart - this.text.length(); i > 0; --i) {
            this.text.append(ch);
        }
    }

    private void append(int value, int minLen) {
        int oldLen = this.text.length();
        this.text.append(value);
        this.text.append(' ');
        for (int i = oldLen + minLen - this.text.length(); i > 0; --i) {
            this.text.append(' ');
        }
    }

    private void append(String value, int minLen) {
        int oldLen = this.text.length();
        this.text.append(value);
        this.text.append(' ');
        for (int i = oldLen + minLen - this.text.length(); i > 0; --i) {
            this.text.append(' ');
        }
    }

    private void appendList(StringBuilder sb, String prefix, List<String> values) {
        for (String value : values) {
            sb.append(prefix).append(value);
            prefix = ",";
        }
    }

    private void recordDefinition(String key, String value, TextRegion hyperlinkTarget) {
        if (this.hoverDefinitions.containsKey(key)) {
            System.out.println("WARNING: duplicate definition of '" + key + "': '" + value + "' and '" + (String)this.hoverDefinitions.get(key) + "'");
        }
        this.hoverKeys.add(key);
        this.hoverDefinitions.put(key, value);
        this.hyperlinks.put(key, hyperlinkTarget);
    }

    private void recordUse(String key, String value) {
        this.hoverKeys.add(key);
        ArrayList<String> list = (ArrayList<String>)this.hoverReferences.get(key);
        if (list == null) {
            list = new ArrayList<String>();
            this.hoverReferences.put(key, list);
        }
        if (!list.contains(value)) {
            list.add(value);
        }
    }

    private void recordUses(String value, int offset, int length) {
        this.scanner.setText(value, offset, length);
        TokenID token = this.scanner.nextToken();
        while (token != null && token.getNumericID() != -3) {
            if (token.getNumericID() == 2 || token.getNumericID() == 3 || token.getNumericID() == 1) {
                this.recordUse(this.scanner.getTokenString(), value);
            }
            token = this.scanner.nextToken();
        }
    }
}

