/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.editor;

import at.ssw.visualizer.cfg.action.ColorAction;
import at.ssw.visualizer.cfg.action.ExportAction;
import at.ssw.visualizer.cfg.action.HideEdgesAction;
import at.ssw.visualizer.cfg.action.HierarchicalCompoundLayoutAction;
import at.ssw.visualizer.cfg.action.HierarchicalNodeLayoutAction;
import at.ssw.visualizer.cfg.action.ShowAllAction;
import at.ssw.visualizer.cfg.action.ShowEdgesAction;
import at.ssw.visualizer.cfg.action.SwitchLoopClustersAction;
import at.ssw.visualizer.cfg.action.UseBezierRouterAction;
import at.ssw.visualizer.cfg.action.UseDirectLineRouterAction;
import at.ssw.visualizer.cfg.action.ZoominAction;
import at.ssw.visualizer.cfg.action.ZoomoutAction;
import at.ssw.visualizer.cfg.graph.CfgEventListener;
import at.ssw.visualizer.cfg.graph.CfgScene;
import at.ssw.visualizer.cfg.graph.EdgeWidget;
import at.ssw.visualizer.cfg.graph.NodeWidget;
import at.ssw.visualizer.cfg.model.CfgEdge;
import at.ssw.visualizer.cfg.model.CfgNode;
import at.ssw.visualizer.cfg.preferences.CfgPreferences;
import at.ssw.visualizer.cfg.preferences.FlagsSetting;
import at.ssw.visualizer.core.selection.Selection;
import at.ssw.visualizer.core.selection.SelectionManager;
import at.ssw.visualizer.core.selection.SelectionProvider;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import org.netbeans.api.visual.widget.Widget;
import org.openide.awt.Toolbar;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableTopComponent;

public class CfgEditorTopComponent
extends CloneableTopComponent
implements PropertyChangeListener,
SelectionProvider {
    private CfgScene scene;
    private JScrollPane jScrollPane;
    private ControlFlowGraph cfg;
    private JComponent myView;
    private Selection selection;

    public CfgEditorTopComponent(ControlFlowGraph cfg) {
        this.cfg = cfg;
        this.setIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/cfg/icons/cfg.gif"));
        this.setName(cfg.getParent().getShortName());
        this.setToolTipText(cfg.getCompilation().getMethod() + " - " + cfg.getName());
        this.jScrollPane = new JScrollPane();
        this.jScrollPane.setOpaque(true);
        this.jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        this.scene = new CfgScene(this);
        this.myView = this.scene.createView();
        this.jScrollPane.setViewportView(this.myView);
        this.setLayout(new BorderLayout());
        this.add((Component)this.createToolbar(), "North");
        this.add(this.jScrollPane, "Center");
        this.jScrollPane.setVerticalScrollBarPolicy(22);
        this.jScrollPane.setHorizontalScrollBarPolicy(32);
        this.jScrollPane.getVerticalScrollBar().setEnabled(true);
        this.jScrollPane.getHorizontalScrollBar().setEnabled(true);
        this.selection = new Selection();
        this.selection.put((Object)cfg);
        this.selection.put((Object)this.scene);
        this.selection.addChangeListener((ChangeListener)this.scene);
        this.scene.validate();
        this.scene.applyLayout();
    }

    public Selection getSelection() {
        return this.selection;
    }

    public ControlFlowGraph getCfg() {
        return this.cfg;
    }

    public JScrollPane getJScrollPanel() {
        return this.jScrollPane;
    }

    public CfgScene getCfgScene() {
        return this.scene;
    }

    public int getPersistenceType() {
        return 2;
    }

    protected void componentOpened() {
        super.componentOpened();
        CfgPreferences.getInstance().addPropertyChangeListener(this);
    }

    protected void componentActivated() {
        super.componentActivated();
        SelectionManager.getDefault().setSelection(this.selection);
        this.getCfgScene().updateGlobalSelection();
        this.getCfgScene().fireSelectionChanged();
    }

    protected void componentClosed() {
        super.componentClosed();
        SelectionManager.getDefault().removeSelection(this.selection);
        CfgPreferences.getInstance().removePropertyChangeListener(this);
    }

    protected CloneableTopComponent createClonedObject() {
        CfgEditorTopComponent component = new CfgEditorTopComponent(this.cfg);
        component.setActivatedNodes(this.getActivatedNodes());
        return component;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.scene != null) {
            String propName = evt.getPropertyName();
            CfgPreferences prefs = CfgPreferences.getInstance();
            if (propName.equals("backgroundColorPreference")) {
                this.scene.setBackground(prefs.getBackgroundColor());
                this.scene.revalidate();
            } else if (propName.equals("nodeColorPreference")) {
                for (NodeWidget nw : this.scene.getNodeWidgets()) {
                    if (nw.isNodeColorCustomized()) continue;
                    nw.setNodeColor(prefs.getNodeColor(), false);
                }
            } else if (propName.equals("edgeColorPreference")) {
                for (CfgEdge e : this.scene.getEdges()) {
                    if (e.isBackEdge() || e.isXhandler()) continue;
                    EdgeWidget w = (EdgeWidget)this.scene.findWidget(e);
                    w.setLineColor(prefs.getEdgeColor());
                }
            } else if (propName.equals("backEdgeColorPreference")) {
                for (CfgEdge e : this.scene.getEdges()) {
                    if (!e.isBackEdge()) continue;
                    EdgeWidget w = (EdgeWidget)this.scene.findWidget(e);
                    w.setLineColor(prefs.getBackedgeColor());
                }
            } else if (propName.equals("exceptionEdgeColorPreference")) {
                for (CfgEdge e : this.scene.getEdges()) {
                    if (!e.isXhandler()) continue;
                    EdgeWidget w = (EdgeWidget)this.scene.findWidget(e);
                    w.setLineColor(prefs.getExceptionEdgeColor());
                }
            } else if (propName.equals("borderColorPreference")) {
                for (CfgNode n : this.scene.getNodes()) {
                    NodeWidget nw = (NodeWidget)this.scene.findWidget(n);
                    nw.setBorderColor(prefs.getBorderColor());
                }
            } else if (propName.equals("textFontPreference")) {
                for (CfgNode n : this.scene.getNodes()) {
                    NodeWidget nw = (NodeWidget)this.scene.findWidget(n);
                    nw.adjustFont(prefs.getTextFont());
                }
            } else if (propName.equals("textColorPreference")) {
                for (CfgNode n : this.scene.getNodes()) {
                    NodeWidget nw = (NodeWidget)this.scene.findWidget(n);
                    nw.setForeground(prefs.getTextColor());
                }
            } else if (propName.equals("flagsPreference")) {
                FlagsSetting fs = CfgPreferences.getInstance().getFlagsSetting();
                for (CfgNode n : this.scene.getNodes()) {
                    NodeWidget nw = (NodeWidget)this.scene.findWidget(n);
                    Color nodeColor = fs.getColor(n.getBasicBlock().getFlags());
                    if (nodeColor != null) {
                        nw.setNodeColor(nodeColor, true);
                        continue;
                    }
                    nw.setNodeColor(CfgPreferences.getInstance().getNodeColor(), false);
                }
            } else if (propName.equals("selectionColorBgPreference") || propName.equals("selectionColorFgPreference")) {
                for (CfgNode n : this.scene.getNodes()) {
                    Widget w = this.scene.findWidget(n);
                    w.revalidate();
                }
            }
            this.scene.validate();
        }
    }

    private Toolbar createToolbar() {
        Toolbar tb = new Toolbar("CfgToolbar");
        tb.setBorder((Border)UIManager.get("Nb.Editor.Toolbar.border"));
        tb.add((Component)((ZoominAction)SystemAction.get(ZoominAction.class)).getToolbarPresenter());
        tb.add((Component)((ZoomoutAction)SystemAction.get(ZoomoutAction.class)).getToolbarPresenter());
        tb.addSeparator();
        ButtonGroup routerButtons = new ButtonGroup();
        UseDirectLineRouterAction direct = (UseDirectLineRouterAction)SystemAction.get(UseDirectLineRouterAction.class);
        UseBezierRouterAction bezier = (UseBezierRouterAction)SystemAction.get(UseBezierRouterAction.class);
        JToggleButton button = (JToggleButton)direct.getToolbarPresenter();
        button.getModel().setGroup(routerButtons);
        button.setSelected(true);
        tb.add((Component)button);
        button = (JToggleButton)bezier.getToolbarPresenter();
        button.getModel().setGroup(routerButtons);
        tb.add((Component)button);
        tb.addSeparator();
        tb.add((Component)((HierarchicalNodeLayoutAction)SystemAction.get(HierarchicalNodeLayoutAction.class)).getToolbarPresenter());
        tb.add((Component)((HierarchicalCompoundLayoutAction)SystemAction.get(HierarchicalCompoundLayoutAction.class)).getToolbarPresenter());
        tb.addSeparator();
        tb.add((Component)((ShowAllAction)SystemAction.get(ShowAllAction.class)).getToolbarPresenter());
        tb.addSeparator();
        tb.add((Component)((SwitchLoopClustersAction)SystemAction.get(SwitchLoopClustersAction.class)).getToolbarPresenter());
        tb.addSeparator();
        tb.add((Component)((ShowEdgesAction)SystemAction.get(ShowEdgesAction.class)).getToolbarPresenter());
        tb.add((Component)((HideEdgesAction)SystemAction.get(HideEdgesAction.class)).getToolbarPresenter());
        tb.addSeparator();
        JComponent colorButton = ((ColorAction)SystemAction.get(ColorAction.class)).getToolbarPresenter();
        this.getCfgScene().addCfgEventListener((CfgEventListener)((Object)colorButton));
        tb.add((Component)colorButton);
        tb.add((Component)((ExportAction)SystemAction.get(ExportAction.class)).getToolbarPresenter());
        tb.doLayout();
        return tb;
    }
}

