/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.graph;

import at.ssw.visualizer.cfg.graph.CfgScene;
import at.ssw.visualizer.cfg.graph.NodeWidget;
import at.ssw.visualizer.cfg.model.LoopInfo;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.EditProvider;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class LoopClusterWidget
extends Widget
implements Comparable<LoopClusterWidget> {
    private static final int INSET = 10;
    private static final int DASHSIZE = 10;
    private Color color = Color.BLUE;
    private int loopIndex;
    private int loopDepth;
    private CfgScene cfgscene;
    private ArrayList<NodeWidget> members = new ArrayList();

    public LoopClusterWidget(CfgScene scene, int loopdepth, final int loopindex) {
        super((Scene)scene);
        this.cfgscene = scene;
        this.loopIndex = loopindex;
        this.loopDepth = loopdepth;
        this.setBorder(BorderFactory.createDashedBorder((Color)this.color, (int)10, (int)5, (boolean)true));
        this.getActions().addAction(ActionFactory.createEditAction((EditProvider)new EditProvider(){

            public void edit(Widget w) {
                if (w instanceof LoopClusterWidget) {
                    for (LoopInfo info : LoopClusterWidget.this.cfgscene.getCfgEnv().getLoopMap().values()) {
                        if (info.getLoopIndex() != loopindex) continue;
                        LoopClusterWidget.this.cfgscene.setNodeSelection(info.getMembers());
                        break;
                    }
                }
            }
        }));
    }

    public List<NodeWidget> getMembers() {
        return this.members;
    }

    public int getLoopIndex() {
        return this.loopIndex;
    }

    public void addMember(NodeWidget nw) {
        assert (!this.members.contains((Object)nw));
        this.members.add(nw);
    }

    public boolean removeMember(NodeWidget nw) {
        if (this.members.contains((Object)nw)) {
            this.members.remove((Object)nw);
            return true;
        }
        return false;
    }

    public void setrandomColor() {
        if (this.loopDepth == 0) {
            return;
        }
        Random rand = new Random();
        Color randColor = Color.getHSBColor(rand.nextFloat() % 360.0f, 0.1f, 1.0f);
        this.setBackground(randColor);
    }

    public void updateClusterBounds() {
        Rectangle boundRect = null;
        for (NodeWidget nw : this.members) {
            if (boundRect == null) {
                boundRect = nw.convertLocalToScene(nw.getBounds());
                continue;
            }
            boundRect = boundRect.union(nw.convertLocalToScene(nw.getBounds()));
        }
        if (boundRect == null) {
            return;
        }
        for (Widget w : this.getChildren()) {
            if (!(w instanceof LoopClusterWidget)) continue;
            LoopClusterWidget lc = (LoopClusterWidget)w;
            lc.updateClusterBounds();
            boundRect = boundRect.union(w.convertLocalToScene(w.getBounds()));
        }
        boundRect.grow(10, 10);
        this.setPreferredBounds(boundRect);
    }

    @Override
    public int compareTo(LoopClusterWidget o) {
        return new Integer(this.loopDepth).compareTo(o.loopDepth);
    }

    public String toString() {
        return "LoopCluster: [DEPTH " + this.loopDepth + "] [INDEX " + this.loopIndex + "]";
    }
}

