/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.graph;

import at.ssw.visualizer.cfg.graph.CfgScene;
import at.ssw.visualizer.cfg.model.CfgNode;
import at.ssw.visualizer.cfg.preferences.CfgPreferences;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class NodeWidget
extends Widget {
    private final int halfheight = 12;
    private final int halfwidth = 17;
    private final int height = 25;
    private final int width = 35;
    private final int arcHeight = 9;
    private final int arcWidth = 9;
    private final int FONT_MAXSIZE = 18;
    private int borderWidth;
    private boolean selected = false;
    private boolean nodeColorCustomized;
    private String text;
    private Rectangle2D fontRect;
    private Color nodeColor;
    protected static final Color HOVER_BACKGROUND = new Color(0xEEEEEE);
    protected static final Color HOVER_FOREGROUND = new Color(0xCDCDCD);

    public NodeWidget(CfgScene scene, CfgNode nodeModel) {
        super((Scene)scene);
        this.setToolTipText("<html>" + nodeModel.getDescription().replaceAll("\n", "<br>") + "</html>");
        this.selected = false;
        this.text = nodeModel.getBasicBlock().getName();
        this.borderWidth = nodeModel.getLoopDepth() + 1;
        this.setBorder(BorderFactory.createRoundedBorder((int)(9 + this.borderWidth), (int)(9 + this.borderWidth), (int)this.borderWidth, (int)this.borderWidth, (Color)Color.BLACK, (Color)Color.BLACK));
        CfgPreferences prefs = CfgPreferences.getInstance();
        Color color = prefs.getFlagsSetting().getColor(nodeModel.getBasicBlock().getFlags());
        this.nodeColorCustomized = color != null;
        this.nodeColor = this.nodeColorCustomized ? color : prefs.getNodeColor();
        this.adjustFont(null);
    }

    public void setBorderColor(Color color) {
        this.setBorder(BorderFactory.createRoundedBorder((int)(9 + this.borderWidth), (int)(9 + this.borderWidth), (int)this.borderWidth, (int)this.borderWidth, (Color)color, (Color)color));
    }

    public boolean isNodeColorCustomized() {
        return this.nodeColorCustomized;
    }

    public void setNodeColor(Color color, boolean customColor) {
        this.nodeColorCustomized = customColor;
        this.nodeColor = color;
        this.revalidate();
    }

    public Color getNodeColor() {
        return this.nodeColor;
    }

    public CfgNode getNodeModel() {
        CfgScene scene = (CfgScene)this.getScene();
        return (CfgNode)scene.findObject(this);
    }

    public void notifyStateChanged(ObjectState oldState, ObjectState newState) {
        if (!oldState.equals(newState)) {
            this.revalidate();
        }
        if (!oldState.isSelected() && newState.isSelected()) {
            this.bringToFront();
        }
    }

    protected Rectangle calculateClientArea() {
        return new Rectangle(-18, -13, 36, 26);
    }

    public void adjustFont(Font font) {
        if (font == null) {
            font = CfgPreferences.getInstance().getTextFont();
        }
        if (font.getSize() > 18) {
            font = new Font(font.getFamily(), font.getStyle(), 18);
        }
        int size = font.getSize();
        int fontStyle = font.getStyle();
        String fontName = font.getFamily();
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
        Rectangle2D bounds = font.getStringBounds(this.text, frc);
        while (size > 1 && bounds.getWidth() > 35.0) {
            font = new Font(fontName, fontStyle, --size);
            bounds = font.getStringBounds(this.text, frc);
        }
        this.fontRect = bounds;
        this.setFont(font);
    }

    protected void paintWidget() {
        Composite composite;
        Graphics2D gr = this.getGraphics();
        gr.setColor(this.nodeColor);
        Insets borderInsets = this.getBorder().getInsets();
        RoundRectangle2D.Float innerRect = new RoundRectangle2D.Float(-18.0f, -13.0f, 36.0f, 26.0f, 8.0f, 8.0f);
        gr.fill(innerRect);
        gr.setColor(this.getForeground());
        gr.setFont(this.getFont());
        float textX = (float)(-this.fontRect.getCenterX());
        float textY = (float)(-this.fontRect.getCenterY());
        gr.drawString(this.text, textX, textY);
        RoundRectangle2D.Float outerRect = new RoundRectangle2D.Float(-(17 + borderInsets.left + 1), -(12 + borderInsets.top + 1), 35 + borderInsets.left + borderInsets.right + 1, 25 + borderInsets.top + borderInsets.bottom + 1, 9 + this.borderWidth, 9 + this.borderWidth);
        ObjectState os = this.getState();
        if (os.isSelected()) {
            composite = gr.getComposite();
            gr.setComposite(AlphaComposite.getInstance(10, 0.5f));
            gr.setColor(CfgPreferences.getInstance().getSelectionColorForeground());
            gr.fill(outerRect);
            gr.setColor(CfgPreferences.getInstance().getSelectionColorBackground());
            gr.setComposite(composite);
        }
        if (os.isHovered()) {
            composite = gr.getComposite();
            gr.setComposite(AlphaComposite.getInstance(10, 0.5f));
            gr.setColor(HOVER_FOREGROUND);
            gr.fill(outerRect);
            gr.setColor(HOVER_BACKGROUND);
            gr.setComposite(composite);
        }
    }

    public String toString() {
        return "NodeWidget[" + this.getNodeModel().getBasicBlock().getName() + "]";
    }
}

