/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.graph.layout;

import at.ssw.visualizer.cfg.graph.CfgScene;
import at.ssw.visualizer.cfg.model.CfgEdge;
import at.ssw.visualizer.cfg.model.CfgNode;
import at.ssw.visualizer.cfg.model.LoopInfo;
import java.awt.Point;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.CompoundDirectedGraphLayout;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.widget.Widget;

public class HierarchicalCompoundLayout
extends GraphLayout<CfgNode, CfgEdge> {
    private static final int TOP_BORDER = 20;
    private static final int LEFT_BORDER = 20;
    private int PADDING = 20;
    private static final int INSET = 20;
    private CfgScene scene;

    public HierarchicalCompoundLayout(CfgScene scene) {
        this.scene = scene;
    }

    protected void performGraphLayout(UniversalGraph<CfgNode, CfgEdge> ug) {
        Edge edge;
        CompoundDirectedGraph dg = new CompoundDirectedGraph();
        CompoundDirectedGraphLayout layout = new CompoundDirectedGraphLayout();
        NodeList nodeList = dg.nodes;
        EdgeList edgeList = dg.edges;
        HashMap<Integer, Subgraph> idx2graph = new HashMap<Integer, Subgraph>();
        Subgraph base = new Subgraph((Object)0);
        idx2graph.put(0, base);
        base.insets = this.getInsets();
        for (LoopInfo info : this.scene.getCfgEnv().getLoopMap().values()) {
            Subgraph subg = new Subgraph((Object)info.getLoopIndex());
            subg.insets = this.getInsets();
            idx2graph.put(info.getLoopIndex(), subg);
        }
        for (CfgNode n : this.scene.getCfgEnv().getNodes()) {
            Widget nodeWidget = this.scene.findWidget(n);
            Node node = new Node((Object)n);
            node.width = nodeWidget.getBounds().width;
            node.height = nodeWidget.getBounds().height;
            node.setPadding(new Insets(this.PADDING, this.PADDING, this.PADDING, this.PADDING));
            Subgraph subg = (Subgraph)idx2graph.get(n.getLoopIndex());
            assert (subg != null);
            node.setParent(subg);
            subg.addMember(node);
            nodeList.add((Object)node);
        }
        nodeList.addAll(idx2graph.values());
        for (LoopInfo info : this.scene.getCfgEnv().getLoopMap().values()) {
            Subgraph subg = (Subgraph)idx2graph.get(info.getLoopIndex());
            if (info.getParent() == null) continue;
            Subgraph parentsubg = (Subgraph)idx2graph.get(info.getParent().getLoopIndex());
            edge = new Edge((Node)parentsubg, (Node)subg);
            parentsubg.addMember((Node)subg);
            subg.setParent(parentsubg);
            edgeList.add((Object)edge);
        }
        for (CfgEdge e : this.scene.getCfgEnv().getEdges()) {
            if (e.isBackEdge()) continue;
            edge = new Edge((Object)e, nodeList.getNode(e.getSourceNode().getNodeIndex()), nodeList.getNode(e.getTargetNode().getNodeIndex()));
            edgeList.add((Object)edge);
        }
        layout.visit((DirectedGraph)dg);
        for (Object obj : dg.nodes) {
            Node n = (Node)obj;
            if (!(n.data instanceof CfgNode)) continue;
            CfgNode cfgNode = (CfgNode)n.data;
            Point pos = new Point(n.x + 20, n.y + 20);
            Point scenepos = this.scene.convertLocalToScene(pos);
            this.setResolvedNodeLocation(ug, cfgNode, scenepos);
        }
    }

    protected void performNodesLayout(UniversalGraph<CfgNode, CfgEdge> ug, Collection<CfgNode> collection) {
    }

    private Insets getInsets() {
        return new Insets(20, 20, 20, 20);
    }
}

