/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.model;

import at.ssw.visualizer.cfg.model.CfgEdge;
import at.ssw.visualizer.cfg.model.CfgEdgeImpl;
import at.ssw.visualizer.cfg.model.CfgNode;
import at.ssw.visualizer.model.cfg.BasicBlock;
import java.awt.Color;

public class CfgNodeImpl
implements CfgNode {
    private int nodeIndex;
    private BasicBlock basicBlock;
    private int level;
    private int loopDepth = 0;
    private int loopIndex = 0;
    private boolean osr = false;
    private CfgNodeImpl dominator = null;
    private CfgEdgeImpl[] inputEdges = new CfgEdgeImpl[0];
    private CfgEdgeImpl[] outputEdges = new CfgEdgeImpl[0];
    private String description;
    private Color customColor = null;
    private boolean loopHeader;

    public CfgNodeImpl(BasicBlock bb, int nodeIndex, String description) {
        this.basicBlock = bb;
        this.nodeIndex = nodeIndex;
        this.description = description;
        if (bb.getPredecessors().size() == 1) {
            boolean isStd;
            BasicBlock pred = (BasicBlock)bb.getPredecessors().get(0);
            boolean bl = isStd = pred.getPredecessors().size() == 0;
            if (isStd) {
                for (String s : bb.getFlags()) {
                    if (!s.equals("osr")) continue;
                    this.osr = true;
                    break;
                }
            }
        }
    }

    @Override
    public int getNodeIndex() {
        return this.nodeIndex;
    }

    public void setDominator(CfgNodeImpl dominator) {
        this.dominator = dominator;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setLoopDepth(int loopDepth) {
        this.loopDepth = loopDepth;
    }

    public void setLoopHeader(boolean loopHeader) {
        this.loopHeader = loopHeader;
    }

    public void setLoopIndex(int loopIndex) {
        this.loopIndex = loopIndex;
    }

    public void setNodeIndex(int nodeIndex) {
        this.nodeIndex = nodeIndex;
    }

    @Override
    public boolean isRoot() {
        return this.nodeIndex == 0;
    }

    @Override
    public boolean isLoopHeader() {
        return this.loopHeader;
    }

    @Override
    public boolean isLoopMember() {
        return this.loopIndex > 0;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public BasicBlock getBasicBlock() {
        return this.basicBlock;
    }

    @Override
    public int getLoopDepth() {
        return this.loopDepth;
    }

    @Override
    public int getLoopIndex() {
        return this.loopIndex;
    }

    @Override
    public boolean isOSR() {
        return this.osr;
    }

    public String toString() {
        return this.basicBlock.getName();
    }

    public void setInputEdges(CfgEdgeImpl[] inputEdges) {
        this.inputEdges = inputEdges;
    }

    public void setOutputEdges(CfgEdgeImpl[] outputEdges) {
        this.outputEdges = outputEdges;
    }

    @Override
    public CfgEdge[] getInputEdges() {
        return this.inputEdges;
    }

    @Override
    public CfgEdge[] getOutputEdges() {
        return this.outputEdges;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setColor(Color color) {
        this.customColor = color;
    }
}

