/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.visual;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.List;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class BezierWidget
extends ConnectionWidget {
    private static final double BEZIER_SCALE = 0.3;
    private static final double ENDPOINT_DEVIATION = 3.0;
    private GraphScene scene = null;

    public BezierWidget(Scene scene) {
        super(scene);
    }

    public BezierWidget(GraphScene scene) {
        super((Scene)scene);
        this.scene = scene;
    }

    private boolean isReflexive() {
        return this.getSourceAnchor().getRelatedWidget() == this.getTargetAnchor().getRelatedWidget();
    }

    protected Rectangle calculateClientArea() {
        Rectangle bounds = null;
        if (this.getControlPoints().size() > 0) {
            for (Point p : this.getControlPoints()) {
                if (bounds == null) {
                    bounds = new Rectangle(p);
                    continue;
                }
                bounds.add(p);
            }
            bounds.grow(5, 5);
        }
        if (this.isReflexive()) {
            Widget related = this.getTargetAnchor().getRelatedWidget();
            bounds = related.convertLocalToScene(related.getBounds());
            bounds.grow(10, 10);
        }
        if (bounds == null) {
            bounds = super.calculateClientArea();
        }
        return bounds;
    }

    private int edgeBalance(Widget nodeWidget) {
        if (this.scene == null) {
            return 1;
        }
        Point nodeLocation = nodeWidget.getLocation();
        int left = 0;
        int right = 0;
        Object node = this.scene.findObject(nodeWidget);
        for (Object e : this.scene.findNodeEdges(node, true, true)) {
            Point location;
            ConnectionWidget cw = (ConnectionWidget)this.scene.findWidget(e);
            if (cw == this) continue;
            Widget targetNodeWidget = cw.getTargetAnchor().getRelatedWidget();
            if (targetNodeWidget == nodeWidget) {
                Widget sourceNodeWidget = cw.getSourceAnchor().getRelatedWidget();
                location = sourceNodeWidget.getLocation();
            } else {
                location = targetNodeWidget.getLocation();
            }
            if (location.x < nodeLocation.x) {
                ++left;
                continue;
            }
            ++right;
        }
        if (left < right) {
            return -1;
        }
        return 1;
    }

    protected void paintWidget() {
        List contrPoints = this.getControlPoints();
        int listSize = contrPoints.size();
        Graphics2D gr = this.getGraphics();
        if (listSize <= 2) {
            if (this.isReflexive()) {
                Widget related = this.getTargetAnchor().getRelatedWidget();
                int position = this.edgeBalance(related);
                Rectangle bounds = related.convertLocalToScene(related.getBounds());
                gr.setColor(this.getLineColor());
                Point first = new Point();
                Point last = new Point();
                double centerX = bounds.getCenterX();
                first.x = (int)(centerX + (double)(bounds.width / 4));
                first.y = bounds.y + bounds.height;
                last.x = first.x;
                last.y = bounds.y;
                gr.setStroke(this.getStroke());
                double cutDistance = this.getTargetAnchorShape().getCutDistance();
                double anchorAngle = -1.0471975511965976;
                double cutX = Math.abs(Math.cos(anchorAngle) * cutDistance);
                double cutY = Math.abs(Math.sin(anchorAngle) * cutDistance);
                int ydiff = first.y - last.y;
                int endy = -ydiff;
                double height = bounds.getHeight();
                double cy = height / 4.0;
                double cx = bounds.getWidth() / 5.0;
                double dcx = cx * 2.0;
                GeneralPath gp = new GeneralPath();
                gp.moveTo(0.0f, 0.0f);
                gp.quadTo(0.0, cy, cx, cy);
                gp.quadTo(dcx, cy, dcx, -height / 2.0);
                gp.quadTo(dcx, (double)endy - cy, cy, -(cy + (double)ydiff));
                gp.quadTo(cutX * 1.5, (double)endy - cy, cutX, (double)endy - cutY);
                AffineTransform af = new AffineTransform();
                AnchorShape anchorShape = this.getTargetAnchorShape();
                if (position < 0) {
                    first.x = (int)(centerX - (double)(bounds.width / 4));
                    af.translate(first.x, first.y);
                    af.scale(-1.0, 1.0);
                    last.x = first.x;
                } else {
                    af.translate(first.x, first.y);
                }
                Shape s = gp.createTransformedShape(af);
                gr.draw(s);
                if (last != null) {
                    AffineTransform previousTransform = gr.getTransform();
                    gr.translate(last.x, last.y);
                    if (position < 0) {
                        gr.rotate(Math.PI - anchorAngle);
                    } else {
                        gr.rotate(anchorAngle);
                    }
                    anchorShape.paint(gr, false);
                    gr.setTransform(previousTransform);
                }
            } else {
                super.paintWidget();
            }
            return;
        }
        GeneralPath curvePath = new GeneralPath();
        Point lastControlPoint = null;
        double lastControlPointRotation = 0.0;
        Point prev = null;
        for (int i = 0; i < listSize - 1; ++i) {
            Point cur = (Point)contrPoints.get(i);
            Point next = (Point)contrPoints.get(i + 1);
            Point nextnext = null;
            if (i < listSize - 2) {
                nextnext = (Point)contrPoints.get(i + 2);
            }
            double len = cur.distance(next);
            double scale = len * 0.3;
            Point bezierFrom = null;
            Point bezierTo = null;
            if (prev == null) {
                curvePath.moveTo(cur.x, cur.y);
                bezierFrom = cur;
            } else {
                bezierFrom = new Point(next.x - prev.x, next.y - prev.y);
                bezierFrom = BezierWidget.scaleVector(bezierFrom, scale);
                bezierFrom.translate(cur.x, cur.y);
            }
            if (nextnext == null) {
                lastControlPoint = next;
                bezierTo = next;
                GeneralPath lastseg = this.subdivide(cur, bezierFrom, bezierTo, next);
                if (lastseg == null) break;
                curvePath.append(lastseg, true);
                break;
            }
            bezierTo = new Point(cur.x - nextnext.x, cur.y - nextnext.y);
            bezierTo = BezierWidget.scaleVector(bezierTo, scale);
            bezierTo.translate(next.x, next.y);
            curvePath.curveTo(bezierFrom.x, bezierFrom.y, bezierTo.x, bezierTo.y, next.x, next.y);
            prev = cur;
        }
        Point2D cur = curvePath.getCurrentPoint();
        Point next = lastControlPoint;
        lastControlPointRotation = Math.atan2(cur.getY() - (double)next.y, cur.getX() - (double)next.x);
        Color previousColor = gr.getColor();
        gr.setColor(this.getLineColor());
        Stroke s = this.getStroke();
        gr.setStroke(s);
        gr.setColor(this.getLineColor());
        gr.draw(curvePath);
        AffineTransform previousTransform = gr.getTransform();
        gr.translate(lastControlPoint.x, lastControlPoint.y);
        gr.rotate(lastControlPointRotation);
        AnchorShape targetAnchorShape = this.getTargetAnchorShape();
        targetAnchorShape.paint(gr, false);
        gr.setTransform(previousTransform);
        if (this.isPaintControlPoints()) {
            int last = listSize - 1;
            for (int index = 0; index <= last; ++index) {
                Point point = (Point)contrPoints.get(index);
                previousTransform = gr.getTransform();
                gr.translate(point.x, point.y);
                if (index == 0 || index == last) {
                    this.getEndPointShape().paint(gr);
                } else {
                    this.getControlPointShape().paint(gr);
                }
                gr.setTransform(previousTransform);
            }
        }
        gr.setColor(previousColor);
    }

    private GeneralPath subdivide(Point b0, Point b1, Point b2, Point b3) {
        double minDistance;
        double cutDistance = this.getTargetAnchorShape().getCutDistance();
        if (cutDistance > (minDistance = cutDistance - 3.0) && minDistance > 0.0) {
            GeneralPath path = new GeneralPath();
            path.moveTo(b0.x, b0.y);
            CubicCurve2D.Double left = new CubicCurve2D.Double(b0.x, b0.y, b1.x, b1.y, b2.x, b2.y, b3.x, b3.y);
            CubicCurve2D.Double right = new CubicCurve2D.Double();
            left.subdivide(left, right);
            double distance = b3.distance(left.getP2());
            while (distance > cutDistance) {
                path.append(left, true);
                right.subdivide(left, right);
                distance = b3.distance(left.getP2());
                while (distance < minDistance) {
                    left.subdivide(left, right);
                    distance = b3.distance(left.getP2());
                }
            }
            path.append(left, true);
            return path;
        }
        return null;
    }

    private static Point scaleVector(Point vector, double len) {
        double scale = Math.sqrt(vector.x * vector.x + vector.y * vector.y);
        if (scale == 0.0) {
            return vector;
        }
        scale = len / scale;
        return new Point(Math.round((float)vector.x * (float)scale), Math.round((float)vector.y * (float)scale));
    }
}

