/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.visual;

import at.ssw.visualizer.cfg.visual.WidgetCollisionCollector;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;

public class PolylineRouter
implements Router {
    private static final float FACTOR = 0.7f;
    private static final int HEXPAND = 3;
    private static final int VEXPAND = 3;
    private static final int NUMBER_OF_ITERATIONS = 8;
    WidgetCollisionCollector collector;

    public PolylineRouter(WidgetCollisionCollector collector) {
        this.collector = collector;
    }

    public List<Point> routeConnection(ConnectionWidget widget) {
        List<Point> controlPoints;
        Widget targetWidget;
        if (!widget.isVisible()) {
            return Collections.emptyList();
        }
        Anchor sourceAnchor = widget.getSourceAnchor();
        Anchor targetAnchor = widget.getTargetAnchor();
        if (sourceAnchor == null || targetAnchor == null) {
            return null;
        }
        Point start = sourceAnchor.compute(widget.getSourceAnchorEntry()).getAnchorSceneLocation();
        Point end = targetAnchor.compute(widget.getTargetAnchorEntry()).getAnchorSceneLocation();
        Widget sourceWidget = sourceAnchor.getRelatedWidget();
        if (sourceWidget == (targetWidget = targetAnchor.getRelatedWidget())) {
            return Collections.emptyList();
        }
        ArrayList<Widget> nodeWidgets = new ArrayList<Widget>();
        if (this.collector != null) {
            this.collector.collectCollisions(nodeWidgets);
            nodeWidgets.remove(sourceWidget);
            nodeWidgets.remove(targetWidget);
        }
        if ((controlPoints = this.optimize(nodeWidgets, widget, start, end)).size() > 3) {
            controlPoints = this.simplify(nodeWidgets, controlPoints);
        }
        return controlPoints;
    }

    private List<Point> simplify(Collection<Widget> nodeWidgets, List<Point> list) {
        ArrayList<Point> result = new ArrayList<Point>();
        result.add(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            Point prev = list.get(i - 1);
            for (int j = i; j < list.size(); ++j) {
                Point cur = list.get(j);
                if (this.intersects(nodeWidgets, prev, cur)) continue;
                i = j;
            }
            result.add(list.get(i));
        }
        return result;
    }

    private Point computateAnchorPosition(Widget relatedWidget, Point controlPoint) {
        Rectangle bounds = relatedWidget.getBounds();
        Point relatedLocation = relatedWidget.getLocation();
        if (bounds.isEmpty() || relatedLocation.equals(controlPoint)) {
            return relatedLocation;
        }
        float dx = controlPoint.x - relatedLocation.x;
        float dy = controlPoint.y - relatedLocation.y;
        float ddx = Math.abs(dx) / (float)bounds.width;
        float ddy = Math.abs(dy) / (float)bounds.height;
        float scale = 0.5f / Math.max(ddx, ddy);
        Point point = new Point(Math.round((float)relatedLocation.x + scale * dx), Math.round((float)relatedLocation.y + scale * dy));
        return point;
    }

    private List<Point> optimize(Collection<Widget> nodeWidgets, ConnectionWidget connWidget, Point start, Point end) {
        ArrayList<Point> list = new ArrayList<Point>();
        list.add(start);
        list.add(end);
        boolean progress = true;
        for (int j = 0; progress && j < 8; ++j) {
            progress = false;
            ArrayList<Point> newList = new ArrayList<Point>();
            for (int i = 0; i < list.size() - 1; ++i) {
                Point cur = (Point)list.get(i);
                Point next = (Point)list.get(i + 1);
                newList.add(cur);
                List<Point> intermediate = this.optimizeLine(nodeWidgets, cur, next);
                if (intermediate == null || intermediate.size() <= 0) continue;
                progress = true;
                newList.addAll(intermediate);
            }
            newList.add((Point)list.get(list.size() - 1));
            list = newList;
        }
        if (list.size() > 2) {
            Widget sourceNode = connWidget.getSourceAnchor().getRelatedWidget();
            Widget targetNode = connWidget.getTargetAnchor().getRelatedWidget();
            Rectangle sourceBounds = sourceNode.convertLocalToScene(sourceNode.getBounds());
            Rectangle targetBounds = targetNode.convertLocalToScene(targetNode.getBounds());
            sourceBounds.grow(3, 3);
            ArrayList<Point> tmp = new ArrayList<Point>();
            int listSize = list.size();
            tmp.add((Point)list.get(0));
            int i = 0;
            while (++i < listSize - 1) {
                Point p = (Point)list.get(i);
                if (sourceBounds.contains(p) && targetBounds.contains(p)) continue;
                tmp.add(p);
            }
            tmp.add((Point)list.get(i));
            if (tmp.size() < 3) {
                return tmp;
            }
            list = tmp;
            start = this.computateAnchorPosition(connWidget.getSourceAnchor().getRelatedWidget(), (Point)list.get(1));
            end = this.computateAnchorPosition(connWidget.getTargetAnchor().getRelatedWidget(), (Point)list.get(list.size() - 2));
            list.set(0, start);
            list.set(list.size() - 1, end);
        }
        return list;
    }

    private List<Point> optimizeLine(Collection<Widget> nodeWidgets, Point p1, Point p2) {
        Line2D.Double line = new Line2D.Double(p1, p2);
        for (Widget w : nodeWidgets) {
            if (!w.isVisible()) continue;
            Rectangle r = w.convertLocalToScene(w.getBounds());
            r.grow(3, 3);
            if (!line.intersects(r)) continue;
            Point location = w.getLocation();
            int distx = (int)((float)r.width * 0.7f);
            int disty = (int)((float)r.height * 0.7f);
            int minIntersects = Integer.MAX_VALUE;
            int min = Integer.MAX_VALUE;
            ArrayList<Point> minSol = null;
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    Line2D.Float line3;
                    Line2D.Float line2;
                    Line2D.Float line1;
                    int curIntersects;
                    Point cur2;
                    Point cur1;
                    Line2D.Float line22;
                    Line2D.Float line12;
                    int curIntersects2;
                    if (i == 0 && j == 0) continue;
                    Point cur = new Point(location.x + i * distx, location.y + j * disty);
                    ArrayList<Point> list1 = new ArrayList<Point>();
                    list1.add(p1);
                    list1.add(cur);
                    list1.add(p2);
                    int crossProd = Math.abs(this.crossProduct(p1, cur, p2));
                    if (!this.intersects(w, list1) && ((curIntersects2 = this.countNodeIntersections(nodeWidgets, line12 = new Line2D.Float(p1, cur), line22 = new Line2D.Float(p2, cur))) < minIntersects || curIntersects2 == minIntersects && crossProd < min)) {
                        minIntersects = curIntersects2;
                        min = crossProd;
                        minSol = new ArrayList<Point>();
                        minSol.add(cur);
                    }
                    if (i != 0 && j != 0) continue;
                    if (i == 0) {
                        cur1 = new Point(location.x + distx / 2, location.y + j * disty);
                        cur2 = new Point(location.x - distx / 2, location.y + j * disty);
                    } else {
                        cur1 = new Point(location.x + i * distx, location.y + disty / 2);
                        cur2 = new Point(location.x + i * distx, location.y - disty / 2);
                    }
                    Point vec1 = new Point(p1.x - cur1.x, p1.y - cur1.y);
                    int offset1 = vec1.x * vec1.x + vec1.y * vec1.y;
                    Point vec2 = new Point(p1.x - cur2.x, p1.y - cur2.y);
                    int offset2 = vec2.x * vec2.x + vec2.y * vec2.y;
                    if (offset2 < offset1) {
                        Point tmp = cur1;
                        cur1 = cur2;
                        cur2 = tmp;
                    }
                    ArrayList<Point> list2 = new ArrayList<Point>();
                    list2.add(p1);
                    list2.add(cur1);
                    list2.add(cur2);
                    list2.add(p2);
                    int cross1 = this.crossProduct(p1, cur1, cur2);
                    int cross2 = this.crossProduct(cur1, cur2, p2);
                    if (cross1 > 0) {
                        cross1 = 1;
                    } else if (cross1 < 0) {
                        cross1 = -1;
                    }
                    if (cross2 > 0) {
                        cross2 = 1;
                    } else if (cross2 < 0) {
                        cross2 = -1;
                    }
                    if (cross1 != cross2 && cross1 != 0 && cross2 != 0 || this.intersects(w, list2) || (curIntersects = this.countNodeIntersections(nodeWidgets, line1 = new Line2D.Float(p1, cur1), line2 = new Line2D.Float(cur1, cur2), line3 = new Line2D.Float(p2, cur2))) >= minIntersects && (curIntersects != minIntersects || --crossProd >= min)) continue;
                    minIntersects = curIntersects;
                    min = crossProd;
                    minSol = new ArrayList();
                    minSol.add(cur1);
                    minSol.add(cur2);
                }
            }
            if (minSol == null) continue;
            return minSol;
        }
        return null;
    }

    private int countNodeIntersections(Collection<Widget> nodeWidgets, Line2D ... lines) {
        int count = 0;
        for (Widget nw : nodeWidgets) {
            if (!nw.isVisible()) continue;
            Rectangle bounds = nw.convertLocalToScene(nw.getBounds());
            for (Line2D line : lines) {
                if (!line.intersects(bounds)) continue;
                ++count;
            }
        }
        return count;
    }

    private boolean intersects(Collection<Widget> nodeWidgets, Point start, Point end) {
        ArrayList<Point> pointlist = new ArrayList<Point>();
        pointlist.add(start);
        pointlist.add(end);
        for (Widget w : nodeWidgets) {
            if (!w.isVisible() || !this.intersects(w, pointlist)) continue;
            return true;
        }
        return false;
    }

    private boolean intersects(Widget w, List<Point> list) {
        Rectangle r = w.convertLocalToScene(w.getBounds());
        r.grow(3, 3);
        return this.intersects(list, r);
    }

    private boolean intersects(List<Point> list, Rectangle rect) {
        for (int i = 1; i < list.size(); ++i) {
            Point cur = list.get(i - 1);
            Point next = list.get(i);
            if (!rect.intersectsLine(cur.x, cur.y, next.x, next.y)) continue;
            return true;
        }
        return false;
    }

    private int crossProduct(Point p1, Point p2, Point p3) {
        Point off1 = new Point(p1.x - p2.x, p1.y - p2.y);
        Point off2 = new Point(p3.x - p2.x, p3.y - p2.y);
        return off1.x * off2.y - off1.y * off2.x;
    }
}

