/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.modelimpl;

import at.ssw.visualizer.model.Compilation;
import at.ssw.visualizer.model.CompilationModel;
import at.ssw.visualizer.modelimpl.CompilationImpl;
import at.ssw.visualizer.parser.CompilationParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CompilationModelImpl
implements CompilationModel {
    private List<Compilation> compilations = new ArrayList<Compilation>();
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private boolean parsing;

    @Override
    public List<Compilation> getCompilations() {
        return Collections.unmodifiableList(this.compilations);
    }

    @Override
    public String parseInputFile(String fileName) {
        String result;
        this.parsing = true;
        try {
            result = CompilationParser.parseInputFile(fileName, this);
        }
        finally {
            this.parsing = false;
            this.notifyListeners();
        }
        return result;
    }

    public void addCompilation(CompilationImpl compilation) {
        this.compilations.add(compilation);
        compilation.setCompilationModel(this);
        if (!this.parsing || this.compilations.size() % 40 == 0) {
            this.notifyListeners();
        }
    }

    @Override
    public void removeCompilation(Compilation compilation) {
        this.compilations.remove(compilation);
        this.notifyListeners();
    }

    @Override
    public void clear() {
        this.compilations.clear();
        this.notifyListeners();
    }

    @Override
    public void addChangedListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeChangedListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Compilations: ");
        result.append(this.compilations.size());
        result.append("\n");
        for (Compilation compilation : this.compilations) {
            result.append(compilation);
        }
        return result.toString();
    }
}

