/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.modelimpl.cfg;

import at.ssw.visualizer.model.bc.Bytecodes;
import at.ssw.visualizer.model.cfg.BasicBlock;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import at.ssw.visualizer.model.nc.NativeMethod;
import at.ssw.visualizer.modelimpl.CompilationElementImpl;
import at.ssw.visualizer.modelimpl.cfg.BasicBlockImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ControlFlowGraphImpl
extends CompilationElementImpl
implements ControlFlowGraph {
    private BasicBlock[] basicBlocks;
    private Map<String, BasicBlock> blockNames;
    private Bytecodes bytecodes;
    private NativeMethod nativeMethod;
    private boolean hasState;
    private boolean hasHir;
    private boolean hasLir;

    public ControlFlowGraphImpl(String shortName, String name, BasicBlockImpl[] basicBlocks) {
        super(shortName, name);
        this.basicBlocks = basicBlocks;
        this.blockNames = new HashMap<String, BasicBlock>(basicBlocks.length);
        this.nativeMethod = null;
        for (BasicBlockImpl block : basicBlocks) {
            block.setParent(this);
            this.blockNames.put(block.getName(), block);
            this.hasState |= block.hasState();
            this.hasHir |= block.hasHir();
            this.hasLir |= block.hasLir();
        }
    }

    @Override
    public List<BasicBlock> getBasicBlocks() {
        return Collections.unmodifiableList(Arrays.asList(this.basicBlocks));
    }

    @Override
    public BasicBlock getBasicBlockByName(String name) {
        return this.blockNames.get(name);
    }

    @Override
    public Bytecodes getBytecodes() {
        return this.bytecodes;
    }

    public void setBytecodes(Bytecodes bytecodes) {
        this.bytecodes = bytecodes;
    }

    @Override
    public NativeMethod getNativeMethod() {
        return this.nativeMethod;
    }

    public void setNativeMethod(NativeMethod nativeMethod) {
        this.nativeMethod = nativeMethod;
    }

    @Override
    public boolean hasState() {
        return this.hasState;
    }

    @Override
    public boolean hasHir() {
        return this.hasHir;
    }

    @Override
    public boolean hasLir() {
        return this.hasLir;
    }

    public String toString() {
        return "    CFG \"" + this.getName() + "\": " + this.basicBlocks.length + " blocks\n";
    }
}

